/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.util;

import java.io.IOException;
import java.io.OutputStream;
import macromedia.sequelink.util.UtilMessage;

public class OutputStreamOnByteArray
extends OutputStream {
    protected byte[] array;
    protected int begin;
    protected int end;
    protected int position;

    public OutputStreamOnByteArray(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public OutputStreamOnByteArray(byte[] byArray, int n2, int n3) {
        this.array = byArray;
        this.begin = n2;
        this.end = n3;
        this.position = n2;
    }

    public final void write(int n2) throws IOException {
        if (this.position >= this.end) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.ba.oob"));
        }
        this.array[this.position++] = (byte)n2;
    }

    public final void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 <= 0) {
            return;
        }
        int n4 = this.position + n3 > this.end ? this.end - this.position : n3;
        System.arraycopy(byArray, n2, this.array, this.position, n4);
        this.position += n4;
        if (n4 < n3) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.ba.oob"));
        }
    }

    public final void reset() {
        this.position = this.begin;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n2) throws IOException {
        if (n2 < this.begin) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.ba.oob"));
        }
        if (n2 > this.end) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.ba.oob"));
        }
        this.position = n2;
    }

    public final int getFreeSpace() {
        return this.end - this.position;
    }

    public final int size() {
        return this.position - this.begin;
    }
}

