/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseEscape;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseSQLTreeNode;

public class BaseJoinEscape
extends BaseEscape {
    private BaseSQLTreeNode ojRoot;
    private BaseSQLTreeNode ojCursor;
    private BaseSQLTreeNode trCursor;
    private int joinOperator;
    public static final int NODE_RIGHT_OUTER_JOIN_OP = 1036;
    public static final int NODE_FULL_OUTER_JOIN_OP = 1037;
    public static final int NODE_LEFT_OUTER_JOIN_OP = 1035;
    private BaseSQLTreeNode currentSearchConditionNode = null;
    private BaseSQLTreeNode currentTableNameNode = null;
    private boolean firstOuterJoinRequest = true;
    private boolean firstTableReferenceRequest = true;

    public BaseJoinEscape(BaseSQLTreeNode baseSQLTreeNode, BaseExceptions baseExceptions) {
        super(baseSQLTreeNode, baseExceptions);
        this.ojRoot = baseSQLTreeNode.leftMostChild();
        this.ojRoot = this.ojRoot.getRightSibling();
        this.ojRoot = this.ojRoot.getRightSibling();
    }

    public boolean moveToNextOuterJoin() {
        boolean bl2 = true;
        if (this.firstOuterJoinRequest) {
            this.ojCursor = this.ojRoot;
            while (this.isJoinOperator(this.ojCursor.type)) {
                this.ojCursor = this.ojCursor.leftMostChild();
                this.ojCursor = this.ojCursor.getRightSibling();
                this.ojCursor = this.ojCursor.getRightSibling();
            }
            this.firstOuterJoinRequest = false;
        }
        this.ojCursor = this.ojCursor.getRightSibling();
        if (this.ojCursor.value.equals("}")) {
            bl2 = false;
        }
        if (bl2) {
            this.currentSearchConditionNode = this.ojCursor.getRightSibling();
            this.ojCursor = this.ojCursor.getParent();
            this.joinOperator = this.ojCursor.type;
        } else {
            this.currentSearchConditionNode = null;
            this.joinOperator = 1016;
            bl2 = false;
        }
        return bl2;
    }

    public boolean moveToNextTableReference() {
        boolean bl2 = true;
        if (this.firstTableReferenceRequest) {
            this.trCursor = this.ojRoot;
            this.joinOperator = this.trCursor.type;
            this.currentTableNameNode = this.trCursor = this.trCursor.leftMostChild();
            this.firstTableReferenceRequest = false;
        } else {
            this.trCursor = this.trCursor.getRightSibling();
            this.trCursor = this.trCursor.getRightSibling();
            if (this.trCursor.type == 1023) {
                this.currentTableNameNode = this.trCursor;
            } else if (this.isJoinOperator(this.trCursor.type)) {
                this.currentTableNameNode = this.trCursor = this.trCursor.leftMostChild();
            } else if (this.trCursor.type == 1038) {
                bl2 = false;
                this.currentTableNameNode = null;
            }
        }
        return bl2;
    }

    private boolean isJoinOperator(int n2) {
        return 1035 == n2 || 1036 == n2 || 1037 == n2;
    }

    public String getCurrentSearchCondition() {
        if (this.currentSearchConditionNode == null) {
            return null;
        }
        try {
            return this.generator.generateSQL(this.currentSearchConditionNode, false, this.exceptions);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public int getCurrentJoinOperator() {
        return this.joinOperator;
    }

    public String getCurrentTableName() {
        BaseSQLTreeNode baseSQLTreeNode = this.currentTableNameNode.leftMostChild();
        try {
            return this.generator.generateSQL(baseSQLTreeNode, false, this.exceptions);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public String getCurrentCorrelationName() {
        BaseSQLTreeNode baseSQLTreeNode = this.currentTableNameNode.leftMostChild();
        if ((baseSQLTreeNode = baseSQLTreeNode.getRightSibling()) == null) {
            return null;
        }
        try {
            return this.generator.generateSQL(baseSQLTreeNode, false, this.exceptions);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }
}

