/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseCharacterStreamWrapper;
import macromedia.jdbc.slbase.BaseColumn;
import macromedia.jdbc.slbase.BaseColumns;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseImplResultSetService;
import macromedia.jdbc.slbase.BaseInputStreamWrapper;
import macromedia.jdbc.slbase.BaseTimestamp;
import macromedia.slutil.UtilSmallDecimal;
import macromedia.slutil.UtilStringFunctions;

public final class BaseImplResultSetClientSideUpdatable
extends BaseImplResultSetService {
    private String tableName;
    private BaseColumns columns;
    private BaseData[] keyValues;
    private boolean[] keyValueObtained;
    private BaseData[] updatedValues;
    private BaseConnection connection;
    private PreparedStatement updateStatement;
    private PreparedStatement deleteStatement;
    private PreparedStatement insertStatement;
    private int[] previousUpdateColumns;
    private int[] previousDeleteColumns;
    private int[] previousInsertColumns;
    boolean onInsertRow;
    String identifierQuote;

    BaseImplResultSetClientSideUpdatable(BaseConnection baseConnection, String string, BaseColumns baseColumns, String string2) throws SQLException {
        this.connection = baseConnection;
        this.tableName = string;
        this.columns = baseColumns;
        this.identifierQuote = string2;
        this.onInsertRow = false;
    }

    public void close() throws SQLException {
        super.close();
        if (this.updateStatement != null) {
            this.updateStatement.close();
        }
        if (this.deleteStatement != null) {
            this.deleteStatement.close();
        }
        if (this.insertStatement != null) {
            this.insertStatement.close();
        }
    }

    public int getConcurrency() {
        return 1008;
    }

    public BaseData getData(int n2, int n3) throws SQLException {
        if (this.updatedValues != null && this.updatedValues[n2 - 1] != null) {
            return this.updatedValues[n2 - 1];
        }
        if (this.onInsertRow) {
            String[] stringArray = new String[]{Integer.toString(n2)};
            throw this.exceptions.getException(6102, stringArray);
        }
        if (this.subImplResultSet.getColumnAccess() == 1) {
            this.cacheKeyDataUpToColumn(n2);
        }
        BaseData baseData = this.subImplResultSet.getData(n2, n3);
        this.setupKeyValues();
        if (this.keyValues[n2 - 1] == null) {
            this.keyValues[n2 - 1] = new BaseData(this.connection);
        }
        this.keyValues[n2 - 1].populate(baseData);
        this.keyValueObtained[n2 - 1] = true;
        return baseData;
    }

    private void cacheKeyDataUpToColumn(int n2) throws SQLException {
        this.setupKeyValues();
        --n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.keyValueObtained[i2] || !this.columns.get((int)(i2 + 1)).isKey) continue;
            BaseData baseData = this.subImplResultSet.getData(i2 + 1, this.columns.get((int)(i2 + 1)).baseDataType);
            if (this.keyValues[i2] == null) {
                this.keyValues[i2] = new BaseData(this.connection);
            }
            this.keyValues[i2].populate(baseData);
            this.keyValueObtained[i2] = true;
        }
    }

    public void updateData(int n2, BaseData baseData) throws SQLException {
        if (this.subImplResultSet.getColumnAccess() == 1 && !this.onInsertRow) {
            this.cacheKeyDataUpToColumn(n2 + 1);
        }
        this.setupUpdatedValues();
        this.updatedValues[n2 - 1] = baseData;
    }

    public void updateRow() throws SQLException {
        this.setupPreviousColumnsLists();
        this.setupUpdatedValues();
        if (this.getUpdatedValuesCount() == 0) {
            return;
        }
        this.updateStatement = this.executeStatement(this.updateStatement, this.previousUpdateColumns, "UPDATE " + this.tableName + " set ", " = ? ", true, "", "WHERE ", 6057, 6056);
    }

    public void cancelUpdates() throws SQLException {
        if (this.updatedValues != null) {
            for (int i2 = 0; i2 < this.updatedValues.length; ++i2) {
                this.updatedValues[i2] = null;
            }
        }
    }

    public void deleteRow() throws SQLException {
        this.setupPreviousColumnsLists();
        this.deleteStatement = this.executeStatement(this.deleteStatement, this.previousDeleteColumns, "DELETE FROM " + this.tableName, null, false, " ", " WHERE ", 6057, 6059);
    }

    public void prepareInsertRow() throws SQLException {
        this.cancelUpdates();
        this.onInsertRow = true;
    }

    public void cancelInsertRow() throws SQLException {
        this.cancelUpdates();
        this.onInsertRow = false;
    }

    public void insertRow() throws SQLException {
        this.setupPreviousColumnsLists();
        String string = "INSERT INTO " + this.tableName;
        this.setupUpdatedValues();
        int n2 = this.columns.count(1);
        boolean bl2 = false;
        if (this.getUpdatedValuesCount() == 0) {
            switch (this.connection.implConnection.getEmptyRowInsertSyntax()) {
                case 1: {
                    string = string + " default values";
                    break;
                }
                case 2: {
                    string = string + " values ()";
                    break;
                }
                case 3: {
                    string = string + " values (";
                    int n3 = this.columns.count(1);
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (i2 != 0) {
                            string = string + ",";
                        }
                        string = string + "default";
                    }
                    string = string + " )";
                    break;
                }
                case 4: {
                    string = string + " values (";
                    int n4 = this.columns.count(1);
                    for (int i3 = 0; i3 < n4; ++i3) {
                        if (i3 != 0) {
                            string = string + ",";
                        }
                        string = string + "NULL";
                    }
                    string = string + " )";
                    break;
                }
                default: {
                    throw this.implStatement.implConnection.exceptions.getException(6076);
                }
            }
            this.insertStatement = this.executeStatement(this.insertStatement, this.previousInsertColumns, string, "", false, "", null, 6062, 0);
        } else {
            string = string + " (";
            for (int i4 = 0; i4 < n2; ++i4) {
                BaseColumn baseColumn = this.columns.get(i4 + 1);
                if (this.updatedValues[i4] == null) continue;
                if (bl2) {
                    string = string + ", ";
                } else {
                    bl2 = true;
                }
                string = string + this.identifierQuote + baseColumn.name + this.identifierQuote;
            }
            string = string + ") VALUES (";
            this.insertStatement = this.executeStatement(this.insertStatement, this.previousInsertColumns, string, "? ", false, ")", null, 6062, 0);
        }
    }

    public PreparedStatement executeStatement(PreparedStatement preparedStatement, int[] nArray, String string, String string2, boolean bl2, String string3, String string4, int n2, int n3) throws SQLException {
        int n4;
        String[] stringArray;
        BaseColumn baseColumn;
        int n5 = 0;
        int n6 = this.getUpdatedValuesCount();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl3 = false;
        n5 = this.columns.count(0);
        if (string4 != null) {
            this.cacheKeyDataUpToColumn(n5 + 1);
            n8 = this.columns.count(3);
        }
        if (this.statementNeedsBuilding(preparedStatement, nArray)) {
            for (int i2 = 0; i2 < n5; ++i2) {
                baseColumn = this.columns.get(i2 + 1);
                if (string2 != null && i2 < this.updatedValues.length && this.updatedValues[i2] != null) {
                    boolean bl4 = true;
                    if (bl2) {
                        string = string + this.identifierQuote + UtilStringFunctions.trim(baseColumn.name, 2) + this.identifierQuote;
                    }
                    string = string + string2;
                    if (++n7 < n6 && bl4) {
                        string = string + ", ";
                    }
                }
                if (string4 == null || !baseColumn.isKey) continue;
                string4 = this.keyValueObtained[i2] && this.keyValues[i2].isNull() ? string4 + this.identifierQuote + UtilStringFunctions.trim(baseColumn.name, 2) + this.identifierQuote + " IS NULL " : string4 + this.identifierQuote + UtilStringFunctions.trim(baseColumn.name, 2) + this.identifierQuote + " = ? ";
                if (n9 < n8 - 1) {
                    string4 = string4 + "and ";
                }
                ++n9;
            }
            String string5 = string + string3;
            if (string4 != null) {
                string5 = string5 + string4;
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            stringArray = this.connection.statementPool;
            this.connection.statementPool = null;
            preparedStatement = this.connection.prepareStatement(string5);
            this.connection.statementPool = stringArray;
            bl3 = true;
        }
        n7 = 0;
        n9 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            baseColumn = this.columns.get(n4 + 1);
            if (string2 != null && n4 < this.updatedValues.length && this.updatedValues[n4] != null) {
                this.setParameter(preparedStatement, n7 + 1, this.updatedValues[n4], baseColumn, false);
                ++n7;
            }
            if (string4 == null || !this.keyValueObtained[n4] || !baseColumn.isKey || this.keyValues[n4].isNull()) continue;
            this.setParameter(preparedStatement, n6 + n9 + 1, this.keyValues[n4], baseColumn, true);
            ++n9;
        }
        this.cacheBoundColumns(nArray);
        n4 = 0;
        try {
            n4 = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            if (bl3) {
                preparedStatement.close();
            }
            throw this.implStatement.implConnection.exceptions.getException(sQLException, n2);
        }
        if (n4 > 1) {
            stringArray = new String[]{Integer.toString(n4)};
            this.warnings.add(n3, stringArray);
        } else if (n4 != 1) {
            throw this.implStatement.implConnection.exceptions.getException(n2);
        }
        return preparedStatement;
    }

    private void setupKeyValues() {
        if (this.keyValues == null) {
            int n2 = this.columns.count(0);
            this.keyValues = new BaseData[n2];
            this.keyValueObtained = new boolean[n2];
        }
    }

    private void setupUpdatedValues() {
        if (this.updatedValues == null) {
            this.updatedValues = new BaseData[this.columns.count(1)];
        }
    }

    private void setupPreviousColumnsLists() {
        int n2 = this.columns.count(0) * 2 + 1;
        if (this.previousDeleteColumns == null) {
            this.previousDeleteColumns = new int[n2];
            this.previousDeleteColumns[0] = 0;
        }
        if (this.previousInsertColumns == null) {
            this.previousInsertColumns = new int[n2];
            this.previousInsertColumns[0] = 0;
        }
        if (this.previousUpdateColumns == null) {
            this.previousUpdateColumns = new int[n2];
            this.previousUpdateColumns[0] = 0;
        }
    }

    private int getUpdatedValuesCount() {
        int n2 = 0;
        if (this.updatedValues != null) {
            for (int i2 = 0; i2 < this.updatedValues.length; ++i2) {
                if (this.updatedValues[i2] == null) continue;
                ++n2;
            }
        }
        return n2;
    }

    private int getKeyValuesCount() {
        int n2 = 0;
        if (this.keyValues != null) {
            for (int i2 = 0; i2 < this.keyValues.length; ++i2) {
                if (!this.keyValueObtained[i2] || this.keyValues[i2].isNull()) continue;
                ++n2;
            }
        }
        return n2;
    }

    private void setParameter(PreparedStatement preparedStatement, int n2, BaseData baseData, BaseColumn baseColumn, boolean bl2) throws SQLException {
        BaseInputStreamWrapper baseInputStreamWrapper = null;
        BaseCharacterStreamWrapper baseCharacterStreamWrapper = null;
        if (baseData.isNull()) {
            preparedStatement.setNull(n2, baseColumn.type);
        } else {
            switch (baseData.getType()) {
                case 15: {
                    baseInputStreamWrapper = (BaseInputStreamWrapper)baseData.getASCIIStream(-1, this.connection, this.implStatement.implConnection.exceptions);
                    preparedStatement.setAsciiStream(n2, (InputStream)baseInputStreamWrapper, (int)baseInputStreamWrapper.numTotalBytesInStream);
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    baseCharacterStreamWrapper = (BaseCharacterStreamWrapper)baseData.getCharacterStreamReader(-1, this.connection, this.implStatement.implConnection.exceptions);
                    preparedStatement.setCharacterStream(n2, (Reader)baseCharacterStreamWrapper, (int)baseCharacterStreamWrapper.numTotalCharsInReader);
                    break;
                }
                case 14: {
                    baseInputStreamWrapper = (BaseInputStreamWrapper)baseData.getBinaryStream(-1, this.connection, this.implStatement.implConnection.exceptions);
                    preparedStatement.setBinaryStream(n2, (InputStream)baseInputStreamWrapper, (int)baseInputStreamWrapper.numTotalBytesInStream);
                    break;
                }
                case 21: {
                    preparedStatement.setDouble(n2, ((UtilSmallDecimal)baseData.getObject()).doubleValue());
                    break;
                }
                default: {
                    Object object = baseData.getObject();
                    if (object instanceof BaseTimestamp) {
                        object = ((BaseTimestamp)object).getTimestamp();
                    }
                    preparedStatement.setObject(n2, object);
                }
            }
        }
    }

    private boolean statementNeedsBuilding(PreparedStatement preparedStatement, int[] nArray) {
        int n2;
        int n3;
        if (preparedStatement == null) {
            return true;
        }
        if (nArray[0] != this.getUpdatedValuesCount() + this.getKeyValuesCount()) {
            return true;
        }
        if (this.updatedValues != null) {
            for (n3 = 0; n3 < this.updatedValues.length; ++n3) {
                if (this.updatedValues[n3] == null) continue;
                for (n2 = 0; n2 < nArray[0] && nArray[n2 + 1] != n3; ++n2) {
                }
                if (n2 != nArray[0]) continue;
                return true;
            }
        }
        if (this.keyValues != null) {
            for (n3 = 0; n3 < this.keyValues.length; ++n3) {
                if (!this.keyValueObtained[n3] || this.keyValues[n3].isNull()) continue;
                for (n2 = 0; n2 < nArray[0] && nArray[n2 + 1] != n3 + 10000; ++n2) {
                }
                if (n2 != nArray[0]) continue;
                return true;
            }
        }
        return false;
    }

    private void cacheBoundColumns(int[] nArray) {
        int n2;
        int n3 = 1;
        if (this.updatedValues != null) {
            for (n2 = 0; n2 < this.updatedValues.length; ++n2) {
                if (this.updatedValues[n2] == null) continue;
                nArray[n3] = n2;
                ++n3;
            }
        }
        if (this.keyValues != null) {
            for (n2 = 0; n2 < this.keyValues.length; ++n2) {
                if (!this.keyValueObtained[n2] || this.keyValues[n2].isNull()) continue;
                nArray[n3] = n2 + 10000;
                ++n3;
            }
        }
        nArray[0] = n3 - 1;
    }

    private void commonUpdateInitialize() {
        if (this.keyValueObtained != null) {
            for (int i2 = 0; i2 < this.keyValueObtained.length; ++i2) {
                this.keyValueObtained[i2] = false;
            }
        }
        this.updatedValues = null;
    }

    public boolean fetchAtPosition(int n2) throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.fetchAtPosition(n2);
    }

    protected boolean next() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.next();
    }

    protected boolean previous() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.previous();
    }

    protected boolean absolute(int n2) throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.absolute(n2);
    }

    protected boolean relative(int n2) throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.relative(n2);
    }

    protected void refreshRow() throws SQLException {
        this.subImplResultSet.refreshRow();
    }

    protected boolean first() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.first();
    }

    protected boolean last() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.last();
    }

    protected void beforeFirst() throws SQLException {
        this.commonUpdateInitialize();
        this.subImplResultSet.beforeFirst();
    }

    protected void afterLast() throws SQLException {
        this.commonUpdateInitialize();
        this.subImplResultSet.afterLast();
    }

    protected boolean isBeforeFirst() throws SQLException {
        return this.subImplResultSet.isBeforeFirst();
    }

    protected boolean isAfterLast() throws SQLException {
        return this.subImplResultSet.isAfterLast();
    }

    protected boolean isFirst() throws SQLException {
        return this.subImplResultSet.isFirst();
    }

    protected boolean isLast() throws SQLException {
        return this.subImplResultSet.isLast();
    }

    protected int getRow() throws SQLException {
        return this.subImplResultSet.getRow();
    }

    protected boolean isCursorPositionValid() throws SQLException {
        return this.subImplResultSet.isCursorPositionValid();
    }
}

