/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink.columns;

import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import macromedia.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import macromedia.jdbc.sequelink.columns.SequeLinkDateTimeColumn;
import macromedia.jdbc.sequelink.utilities.BooleanArray;
import macromedia.jdbc.sequelink.utilities.IntArray;
import macromedia.jdbc.sequelink.utilities.LongArray;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseTimestamp;
import macromedia.sequelink.ctxt.stmt.StatementContext;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.slutil.UtilException;

public class SequeLinkTimestampColumn
extends SequeLinkDateTimeColumn {
    private LongArray datetime;
    private IntArray nanos;
    private BooleanArray isNull;

    public SequeLinkTimestampColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe, int n2) throws SQLException {
        super(statementContext, sequeLinkColumnDescribe, n2, 13);
        this.out = new char[29];
        this.datetime = new LongArray();
        this.nanos = this.displaySize == 19 ? null : new IntArray();
        this.isNull = new BooleanArray();
    }

    protected void setBindInfo() {
        this.sqlnkType = 10;
        this.sqlnkSize = 11;
    }

    protected void readDataFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        int n2 = sspInputStream.readSSPInt16();
        n2 <<= 4;
        n2 |= sspInputStream.readSSPInt8() - 1;
        n2 <<= 5;
        int n3 = sspInputStream.readSSPInt8();
        n3 <<= 6;
        n3 |= sspInputStream.readSSPInt8();
        n3 <<= 6;
        long l2 = n2 |= sspInputStream.readSSPInt8();
        l2 <<= 32;
        this.datetime.add(l2 |= (long)(n3 |= sspInputStream.readSSPInt8()));
        int n4 = sspInputStream.readSSPFullInt32();
        if (this.nanos != null) {
            this.nanos.add(n4);
        }
        this.isNull.add(false);
    }

    protected void readNull() {
        this.datetime.add(0L);
        if (this.nanos != null) {
            this.nanos.add(0);
        }
        this.isNull.add(true);
    }

    public void clearData() {
        this.datetime.reset();
        if (this.nanos != null) {
            this.nanos.reset();
        }
        this.isNull.reset();
    }

    public BaseData getData(int n2, int n3, DiagnosticList diagnosticList) throws SQLException {
        if (this.isNull.get(n3)) {
            this.myBaseData.setNull(this.baseDataType);
            return this.myBaseData;
        }
        long l2 = this.datetime.get(n3);
        int n4 = (int)l2;
        int n5 = (int)(l2 >> 32);
        int n6 = n4 & 0x3F;
        int n7 = (n4 >>= 6) & 0x3F;
        int n8 = n4 >>= 6;
        int n9 = n5 & 0x1F;
        int n10 = (n5 >>= 5) & 0xF;
        int n11 = n5 >>= 4;
        switch (n2) {
            case 13: {
                BaseTimestamp baseTimestamp = new BaseTimestamp(n11, n10, n9, n8, n7, n6, this.nanos == null ? 0 : this.nanos.get(n3), null);
                this.myBaseData.setTimestamp(baseTimestamp);
                break;
            }
            case 10: {
                String string = this.getTimestampString(n11, n10, n9, n8, n7, n6, this.nanos == null ? 0 : this.nanos.get(n3));
                this.myBaseData.setString(string);
                break;
            }
            case 11: {
                Date date = new Date(n11 - 1900, n10, n9);
                this.myBaseData.setDate(date);
                break;
            }
            case 12: {
                Time time = new Time(n8, n7, n6);
                this.myBaseData.setTime(time);
                break;
            }
            default: {
                BaseTimestamp baseTimestamp = new BaseTimestamp(n11, n10, n9, n8, n7, n6, this.nanos == null ? 0 : this.nanos.get(n3), null);
                this.myBaseData.setTimestamp(baseTimestamp);
            }
        }
        return this.myBaseData;
    }

    private String getTimestampString(int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws SQLException {
        this.pos = 0;
        this.writeInt(n2, 4);
        this.out[this.pos++] = 45;
        this.writeInt(n3 + 1, 2);
        this.out[this.pos++] = 45;
        this.writeInt(n4, 2);
        this.out[this.pos++] = 32;
        this.writeInt(n5, 2);
        this.out[this.pos++] = 58;
        this.writeInt(n6, 2);
        this.out[this.pos++] = 58;
        this.writeInt(n7, 2);
        if (this.nanos == null) {
            return new String(this.out, 0, this.pos);
        }
        this.out[this.pos++] = 46;
        this.writeInt(n8, 9);
        return new String(this.out, 0, this.displaySize);
    }
}

