/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss;

import java.security.SecureRandom;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.KeyGenerationParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.BDS;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.XMSSMTKeyGenerationParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.XMSSNode;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.XMSSParameters;

public final class XMSSMTKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private XMSSMTParameters params;
    private XMSSParameters xmssParams;
    private SecureRandom prng;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        XMSSMTKeyGenerationParameters xMSSMTKeyGenerationParameters = (XMSSMTKeyGenerationParameters)keyGenerationParameters;
        this.prng = xMSSMTKeyGenerationParameters.getRandom();
        this.params = xMSSMTKeyGenerationParameters.getParameters();
        this.xmssParams = this.params.getXMSSParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.generatePrivateKey(new XMSSMTPrivateKeyParameters.Builder(this.params).build().getBDSState());
        this.xmssParams.getWOTSPlus().importKeys(new byte[this.params.getTreeDigestSize()], xMSSMTPrivateKeyParameters.getPublicSeed());
        int n2 = this.params.getLayers() - 1;
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(n2)).build();
        BDS bDS = new BDS(this.xmssParams, xMSSMTPrivateKeyParameters.getPublicSeed(), xMSSMTPrivateKeyParameters.getSecretKeySeed(), oTSHashAddress);
        XMSSNode xMSSNode = bDS.getRoot();
        xMSSMTPrivateKeyParameters.getBDSState().put(n2, bDS);
        xMSSMTPrivateKeyParameters = new XMSSMTPrivateKeyParameters.Builder(this.params).withSecretKeySeed(xMSSMTPrivateKeyParameters.getSecretKeySeed()).withSecretKeyPRF(xMSSMTPrivateKeyParameters.getSecretKeyPRF()).withPublicSeed(xMSSMTPrivateKeyParameters.getPublicSeed()).withRoot(xMSSNode.getValue()).withBDSState(xMSSMTPrivateKeyParameters.getBDSState()).build();
        XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters = new XMSSMTPublicKeyParameters.Builder(this.params).withRoot(xMSSNode.getValue()).withPublicSeed(xMSSMTPrivateKeyParameters.getPublicSeed()).build();
        return new AsymmetricCipherKeyPair(xMSSMTPublicKeyParameters, xMSSMTPrivateKeyParameters);
    }

    private XMSSMTPrivateKeyParameters generatePrivateKey(BDSStateMap bDSStateMap) {
        int n2 = this.params.getTreeDigestSize();
        byte[] byArray = new byte[n2];
        this.prng.nextBytes(byArray);
        byte[] byArray2 = new byte[n2];
        this.prng.nextBytes(byArray2);
        byte[] byArray3 = new byte[n2];
        this.prng.nextBytes(byArray3);
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = null;
        xMSSMTPrivateKeyParameters = new XMSSMTPrivateKeyParameters.Builder(this.params).withSecretKeySeed(byArray).withSecretKeyPRF(byArray2).withPublicSeed(byArray3).withBDSState(bDSStateMap).build();
        return xMSSMTPrivateKeyParameters;
    }
}

