/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss;

import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.XMSSUtil;

final class WOTSPlusPublicKeyParameters {
    private final byte[][] publicKey;

    protected WOTSPlusPublicKeyParameters(WOTSPlusParameters wOTSPlusParameters, byte[][] byArray) {
        if (wOTSPlusParameters == null) {
            throw new NullPointerException("params == null");
        }
        if (byArray == null) {
            throw new NullPointerException("publicKey == null");
        }
        if (XMSSUtil.hasNullPointer(byArray)) {
            throw new NullPointerException("publicKey byte array == null");
        }
        if (byArray.length != wOTSPlusParameters.getLen()) {
            throw new IllegalArgumentException("wrong publicKey size");
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2].length == wOTSPlusParameters.getTreeDigestSize()) continue;
            throw new IllegalArgumentException("wrong publicKey format");
        }
        this.publicKey = XMSSUtil.cloneArray(byArray);
    }

    protected byte[][] toByteArray() {
        return XMSSUtil.cloneArray(this.publicKey);
    }
}

