/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.lms;

import java.io.IOException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CipherParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.MessageSigner;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.lms.LMS;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.lms.LMSSignature;

public class LMSSigner
implements MessageSigner {
    private LMSPrivateKeyParameters privKey;
    private LMSPublicKeyParameters pubKey;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            this.privKey = (LMSPrivateKeyParameters)cipherParameters;
        } else {
            this.pubKey = (LMSPublicKeyParameters)cipherParameters;
        }
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        try {
            return LMS.generateSign(this.privKey, byArray).getEncoded();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode signature: " + iOException.getMessage());
        }
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        try {
            return LMS.verifySignature(this.pubKey, LMSSignature.getInstance(byArray2), byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to decode signature: " + iOException.getMessage());
        }
    }
}

