/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.parsers;

import java.io.IOException;
import java.io.InputStream;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.KeyParser;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.X448PublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.io.Streams;

public class XIESPublicKeyParser
implements KeyParser {
    private final boolean isX25519;

    public XIESPublicKeyParser(boolean bl2) {
        this.isX25519 = bl2;
    }

    @Override
    public AsymmetricKeyParameter readKey(InputStream inputStream) throws IOException {
        int n2 = this.isX25519 ? 32 : 56;
        byte[] byArray = new byte[n2];
        Streams.readFully(inputStream, byArray, 0, byArray.length);
        return this.isX25519 ? new X25519PublicKeyParameters(byArray, 0) : new X448PublicKeyParameters(byArray, 0);
    }
}

