/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.kems;

import java.security.SecureRandom;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CipherParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CryptoServicePurpose;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.DerivationFunction;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.KeyEncapsulation;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.SecretWithEncapsulation;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.constraints.ConstraintUtils;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.kems.ECIESKEMExtractor;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.kems.ECIESKEMGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ECKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;

public class ECIESKeyEncapsulation
implements KeyEncapsulation {
    private DerivationFunction kdf;
    private SecureRandom rnd;
    private ECKeyParameters key;
    private boolean CofactorMode;
    private boolean OldCofactorMode;
    private boolean SingleHashMode;

    public ECIESKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom) {
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
        this.CofactorMode = false;
        this.OldCofactorMode = false;
        this.SingleHashMode = false;
    }

    public ECIESKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom, boolean bl2, boolean bl3, boolean bl4) {
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
        this.CofactorMode = bl2;
        this.OldCofactorMode = bl2 ? false : bl3;
        this.SingleHashMode = bl4;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ECKeyParameters)) {
            throw new IllegalArgumentException("EC key required");
        }
        this.key = (ECKeyParameters)cipherParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("ECIESKem", ConstraintUtils.bitsOfSecurityFor(this.key.getParameters().getCurve()), cipherParameters, CryptoServicePurpose.ANY));
    }

    @Override
    public CipherParameters encrypt(byte[] byArray, int n2, int n3) throws IllegalArgumentException {
        if (!(this.key instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        ECIESKEMGenerator eCIESKEMGenerator = new ECIESKEMGenerator(n3, this.kdf, this.rnd, this.CofactorMode, this.OldCofactorMode, this.SingleHashMode);
        SecretWithEncapsulation secretWithEncapsulation = eCIESKEMGenerator.generateEncapsulated(this.key);
        byte[] byArray2 = secretWithEncapsulation.getEncapsulation();
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return new KeyParameter(secretWithEncapsulation.getSecret());
    }

    public CipherParameters encrypt(byte[] byArray, int n2) {
        return this.encrypt(byArray, 0, n2);
    }

    @Override
    public CipherParameters decrypt(byte[] byArray, int n2, int n3, int n4) throws IllegalArgumentException {
        if (!(this.key instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("Private key required for encryption");
        }
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)this.key;
        ECIESKEMExtractor eCIESKEMExtractor = new ECIESKEMExtractor(eCPrivateKeyParameters, n4, this.kdf, this.CofactorMode, this.OldCofactorMode, this.SingleHashMode);
        byte[] byArray2 = eCIESKEMExtractor.extractSecret(Arrays.copyOfRange(byArray, n2, n2 + n3));
        return new KeyParameter(byArray2);
    }

    public CipherParameters decrypt(byte[] byArray, int n2) {
        return this.decrypt(byArray, 0, byArray.length, n2);
    }
}

