/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.agreement.kdf;

import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.DerivationParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.Digest;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.DigestDerivationFunction;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.agreement.kdf.GSKKDFParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Pack;

public class GSKKFDGenerator
implements DigestDerivationFunction {
    private final Digest digest;
    private byte[] z;
    private int counter;
    private byte[] r;
    private byte[] buf;

    public GSKKFDGenerator(Digest digest) {
        this.digest = digest;
        this.buf = new byte[digest.getDigestSize()];
    }

    @Override
    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof GSKKDFParameters)) {
            throw new IllegalArgumentException("unkown parameters type");
        }
        this.z = ((GSKKDFParameters)derivationParameters).getZ();
        this.counter = ((GSKKDFParameters)derivationParameters).getStartCounter();
        this.r = ((GSKKDFParameters)derivationParameters).getNonce();
    }

    @Override
    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("output buffer too small");
        }
        this.digest.update(this.z, 0, this.z.length);
        byte[] byArray2 = Pack.intToBigEndian(this.counter++);
        this.digest.update(byArray2, 0, byArray2.length);
        if (this.r != null) {
            this.digest.update(this.r, 0, this.r.length);
        }
        this.digest.doFinal(this.buf, 0);
        System.arraycopy(this.buf, 0, byArray, n2, n3);
        Arrays.clear(this.buf);
        return n3;
    }
}

