/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.agreement;

import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CipherParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.RawAgreement;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.agreement.Utils;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.X448PublicKeyParameters;

public final class X448Agreement
implements RawAgreement {
    private X448PrivateKeyParameters privateKey;

    @Override
    public void init(CipherParameters cipherParameters) {
        this.privateKey = (X448PrivateKeyParameters)cipherParameters;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties("X448", this.privateKey));
    }

    @Override
    public int getAgreementSize() {
        return 56;
    }

    @Override
    public void calculateAgreement(CipherParameters cipherParameters, byte[] byArray, int n2) {
        this.privateKey.generateSecret((X448PublicKeyParameters)cipherParameters, byArray, n2);
    }
}

