/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.x500;

import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Choice;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Encodable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Object;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1TaggedObject;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.DERSequence;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.x500.RDN;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.x500.X500NameStyle;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.x500.style.BCStyle;

public class X500Name
extends ASN1Object
implements ASN1Choice {
    private static X500NameStyle defaultStyle = BCStyle.INSTANCE;
    private boolean isHashCodeCalculated;
    private int hashCodeValue;
    private X500NameStyle style;
    private RDN[] rdns;
    private DERSequence rdnSeq;

    public X500Name(X500NameStyle x500NameStyle, X500Name x500Name) {
        this.style = x500NameStyle;
        this.rdns = x500Name.rdns;
        this.rdnSeq = x500Name.rdnSeq;
    }

    public static X500Name getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return X500Name.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, true));
    }

    public static X500Name getInstance(Object object) {
        if (object instanceof X500Name) {
            return (X500Name)object;
        }
        if (object != null) {
            return new X500Name(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static X500Name getInstance(X500NameStyle x500NameStyle, Object object) {
        if (object instanceof X500Name) {
            return new X500Name(x500NameStyle, (X500Name)object);
        }
        if (object != null) {
            return new X500Name(x500NameStyle, ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private X500Name(ASN1Sequence aSN1Sequence) {
        this(defaultStyle, aSN1Sequence);
    }

    private X500Name(X500NameStyle x500NameStyle, ASN1Sequence aSN1Sequence) {
        int n2 = aSN1Sequence.size();
        this.style = x500NameStyle;
        this.rdns = new RDN[n2];
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(i2);
            RDN rDN = RDN.getInstance(aSN1Encodable);
            bl2 &= rDN == aSN1Encodable;
            this.rdns[i2] = rDN;
        }
        this.rdnSeq = bl2 ? DERSequence.convert(aSN1Sequence) : new DERSequence(this.rdns);
    }

    public X500Name(RDN[] rDNArray) {
        this(defaultStyle, rDNArray);
    }

    public X500Name(X500NameStyle x500NameStyle, RDN[] rDNArray) {
        this.style = x500NameStyle;
        this.rdns = (RDN[])rDNArray.clone();
        this.rdnSeq = new DERSequence(this.rdns);
    }

    public X500Name(String string) {
        this(defaultStyle, string);
    }

    public X500Name(X500NameStyle x500NameStyle, String string) {
        this(x500NameStyle.fromString(string));
        this.style = x500NameStyle;
    }

    public RDN[] getRDNs() {
        return (RDN[])this.rdns.clone();
    }

    public ASN1ObjectIdentifier[] getAttributeTypes() {
        int n2 = this.rdns.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            RDN rDN = this.rdns[i2];
            n3 += rDN.size();
        }
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new ASN1ObjectIdentifier[n3];
        int n4 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            RDN rDN = this.rdns[i3];
            n4 += rDN.collectAttributeTypes(aSN1ObjectIdentifierArray, n4);
        }
        return aSN1ObjectIdentifierArray;
    }

    public RDN[] getRDNs(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        RDN[] rDNArray = new RDN[this.rdns.length];
        int n2 = 0;
        for (int i2 = 0; i2 != this.rdns.length; ++i2) {
            RDN rDN = this.rdns[i2];
            if (!rDN.containsAttributeType(aSN1ObjectIdentifier)) continue;
            rDNArray[n2++] = rDN;
        }
        if (n2 < rDNArray.length) {
            RDN[] rDNArray2 = new RDN[n2];
            System.arraycopy(rDNArray, 0, rDNArray2, 0, rDNArray2.length);
            rDNArray = rDNArray2;
        }
        return rDNArray;
    }

    public int size() {
        return this.rdns.length;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.rdnSeq;
    }

    @Override
    public int hashCode() {
        if (this.isHashCodeCalculated) {
            return this.hashCodeValue;
        }
        this.isHashCodeCalculated = true;
        this.hashCodeValue = this.style.calculateHashCode(this);
        return this.hashCodeValue;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X500Name) && !(object instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
        if (this.toASN1Primitive().equals(aSN1Primitive)) {
            return true;
        }
        try {
            return this.style.areEqual(this, X500Name.getInstance(object));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return this.style.toString(this);
    }

    public static void setDefaultStyle(X500NameStyle x500NameStyle) {
        if (x500NameStyle == null) {
            throw new NullPointerException("cannot set style to null");
        }
        defaultStyle = x500NameStyle;
    }

    public static X500NameStyle getDefaultStyle() {
        return defaultStyle;
    }
}

