/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1BitString;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1BitStringParser;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1ParsingException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.DefiniteLengthInputStream;

public class DLBitStringParser
implements ASN1BitStringParser {
    private final DefiniteLengthInputStream stream;
    private int padBits = 0;

    DLBitStringParser(DefiniteLengthInputStream definiteLengthInputStream) {
        this.stream = definiteLengthInputStream;
    }

    @Override
    public InputStream getBitStream() throws IOException {
        return this.getBitStream(false);
    }

    @Override
    public InputStream getOctetStream() throws IOException {
        return this.getBitStream(true);
    }

    @Override
    public int getPadBits() {
        return this.padBits;
    }

    @Override
    public ASN1Primitive getLoadedObject() throws IOException {
        return ASN1BitString.createPrimitive(this.stream.toByteArray());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("IOException converting stream to byte array: " + iOException.getMessage(), iOException);
        }
    }

    private InputStream getBitStream(boolean bl2) throws IOException {
        int n2 = this.stream.getRemaining();
        if (n2 < 1) {
            throw new IllegalStateException("content octets cannot be empty");
        }
        this.padBits = this.stream.read();
        if (this.padBits > 0) {
            if (n2 < 2) {
                throw new IllegalStateException("zero length data with non-zero pad bits");
            }
            if (this.padBits > 7) {
                throw new IllegalStateException("pad bits cannot be greater than 7 or less than 0");
            }
            if (bl2) {
                throw new IOException("expected octet-aligned bitstring, but found padBits: " + this.padBits);
            }
        }
        return this.stream;
    }
}

