/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.search;

import coldfusion.log.CFLogs;
import coldfusion.lucene.SolrServiceImpl;
import coldfusion.osgi.services.PDFService;
import coldfusion.runtime.CFDateTimeParser;
import coldfusion.runtime.Cast;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.QueryVector;
import coldfusion.runtime.Struct;
import coldfusion.search.exceptions.SearchExceptions;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SolrService;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.HttpTag;
import coldfusion.tagext.search.ExtensionMatcher;
import coldfusion.tagext.search.HTMLParser;
import coldfusion.tagext.search.IndexTag;
import coldfusion.tagext.search.MSDocument;
import coldfusion.tagext.search.Utils;
import coldfusion.util.MimeTypeUtils;
import coldfusion.util.PasswordUtils;
import coldfusion.util.RB;
import coldfusion.util.URLDecoder;
import coldfusion.util.URLEncoder;
import coldfusion.vfs.VFSFileFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.lucene.document.DateTools;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SolrUtils {
    private static final String ASC = "asc";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String[] fieldsNotRequired = new String[]{"spell", "modified", "mime", "contents", "uid"};
    private static final Set<String> fieldsNotReqSet = new HashSet<String>(Arrays.asList(fieldsNotRequired));
    private static final String SCORE = "score";
    private static final String KEY = "key";
    private static final String MODIFIED = "modified";
    private static final String UID = "uid";
    private static final String TITLE = "title";
    private static final String SUMMARY = "summary";
    private static final String AUTHOR = "author";
    private static final String URL = "url";
    private static final String SIZE = "size";
    private static final String MIME = "mime";
    private static final String CATEGORY = "category";
    private static final String CATEGORYTREE = "categorytree";
    private static final String DATEEXTENSION = "_dt";
    private static final String KEYWORDS = "Keywords";
    private static final String SUBJECT = "Subject";
    public static final String ERRORS = "ERRORS";
    public static final String DOCCOUNT = "doccount";
    private static String seed;
    private static Parser parser;
    private static Map<String, SolrClient> solrClientMap;

    private static long getSolrBufferSizeInBytes() {
        SolrService service = ServiceFactory.getSolrService();
        return service.getSolrBufferSize() * 1024 * 1024;
    }

    public static String getSolrURL(SolrService solrService) {
        SolrService service = ServiceFactory.getSolrService();
        boolean isHttpsRequired = Boolean.valueOf(service.getHttpsenabled());
        return SolrUtils._getSolrUrl(solrService, isHttpsRequired);
    }

    public static String getHttpsSolrURL(SolrService solrService) {
        return SolrUtils._getSolrUrl(solrService, true);
    }

    private static String _getSolrUrl(SolrService solrService, boolean isHttps) {
        String host = solrService.getSolrHost();
        int port = solrService.getSolrPort();
        if (isHttps && 0 == (port = solrService.getSolrhttpsport())) {
            port = 8443;
        }
        String webapp = solrService.getSolrWebapp();
        return (isHttps ? "https" : "http") + "://" + host + ":" + port + "/" + webapp;
    }

    public static ArrayList<String> getCoreNames(String url) throws SolrServerException, IOException {
        SolrClient client = SolrUtils.getSolrClient(url);
        ArrayList<String> cores = new ArrayList<String>();
        CoreAdminResponse res = CoreAdminRequest.Create.getStatus(null, (SolrClient)client);
        NamedList list = res.getCoreStatus();
        for (Map.Entry entry : list) {
            String key = (String)entry.getKey();
            cores.add(key);
        }
        return cores;
    }

    public static void restartSolrCore(String core, String url) throws IOException, SolrServerException {
        SolrClient client = SolrUtils.getSolrClient(url);
        core = URLDecoder.decode((String)core);
        CoreAdminRequest.reloadCore((String)core, (SolrClient)client);
    }

    public static int getSolrDocCount(String url, String cores) throws SolrServerException, IOException {
        SolrClient client = SolrUtils.getSolrClient(url);
        int doccount = 0;
        for (String core : cores.split(",")) {
            core = URLDecoder.decode((String)core);
            CoreAdminResponse res = CoreAdminRequest.Create.getStatus((String)core, (SolrClient)client);
            NamedList list = res.getCoreStatus();
            for (Map.Entry entry : list) {
                String key = (String)entry.getKey();
                NamedList value = (NamedList)entry.getValue();
                SimpleOrderedMap o = (SimpleOrderedMap)value.get("index");
                doccount += ((Integer)o.get("numDocs")).intValue();
            }
        }
        return doccount;
    }

    public static String getCollectionPath(String collection, String url) throws IOException, SolrServerException {
        CoreAdminResponse res;
        NamedList list;
        NamedList objectNamedList;
        String dir;
        SolrClient client = SolrUtils.getSolrClient(url);
        String path = "";
        if (SolrUtils.isSolrRunning(url) && new File(dir = (String)(objectNamedList = (NamedList)(list = (res = CoreAdminRequest.Create.getStatus((String)collection, (SolrClient)client)).getCoreStatus()).getVal(0)).get("instanceDir")).exists()) {
            path = dir;
        }
        return path;
    }

    public static ArrayList<HashMap<String, String>> list(String url) throws SolrServerException, IOException {
        SolrClient client = SolrUtils.getSolrClient(url);
        ArrayList<HashMap<String, String>> cores = new ArrayList<HashMap<String, String>>();
        if (SolrUtils.isSolrRunning(url)) {
            CoreAdminResponse res = CoreAdminRequest.Create.getStatus(null, (SolrClient)client);
            NamedList list = res.getCoreStatus();
            for (Map.Entry entry : list) {
                String key = (String)entry.getKey();
                NamedList value = (NamedList)entry.getValue();
                SimpleOrderedMap o = (SimpleOrderedMap)value.get("index");
                String directory = value.get("dataDir").toString() + "index";
                String lastModified = "";
                Object obj = o.get("lastModified");
                if (obj != null) {
                    lastModified = obj.toString();
                }
                String doccount = Integer.toString((Integer)o.get("numDocs"));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", key);
                map.put("path", directory);
                map.put(MODIFIED, lastModified);
                map.put(DOCCOUNT, doccount);
                final File file = new File(directory);
                map.put(SIZE, Long.toString(System.getSecurityManager() == null ? Utils.getDirectorySize(file) : AccessController.doPrivileged(new PrivilegedAction<Long>(){

                    @Override
                    public Long run() {
                        return Utils.getDirectorySize(file);
                    }
                }) / 1024L));
                cores.add(map);
            }
        }
        return cores;
    }

    private static HTMLParser getHTMLParser(String file) {
        HTMLParser parser = null;
        try {
            parser = new HTMLParser(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String extractRTFText(InputStream stream) throws IOException {
        try {
            String text;
            RTFEditorKit rek = new RTFEditorKit();
            DefaultStyledDocument doc = new DefaultStyledDocument();
            rek.read(stream, (Document)doc, 0);
            String string = text = doc.getText(0, doc.getLength());
            return string;
        }
        catch (BadLocationException e) {
            String string = "";
            return string;
        }
        finally {
            stream.close();
        }
    }

    private static String getHTMLTextContent(HTMLParser parser) {
        return parser.getText();
    }

    private static long getSolrDocument(SolrInputDocument doc1, String key, String body, String title, String url, String categoryData, String categoryTreeData, String languagesuffix, Map<String, String> customFieldsData) {
        doc1.addField(KEY, (Object)key);
        doc1.addField(MODIFIED, (Object)Calendar.getInstance().getTimeInMillis());
        doc1.addField(UID, (Object)key);
        doc1.addField(TITLE, (Object)title);
        doc1.addField(AUTHOR, (Object)"");
        if (url.equalsIgnoreCase("")) {
            url = "/";
        }
        doc1.addField(URL, (Object)url);
        Long size = new Long(body.length());
        doc1.addField(SIZE, (Object)size);
        String mimetype = "Query";
        doc1.addField(MIME, (Object)mimetype);
        doc1.addField(KEYWORDS, (Object)mimetype);
        doc1.addField(SUBJECT, (Object)mimetype);
        if (null != customFieldsData) {
            for (Map.Entry<String, String> entry : customFieldsData.entrySet()) {
                String v;
                String k = entry.getKey().trim();
                String string = v = null == entry.getValue() ? null : entry.getValue().trim();
                if (k.endsWith(DATEEXTENSION) && v.trim().equals("")) continue;
                if (null == v && k.toLowerCase().endsWith("_s")) {
                    v = "";
                }
                if (k.endsWith("_b")) {
                    doc1.addField(k, (Object)Cast._boolean((String)v));
                    continue;
                }
                doc1.addField(k, (Object)v);
            }
        }
        String[] catdatas = new String[]{};
        if (categoryData != null && !categoryData.equalsIgnoreCase("")) {
            catdatas = categoryData.split(",");
        }
        for (String catdata : catdatas) {
            doc1.addField(CATEGORY, (Object)catdata);
        }
        if (categoryTreeData != null && !categoryTreeData.equalsIgnoreCase("")) {
            doc1.addField(CATEGORYTREE, (Object)categoryTreeData);
        }
        if (languagesuffix.equalsIgnoreCase("")) {
            doc1.addField("contents_en", (Object)body);
        } else {
            doc1.addField("contents_" + languagesuffix, (Object)body);
        }
        int n = Math.min(body.length(), 100);
        String summary = body.substring(0, n);
        doc1.addField(SUMMARY, (Object)summary);
        return body.getBytes().length;
    }

    public static void deleteKey(SolrClient client, String key) throws SolrServerException, IOException {
        File fname = VFSFileFactory.getFileObject((String)key);
        String uid = String.valueOf(fname.getCanonicalPath().hashCode());
        client.deleteById(uid);
        if (!fname.exists()) {
            client.deleteById(key);
        }
    }

    public static void purgeCollection(SolrClient client) throws SolrServerException, IOException {
        client.deleteByQuery("*:*");
        client.commit();
    }

    public static String fixURL(String name) {
        String collectionname = URLEncoder.encode((String)name);
        return collectionname;
    }

    public static void optimizeCollection(SolrClient client) throws SolrServerException, IOException {
        client.optimize();
        client.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Map<String, String> getMetadata(File fname) throws IOException, SAXException, TikaException {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        if (parser == null) {
            Class<SolrUtils> clazz = SolrUtils.class;
            // MONITORENTER : coldfusion.tagext.search.SolrUtils.class
            if (parser == null) {
                TikaConfig tikaConfig = new TikaConfig(ServiceFactory.getRuntimeService().getLibDir() + File.separator + "tika-config.xml");
                parser = new AutoDetectParser(tikaConfig);
            }
            // MONITOREXIT : clazz
        }
        BodyContentHandler handler = new BodyContentHandler(-1);
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)parser);
        InputStream stream = VFSFileFactory.getInputStream((File)fname);
        stream = new BufferedInputStream(stream);
        parser.parse(stream, (ContentHandler)handler, metadata, context);
        String mime = metadata.get("Content-Type");
        metadataMap.put(MIME, mime);
        metadataMap.put(TITLE, metadata.get(TikaCoreProperties.TITLE) != null ? metadata.get(TikaCoreProperties.TITLE) : "");
        metadataMap.put(AUTHOR, metadata.get(TikaCoreProperties.CREATOR) != null ? metadata.get(TikaCoreProperties.CREATOR) : "");
        metadataMap.put(KEYWORDS, metadata.get(Office.KEYWORDS) != null ? metadata.get(Office.KEYWORDS) : "");
        metadataMap.put(SUBJECT, metadata.get(TikaCoreProperties.SUBJECT) != null ? metadata.get(TikaCoreProperties.SUBJECT) : "");
        String content = handler.toString();
        metadataMap.put("handler", content != null ? content : "");
        if ("application/zip".equalsIgnoreCase(mime) || "application/x-bzip".equalsIgnoreCase(mime) || "application/x-gzip".equalsIgnoreCase(mime) || "application/x-tar".equalsIgnoreCase(mime)) {
            metadataMap.put("content", handler.toString());
        }
        if (!"image/jpeg".equalsIgnoreCase(mime)) return metadataMap;
        metadataMap.put("model", metadata.get("Model") != null ? metadata.get("Model") : "");
        return metadataMap;
    }

    public static void deleteCore(final SolrClient client, final String corename) {
        new Thread(){

            @Override
            public void run() {
                try {
                    CoreAdminResponse coreAdminResponse = CoreAdminRequest.Create.unloadCore((String)corename, (SolrClient)client);
                }
                catch (IOException e) {
                    throw new SearchExceptions.UnableToDeleteCoreException(corename, e);
                }
                catch (SolrServerException e) {
                    throw new SearchExceptions.UnableToDeleteCoreException(corename, e);
                }
            }
        }.start();
    }

    private static String getMimeType(File fname) throws IOException {
        MimeTypes types = new MimeTypes();
        MimeType type = null;
        try {
            type = types.getMimeType(fname);
        }
        catch (MimeTypeException mimeTypeException) {
            // empty catch block
        }
        if (null != type) {
            return type.getName();
        }
        return "";
    }

    private static long getSolrDocument(SolrInputDocument doc1, File fname, String url, String title, String key, String categoryData, String categoryTreeData, String languagesuffix, Map<String, String> customFieldsData) throws IOException, SAXException, TikaException {
        String[] catdatas;
        String saveTitle = title;
        String mimetype = "";
        String author = "";
        Object contents = "";
        String keywords = "";
        String subject = "";
        String name = fname.getName().toLowerCase();
        String summary = "";
        boolean htmlparsed = false;
        Map<Object, Object> metadata = new HashMap();
        if (SolrUtils.isHTMLParserReq(name)) {
            htmlparsed = true;
            HTMLParser parser = SolrUtils.getHTMLParser(fname.getAbsolutePath());
            contents = SolrUtils.getHTMLTextContent(parser);
            try {
                title = parser.getTitle();
                summary = parser.getSummary();
            }
            catch (Exception exception) {
                // empty catch block
            }
            mimetype = MimeTypeUtils.guessMimeType((String)fname.getName());
        } else if (name.endsWith(".pdf")) {
            PDFService pdfService = ServiceFactory.getPDFService();
            if (pdfService != null) {
                Struct info = pdfService.getInfo(fname.getCanonicalPath(), "", false);
                title = (String)info.get((Object)"Title");
                author = (String)info.get((Object)"Author");
                subject = (String)info.get((Object)SUBJECT);
                keywords = (String)info.get((Object)KEYWORDS);
                contents = pdfService.extractText(fname.getCanonicalPath(), "", null, "STRING", false, true, true, "UTF-8");
                mimetype = "application/pdf";
            }
        } else if (name.endsWith(".doc")) {
            metadata = MSDocument.readDoc(fname);
        } else if (name.endsWith(".docx")) {
            metadata = MSDocument.readDocx(fname);
        } else if (name.endsWith(".xls")) {
            metadata = MSDocument.readXLS(fname);
        } else if (name.endsWith(".xlsx")) {
            metadata = MSDocument.readXLSX(fname);
        } else if (name.endsWith(".ppt")) {
            metadata = MSDocument.readPPT(fname);
        } else if (name.endsWith(".pptx")) {
            metadata = MSDocument.readPPTX(fname);
        } else if (name.endsWith(".rtf")) {
            contents = SolrUtils.extractRTFText(new FileInputStream(fname));
        } else {
            metadata = SolrUtils.getMetadata(fname);
            contents = (String)metadata.get("handler");
            if ("application/zip".equalsIgnoreCase(mimetype) || "application/x-bzip".equalsIgnoreCase(mimetype) || "application/x-gzip".equalsIgnoreCase(mimetype) || "application/x-tar".equalsIgnoreCase(mimetype)) {
                contents = (String)metadata.get("content");
            }
            if ("image/jpeg".equalsIgnoreCase(mimetype)) {
                contents = ((String)contents).equalsIgnoreCase("") ? contents : (String)contents + " ";
                contents = (String)contents + (String)metadata.get("model");
            }
            metadata.put("content", contents);
        }
        if (!(SolrUtils.isHTMLParserReq(name) || name.endsWith(".rtf") || name.endsWith(".pdf"))) {
            contents = (String)metadata.get("content");
            title = (String)metadata.get(TITLE);
            author = (String)metadata.get(AUTHOR);
            mimetype = (String)metadata.get(MIME);
            subject = (String)metadata.get(SUBJECT);
            keywords = (String)metadata.get(KEYWORDS);
        }
        name = fname.getName();
        if (null == contents) {
            throw new SearchExceptions.InvalidFileException(name);
        }
        if (!htmlparsed) {
            int summarylength = Math.min(((String)contents).length(), 300);
            summary = ((String)contents).substring(0, summarylength);
        }
        if (title.equalsIgnoreCase("")) {
            title = saveTitle != null && !saveTitle.equalsIgnoreCase("") ? saveTitle : name;
        }
        if (key.equalsIgnoreCase("")) {
            key = name;
        }
        doc1.addField(KEY, (Object)key);
        doc1.addField(MODIFIED, (Object)DateTools.timeToString((long)fname.lastModified(), (DateTools.Resolution)DateTools.Resolution.MINUTE));
        String uid = String.valueOf(fname.getCanonicalPath().hashCode());
        doc1.addField(UID, (Object)uid);
        doc1.addField(TITLE, (Object)title);
        doc1.addField(SUMMARY, (Object)summary.trim());
        doc1.addField(SUBJECT, (Object)subject.trim());
        doc1.addField(KEYWORDS, (Object)keywords);
        if (((String)url).equalsIgnoreCase("")) {
            url = "/" + name;
        }
        doc1.addField(AUTHOR, (Object)author);
        doc1.addField(URL, url);
        Long size = fname.length();
        doc1.addField(SIZE, (Object)size);
        if (mimetype == null || mimetype.equalsIgnoreCase("")) {
            mimetype = SolrUtils.getMimeType(fname);
        }
        doc1.addField(MIME, (Object)mimetype);
        for (String catdata : catdatas = categoryData.split(",")) {
            doc1.addField(CATEGORY, (Object)catdata);
        }
        if (!categoryTreeData.equalsIgnoreCase("")) {
            doc1.addField(CATEGORYTREE, (Object)categoryTreeData);
        }
        if (languagesuffix.equalsIgnoreCase("")) {
            doc1.addField("contents_en", contents);
        } else {
            doc1.addField("contents_" + languagesuffix, contents);
        }
        SolrUtils.addCustomFields(doc1, customFieldsData);
        return ((String)contents).getBytes().length;
    }

    private static void addCustomFields(SolrInputDocument doc1, Map<String, String> customFieldsData) {
        if (null != customFieldsData) {
            for (Map.Entry<String, String> customField : customFieldsData.entrySet()) {
                String k = customField.getKey().trim();
                String v = customField.getValue().trim();
                if (k.endsWith(DATEEXTENSION) && v.trim().equals("")) continue;
                if (k.endsWith("_b")) {
                    doc1.addField(k, (Object)Cast._boolean((String)v));
                    continue;
                }
                doc1.addField(k, (Object)v);
            }
        }
    }

    private static boolean isHTMLParserReq(String name) {
        return name.endsWith(".xml") || name.endsWith(".html") || name.endsWith(".cfm") || name.endsWith(".htm") || name.endsWith(".cfc");
    }

    public static Struct addDocument(SolrClient client, ArrayList<HashMap> files, boolean autocommit, boolean throwonerror) {
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        int doccount = 0;
        Long size = 0L;
        Struct struct = new Struct();
        Struct errorstruct = new Struct();
        for (HashMap m : files) {
            SolrInputDocument doc1;
            String title = (String)m.get(TITLE);
            String url = (String)m.get(URL);
            String body = (String)m.get("body");
            String key = (String)m.get(KEY);
            String categoryData = (String)m.get(CATEGORY);
            String categoryTreeData = (String)m.get(CATEGORYTREE);
            String languagesuffix = (String)m.get("suffix");
            Map customFieldsData = (Map)m.get("customFieldsData");
            if (languagesuffix == null) {
                languagesuffix = "";
            }
            try {
                doc1 = new SolrInputDocument();
                long s = SolrUtils.getSolrDocument(doc1, key, body, title, url, categoryData, categoryTreeData, languagesuffix, (Map<String, String>)customFieldsData);
                size = size + s;
            }
            catch (Exception e) {
                errorstruct.put((Object)key, (Object)e.toString());
                if (throwonerror) {
                    throw new SearchExceptions.IndexingFailedException(key, e);
                }
                doc1 = null;
            }
            if (autocommit && size >= SolrUtils.getSolrBufferSizeInBytes()) {
                SolrUtils.commitToServer(docs, client, autocommit);
                doccount += docs.size();
                docs.clear();
                size = 0L;
            }
            if (doc1 == null) continue;
            docs.add(doc1);
        }
        if (docs.size() != 0) {
            SolrUtils.commitToServer(docs, client, autocommit);
            doccount += docs.size();
        }
        struct.put((Object)DOCCOUNT, (Object)doccount);
        struct.put((Object)ERRORS, (Object)errorstruct);
        return struct;
    }

    private static ArrayList getFiles(File dir, String extensions, boolean recurse) {
        ExtensionMatcher matcher = new ExtensionMatcher(extensions);
        ArrayList fileList = new ArrayList();
        matcher.getFiles(fileList, dir, recurse);
        return fileList;
    }

    private static String processPrefix(String relativePath, String filename, String prefix) {
        if (prefix != null && prefix.length() > 0) {
            filename = prefix.endsWith("\\") || prefix.endsWith("/") ? prefix + relativePath : prefix + "/" + relativePath;
            filename = prefix.indexOf(92) != -1 ? ((String)filename).replace('/', '\\') : ((String)filename).replace('\\', '/');
        }
        return filename;
    }

    public static Struct addDocument(SolrClient client, QueryTable queryTable, String key, String title, String urlpath, String category, String categoryTree, String extensions, String prefix, boolean recurse, String languagesuffix, Map<String, String> customFields, boolean autocommit) {
        QueryVector queryVector = new QueryVector(queryTable);
        int rowCount = queryTable.getRowCount();
        int keyIndex = IndexTag.findKey(queryTable, key);
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        ArrayList fileList = new ArrayList();
        int doccount = 0;
        Long size = 0L;
        Struct struct = new Struct();
        Struct errorstruct = new Struct();
        if (languagesuffix == null) {
            languagesuffix = "";
        }
        for (int row = 1; row <= rowCount; ++row) {
            String keyData = queryVector.getData(row, keyIndex);
            String titleData = IndexTag.getIndexData(queryVector, title, row);
            String urlData = IndexTag.getIndexData(queryVector, urlpath, row);
            String categoryData = IndexTag.getIndexData(queryVector, category, row);
            String categoryTreeData = IndexTag.getIndexData(queryVector, categoryTree, row);
            File dir = new File(keyData);
            SolrInputDocument doc1 = null;
            if (!Utils.isDirectory(dir)) {
                throw new SearchExceptions.KeyIsNotDirectoryException(keyData);
            }
            fileList.clear();
            fileList = SolrUtils.getFiles(dir, extensions, recurse);
            for (int listIndex = 0; listIndex < fileList.size(); ++listIndex) {
                String filename = ((File)fileList.get(listIndex)).getPath();
                String relativePath = filename.substring(keyData.length() + 1);
                filename = SolrUtils.processPrefix(relativePath, filename, prefix);
                if (relativePath.indexOf(92) != -1) {
                    relativePath = relativePath.replace('\\', '/');
                }
                String fileUrl = urlData + "/" + relativePath;
                Object treePath = "";
                if (categoryTreeData != null && categoryTreeData.length() > 0) {
                    treePath = categoryTreeData;
                    int lastslash = relativePath.lastIndexOf(47);
                    if (lastslash != -1) {
                        if (((String)treePath).charAt(((String)treePath).length() - 1) != '/') {
                            treePath = (String)treePath + "/";
                        }
                        treePath = (String)treePath + relativePath.substring(0, lastslash);
                    }
                }
                File fname = VFSFileFactory.getFileObject((String)filename);
                try {
                    doc1 = new SolrInputDocument();
                    long s = SolrUtils.getSolrDocument(doc1, fname, fileUrl, titleData, filename, categoryData, (String)treePath, languagesuffix, customFields);
                    size = size + s;
                }
                catch (Exception e) {
                    CFLogs.SERVER_LOG.warn((Object)RB.getString((Object)new SolrUtils(), (String)"Search.LucenePDFDocumentWarn", (Object)fname.getPath(), (Object)e.getMessage()));
                    doc1 = null;
                    errorstruct.put((Object)key, (Object)e.toString());
                }
                if (autocommit && size >= SolrUtils.getSolrBufferSizeInBytes()) {
                    SolrUtils.commitToServer(docs, client, autocommit);
                    doccount += docs.size();
                    docs.clear();
                    size = 0L;
                }
                if (doc1 == null) continue;
                docs.add(doc1);
            }
        }
        if (docs.size() != 0) {
            SolrUtils.commitToServer(docs, client, autocommit);
            doccount += docs.size();
        }
        struct.put((Object)DOCCOUNT, (Object)doccount);
        struct.put((Object)ERRORS, (Object)errorstruct);
        return struct;
    }

    public static Map<String, String> getCustomFieldsData(Map<String, String> customFields, int row, QueryVector queryVector) {
        HashMap<String, String> customFieldsData = new HashMap<String, String>();
        for (Map.Entry<String, String> customField : customFields.entrySet()) {
            String data = IndexTag.getIndexData(queryVector, customField.getValue(), row);
            if (customField.getKey().endsWith(DATEEXTENSION) && !"".equals(data)) {
                data = SolrUtils.formatDate(data);
            }
            customFieldsData.put(customField.getKey(), data);
        }
        return customFieldsData;
    }

    public static Struct addDocument(SolrClient client, QueryTable queryTable, String key, String title, String urlpath, String category, String categoryTree, String languagesuffix, Map<String, String> customFields, boolean autocommit) {
        QueryVector queryVector = new QueryVector(queryTable);
        int rowCount = queryTable.getRowCount();
        int keyIndex = IndexTag.findKey(queryTable, key);
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        int doccount = 0;
        Long size = 0L;
        Struct struct = new Struct();
        Struct errorstruct = new Struct();
        if (languagesuffix == null) {
            languagesuffix = "";
        }
        for (int row = 1; row <= rowCount; ++row) {
            String keyData = queryVector.getData(row, keyIndex);
            String titleData = IndexTag.getIndexData(queryVector, title, row);
            String urlData = IndexTag.getIndexData(queryVector, urlpath, row);
            String categoryData = IndexTag.getIndexData(queryVector, category, row);
            String categoryTreeData = IndexTag.getIndexData(queryVector, categoryTree, row);
            Map<String, String> customFieldsData = SolrUtils.getCustomFieldsData(customFields, row, queryVector);
            urlData = IndexTag.formatUrlpath(urlData, keyData);
            File fname = VFSFileFactory.getFileObject((String)keyData);
            SolrInputDocument doc1 = null;
            try {
                doc1 = new SolrInputDocument();
                long s = SolrUtils.getSolrDocument(doc1, fname, urlData, titleData, keyData, categoryData, categoryTreeData, languagesuffix, customFieldsData);
                size = size + s;
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.warn((Object)RB.getString((Object)new SolrUtils(), (String)"Search.LucenePDFDocumentWarn", (Object)fname.getPath(), (Object)e.getMessage()));
                doc1 = null;
                errorstruct.put((Object)key, (Object)e.toString());
            }
            if (size >= SolrUtils.getSolrBufferSizeInBytes()) {
                SolrUtils.commitToServer(docs, client, autocommit);
                doccount += docs.size();
                docs.clear();
                size = 0L;
            }
            if (doc1 == null) continue;
            docs.add(doc1);
        }
        if (docs.size() != 0) {
            SolrUtils.commitToServer(docs, client, autocommit);
            doccount += docs.size();
        }
        struct.put((Object)DOCCOUNT, (Object)doccount);
        struct.put((Object)ERRORS, (Object)errorstruct);
        return struct;
    }

    public static Struct addDocument(SolrClient client, String basepath, ArrayList<File> files, String url, String title, String categoryData, String categoryTreeData, String languagesuffix, Map<String, String> customFields, boolean commit, boolean throwonerror) {
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        boolean batch = false;
        int doccount = 0;
        Long size = 0L;
        Struct struct = new Struct();
        Struct errorstruct = new Struct();
        if (languagesuffix == null) {
            languagesuffix = "";
        }
        for (File fname : files) {
            SolrInputDocument doc1 = null;
            try {
                int lastslash;
                Object fileUrl;
                doc1 = new SolrInputDocument();
                String relativePath = fname.getAbsolutePath();
                boolean directory = new File(basepath).isDirectory();
                if (directory) {
                    relativePath = fname.getAbsolutePath().substring(basepath.length());
                    if (relativePath.indexOf(92) != -1) {
                        relativePath = relativePath.replace('\\', '/');
                    }
                    fileUrl = relativePath.startsWith("/") ? url + relativePath : url + "/" + relativePath;
                } else {
                    fileUrl = url;
                }
                Object treePath = categoryTreeData;
                if (categoryTreeData.length() > 0 && directory && (lastslash = relativePath.lastIndexOf(47)) != -1) {
                    if (((String)treePath).charAt(((String)treePath).length() - 1) != '/' && !relativePath.startsWith("/")) {
                        treePath = (String)treePath + "/";
                    }
                    treePath = (String)treePath + relativePath.substring(0, lastslash);
                }
                long s = SolrUtils.getSolrDocument(doc1, fname, (String)fileUrl, title, fname.getPath(), categoryData, (String)treePath, languagesuffix, customFields);
                size = size + s;
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.warn((Object)RB.getString((Object)new SolrUtils(), (String)"Search.LucenePDFDocumentWarn", (Object)fname.getPath(), (Object)e.getMessage()));
                doc1 = null;
                if (throwonerror) {
                    throw new SearchExceptions.IndexingFailedException(fname.getAbsolutePath(), e);
                }
                errorstruct.put((Object)fname, (Object)e.toString());
            }
            if (commit && size >= SolrUtils.getSolrBufferSizeInBytes()) {
                SolrUtils.commitToServer(docs, client, commit);
                doccount += docs.size();
                docs.clear();
                size = 0L;
            }
            if (doc1 == null) continue;
            docs.add(doc1);
        }
        if (docs.size() != 0) {
            SolrUtils.commitToServer(docs, client, commit);
            doccount += docs.size();
        }
        struct.put((Object)DOCCOUNT, (Object)doccount);
        struct.put((Object)ERRORS, (Object)errorstruct);
        return struct;
    }

    public static void commitToServer(ArrayList<SolrInputDocument> docs, SolrClient client, boolean autocommit) {
        if (docs.size() > 0) {
            try {
                UpdateRequest req = new UpdateRequest();
                if (autocommit) {
                    req.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, false);
                }
                req.add(docs);
                req.process(client);
            }
            catch (IOException | SolrServerException e) {
                throw new SearchExceptions.IndexProblemException(e);
            }
            catch (SolrException e) {
                String message = e.getMessage();
                if (message.contains("Error_while_creating_field") || message.contains("Error while creating field") || message.contains("Error adding field")) {
                    throw new SearchExceptions.IndexInvalidAttributevalueException(e);
                }
                if (message.contains("ERRORunknown_field") || message.contains("unknown field")) {
                    throw new SearchExceptions.IndexInvalidAttributeException(e);
                }
                throw new SearchExceptions.IndexProblemException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSolrCore(String url, String collection) {
        String solrUrlWithCore = url + "/admin/cores?exists=true&core=" + SolrUtils.fixURL(collection);
        solrUrlWithCore.replaceFirst("^https", "http");
        int timeout = 10000;
        BufferedReader br = null;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(solrUrlWithCore).openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setRequestMethod("GET");
            boolean bl = connection.getResponseCode() == 200;
            return bl;
        }
        catch (IOException exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void renameSolrAlias(String url, String corename, String newname) {
        newname = newname.toLowerCase();
        Utils.checkCollectionExists(newname);
        SolrClient client = SolrUtils.getSolrClient(url);
        if (client != null) {
            try {
                CoreAdminRequest.Create.renameCore((String)corename, (String)newname, (SolrClient)client);
            }
            catch (Exception e) {
                throw new SearchExceptions.UnableToCreateAliasException(corename, newname, e);
            }
        }
    }

    public static void createSolrCore(String url, String solrhome, String collection, String path) {
        SolrClient client = SolrUtils.getSolrClient(url);
        String templatedir = solrhome + "/template";
        if (client != null) {
            try {
                String collectionPath = path.replaceAll("\\\\", "/");
                CoreAdminRequest.Create.createCore((String)collection, (String)collectionPath, (SolrClient)client, null, null, (String)templatedir);
            }
            catch (Exception e) {
                throw new SearchExceptions.UnableToCreateSolrCollectionException(collection, e);
            }
        }
    }

    public static SolrClient getSolrClient(String url) {
        return SolrUtils._getSolrClient(url, null);
    }

    public static SolrClient getSolrClient(String url, String corename) {
        return SolrUtils._getSolrClient(url, corename);
    }

    public static void clearSolrClientCache() {
        solrClientMap.clear();
    }

    public static SolrClient _getSolrClient(String url, String corename) {
        SolrClient solr_client = solrClientMap.get(corename);
        if (null != solr_client) {
            return solr_client;
        }
        HttpClient client = null;
        try {
            client = SolrUtils.getHttpClient();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != corename) {
            url = (String)url + "/" + corename;
        }
        solr_client = null != client ? ((HttpSolrClient.Builder)new HttpSolrClient.Builder((String)url).withHttpClient(client)).build() : new HttpSolrClient.Builder((String)url).build();
        ((HttpSolrClient)solr_client).setParser((ResponseParser)new XMLResponseParser());
        solrClientMap.put(corename, solr_client);
        return solr_client;
    }

    private static HttpClient getHttpClient() {
        Map<String, String> credentials = null;
        try {
            credentials = SolrUtils.getSolrCredentials();
        }
        catch (Exception e) {
            return null;
        }
        String password = SolrUtils.decryptPassword(credentials.get(PASSWORD));
        if (null == credentials || !SolrUtils.stringNullCheck(credentials.get(USERNAME)) || !SolrUtils.stringNullCheck(password)) {
            return null;
        }
        AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, null, null);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(credentials.get(USERNAME), password));
        CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        return client;
    }

    private static String decryptPassword(String key) {
        if (key != null && key.length() > 0) {
            return PasswordUtils.decryptPassword((String)key, (String)seed);
        }
        return key;
    }

    public static SolrClient getHttpsSolrClient(String corename) {
        SolrService service = ServiceFactory.getSolrService();
        boolean isHttpsRequired = Boolean.valueOf(service.getHttpsenabled());
        if (!isHttpsRequired) {
            return SolrUtils.getSolrClient(SolrUtils.getSolrURL(service), corename);
        }
        return SolrUtils.getSolrClient(SolrUtils.getHttpsSolrURL(service), corename);
    }

    private static Map<String, String> getSolrCredentials() throws Exception {
        SolrService service = ServiceFactory.getSolrService();
        return service.getCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSolrRunning(String urlstr) {
        urlstr = urlstr.replaceFirst("^https", "http");
        int timeout = 10000;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(urlstr).openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            boolean bl = 200 <= responseCode && responseCode <= 399;
            return bl;
        }
        catch (IOException exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String getFacetValue(SolrDocument s, String field, HashMap<String, Long> facetmap) {
        Object category = "";
        Object categoryobj = s.getFieldValue(field);
        long count = 0L;
        if (categoryobj != null) {
            if (categoryobj instanceof ArrayList) {
                ArrayList categorylist = (ArrayList)categoryobj;
                for (int i = 0; i < categorylist.size() - 1; ++i) {
                    String catname = (String)categorylist.get(i);
                    if (facetmap.containsKey(catname)) {
                        count = facetmap.get(catname);
                        category = (String)category + catname + "(" + count + "),";
                        continue;
                    }
                    category = (String)category + catname + ",";
                }
                String catname = (String)categorylist.get(categorylist.size() - 1);
                if (facetmap.containsKey(catname)) {
                    count = facetmap.get(catname);
                    category = (String)category + catname + "(" + count + ")";
                } else {
                    category = (String)category + catname;
                }
            } else {
                return (String)categoryobj;
            }
        }
        return category;
    }

    private static Map<String, Object> formatSearchResult(SolrClient client, SolrQuery query, String url, String collection, boolean highlight, int passages, boolean facet, List<String> sortFields, String searchColList, int totalcollectioncount) {
        ArrayList<LinkedHashMap<String, String>> retMap = new ArrayList<LinkedHashMap<String, String>>();
        LinkedHashMap<String, Object> retval = new LinkedHashMap<String, Object>();
        Map<String, Object> suggMap = null;
        Long numfound = 0L;
        long start = 0L;
        long end = 0L;
        try {
            SolrDocumentList docs;
            start = System.currentTimeMillis();
            QueryResponse rsp = client.query((SolrParams)query);
            end = System.currentTimeMillis();
            Map m = null;
            if (highlight) {
                m = rsp.getHighlighting();
            }
            if ((docs = rsp.getResults()) == null) {
                return retval;
            }
            numfound = docs.getNumFound();
            ListIterator iter = docs.listIterator();
            HashMap<String, Long> facetmap = new HashMap();
            if (facet) {
                facetmap = SolrUtils.getFacetMap(rsp);
            }
            while (iter.hasNext()) {
                String mime;
                SolrDocument s = (SolrDocument)iter.next();
                Object uidObj = s.getFieldValue(UID);
                String uid = uidObj != null ? uidObj.toString() : null;
                String context = "";
                if (highlight && m != null) {
                    Map data = (Map)m.get(uid);
                    if (data == null) {
                        for (Map.Entry entry : m.entrySet()) {
                            if (!((String)entry.getKey()).trim().equals(uid)) continue;
                            data = (Map)entry.getValue();
                            break;
                        }
                    }
                    if (data != null && data.size() != 0) {
                        Map map = data;
                        if (map.containsKey(SUMMARY)) {
                            context = SolrUtils.listToString((List)map.get(SUMMARY), passages);
                        }
                        if (map.containsKey("contents")) {
                            context = SolrUtils.listToString((List)map.get("contents"), passages);
                        }
                    }
                }
                if (null == (mime = (String)s.getFieldValue(MIME))) {
                    mime = "DIH";
                }
                String category = "";
                String categorytree = "";
                if (facet) {
                    category = SolrUtils.getFacetValue(s, CATEGORY, facetmap);
                    categorytree = SolrUtils.getFacetValue(s, CATEGORYTREE, facetmap);
                } else {
                    category = "";
                    categorytree = "";
                    Object fieldObj = s.getFieldValue(CATEGORY);
                    if (fieldObj != null) {
                        if (fieldObj instanceof List) {
                            category = SolrUtils.listToCommaString((List)fieldObj);
                        } else if (fieldObj instanceof String) {
                            category = (String)fieldObj;
                        }
                    }
                    if ((fieldObj = s.getFieldValue(CATEGORYTREE)) != null) {
                        if (fieldObj instanceof List) {
                            categorytree = SolrUtils.listToCommaString((List)fieldObj);
                        } else if (fieldObj instanceof String) {
                            categorytree = (String)fieldObj;
                        }
                    }
                }
                Map<String, String> tmpMap = new LinkedHashMap<String, String>();
                Collection fieldnames = s.getFieldNames();
                for (String fieldname : fieldnames) {
                    if (!SolrUtils.isFieldRequired(fieldname.toLowerCase().trim())) continue;
                    tmpMap.put(fieldname.toUpperCase(), s.getFieldValue(fieldname).toString());
                }
                tmpMap.put("CONTEXT", context);
                tmpMap.put("RECORDSSEARCHED", "" + totalcollectioncount);
                tmpMap.put("TYPE", mime);
                tmpMap.put("CATEGORYTREE", categorytree);
                tmpMap.put("CATEGORY", category);
                tmpMap = SolrUtils.filterSearchResult(tmpMap, searchColList);
                Object invalidField = null;
                retMap.add((LinkedHashMap<String, String>)tmpMap);
            }
            suggMap = SolrUtils.getSuggestionMap(rsp);
        }
        catch (SolrServerException e) {
            String rootCause = e.getRootCause().getMessage();
            if (null != rootCause && rootCause.contains("can_not_sort_on_undefined_field")) {
                String invalidField = rootCause.substring(32, rootCause.indexOf(10)).trim();
                throw new SearchExceptions.InvalidSortFieldException(invalidField);
            }
            if (rootCause != null) {
                throw new SearchExceptions.SearchProblemException(e.getMessage() + " : " + rootCause.split("\n")[0]);
            }
            if (e.getRootCause().toString().contains("EOFException")) {
                throw new SearchExceptions.SearchProblemException(RB.getString(Utils.class, (String)"SolrUtils.OutOfMemory"));
            }
            throw new SearchExceptions.SearchProblemException(e.getMessage() + " : " + e.getRootCause().toString());
        }
        catch (SolrException e) {
            String rootCause = e.getMessage();
            if (rootCause != null) {
                Object msg = rootCause;
                if (rootCause.contains("Error from server at")) {
                    msg = "Error executing query :";
                    msg = (String)msg + rootCause.split(":", 4)[3];
                }
                throw new SearchExceptions.SearchProblemException((String)msg);
            }
            if (e.toString().contains("EOFException")) {
                throw new SearchExceptions.SearchProblemException(RB.getString(Utils.class, (String)"SolrUtils.OutOfMemory"));
            }
            throw new SearchExceptions.SearchProblemException(e.toString());
        }
        catch (IOException e) {
            throw new SearchExceptions.SearchProblemException(e.getMessage());
        }
        retval.put("EXECUTION_TIME", end - start);
        retval.put("RESULT", retMap);
        retval.put("SUGGESTMAP", suggMap);
        retval.put("NUMFOUND", numfound);
        return retval;
    }

    private static Map<String, String> filterSearchResult(Map<String, String> tmpMap, String searchColList) {
        tmpMap = SolrUtils.removeNullValues(tmpMap);
        HashSet<String> resultFields = new HashSet<String>(tmpMap.keySet());
        Set<String> searchColSet = SolrUtils.stringToSet(searchColList = SolrUtils.replace(searchColList, MIME, "type", ","), ",");
        if (searchColSet.contains("*")) {
            return tmpMap;
        }
        for (String field : resultFields) {
            if (searchColSet.contains(field.toLowerCase())) continue;
            tmpMap.remove(field.toUpperCase());
        }
        return tmpMap;
    }

    private static Map<String, String> removeNullValues(Map<String, String> tmpMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : tmpMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (null == value) {
                value = "";
            }
            map.put(key, value);
        }
        return map;
    }

    private static Set<String> stringToSet(String searchColList, String delim) {
        String[] splits;
        HashSet<String> result = new HashSet<String>();
        for (String split : splits = searchColList.split(delim)) {
            result.add(split.toLowerCase());
        }
        return result;
    }

    public static String formatDate(String value) {
        try {
            OleDateTime date = CFDateTimeParser.parseDateTime((String)value);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-M-dd HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            String formatDate = sdf.format((Date)date);
            StringBuilder sb = new StringBuilder(formatDate.substring(0, formatDate.indexOf(" "))).append("T").append(formatDate.substring(formatDate.indexOf(" ") + 1, formatDate.length())).append("Z");
            return sb.toString();
        }
        catch (Exception e) {
            return value;
        }
    }

    private static Map<String, Object> getSuggestionMap(QueryResponse rsp) {
        SpellCheckResponse spellres = rsp.getSpellCheckResponse();
        HashMap<String, Object> suggMap = null;
        if (spellres != null) {
            List suggestions = spellres.getSuggestions();
            String collatedResult = spellres.getCollatedResult() != null ? spellres.getCollatedResult() : "";
            Object suggestionlist = "";
            HashMap keywordMap = new HashMap();
            boolean x = false;
            for (SpellCheckResponse.Suggestion suggest : suggestions) {
                List slist = suggest.getAlternatives();
                List frequencies = suggest.getAlternativeFrequencies();
                HashMap<String, Integer> freqMap = new HashMap<String, Integer>();
                int i = 0;
                String bestSug = "";
                int cmfreq = 0;
                for (String s1 : slist) {
                    int freq = (Integer)frequencies.get(i);
                    ++i;
                    if (freq > cmfreq) {
                        cmfreq = freq;
                        bestSug = s1;
                    }
                    freqMap.put(s1, freq);
                }
                suggestionlist = (String)suggestionlist + bestSug + " ";
                keywordMap.put(suggest.getToken(), freqMap);
            }
            suggMap = new HashMap<String, Object>();
            suggMap.put("SUGGESTIONS", ((String)suggestionlist).trim());
            suggMap.put("COLLATIONS", collatedResult);
            suggMap.put("KEYWORDS", keywordMap);
        }
        return suggMap;
    }

    private static String listToCommaString(List val) {
        String out = "";
        StringBuilder temp = new StringBuilder("");
        for (Object o : val) {
            temp.append(o).append(",");
        }
        temp.deleteCharAt(temp.length() - 1);
        out = temp.toString();
        return out;
    }

    private static String listToString(List<String> list, int count) {
        Object str = "";
        Iterator<String> iter1 = list.iterator();
        for (int i = 0; iter1.hasNext() && i < count; ++i) {
            str = (String)str + iter1.next() + " ";
        }
        return str;
    }

    private static HashMap<String, Long> getFacetMap(QueryResponse rsp) {
        HashMap<String, Long> facetmap = new HashMap<String, Long>();
        List ffs = rsp.getFacetFields();
        for (FacetField ff : ffs) {
            List listcount = ff.getValues();
            if (listcount == null) continue;
            for (FacetField.Count count : listcount) {
                facetmap.put(count.getName(), count.getCount());
            }
        }
        return facetmap;
    }

    private static boolean isFieldRequired(String fieldname) {
        return !fieldsNotReqSet.contains(fieldname);
    }

    public static Map<String, Object> getSearchResult(String url, String collection, String criteria, String prevCriteria, String category, String categoryTree, String querytype, String language, int startrow, int maxrows, boolean suggest, String orderby, String searchtime, String searchColList, int totalcollectioncount) {
        return SolrUtils.getSearchResult(url, collection, criteria, prevCriteria, startrow, maxrows, "", "", category, categoryTree, querytype, language, 0, 0, suggest, orderby, searchtime, searchColList, totalcollectioncount);
    }

    public static HashMap<String, Long> getCategoryTrees(String url, String collection) {
        HashMap<String, Long> facetmap = new HashMap<String, Long>();
        try {
            SolrClient client = SolrUtils.getSolrClient(url, collection);
            SolrQuery query = new SolrQuery();
            query.addField(CATEGORYTREE);
            query.addFacetField(new String[]{"categorytreedata"});
            query.setFacet(true);
            query.setQuery("*:*");
            QueryResponse rsp = client.query((SolrParams)query);
            List ffs = rsp.getFacetFields();
            HashMap<String, Long> tmpmap = new HashMap<String, Long>();
            if (ffs != null) {
                for (FacetField ff : ffs) {
                    List listcount = ff.getValues();
                    if (listcount == null) continue;
                    for (FacetField.Count count : listcount) {
                        tmpmap.put(count.getName(), count.getCount());
                    }
                }
                SolrDocumentList docs = rsp.getResults();
                if (docs != null) {
                    ListIterator iter = docs.listIterator();
                    while (iter.hasNext()) {
                        SolrDocument s = (SolrDocument)iter.next();
                        String catname = (String)s.getFieldValue(CATEGORYTREE);
                        if (catname == null) continue;
                        String[] cats = catname.split("/");
                        String cattree = "";
                        long count = (Long)tmpmap.get(cats[cats.length - 1]);
                        facetmap.put(catname, count);
                    }
                }
            }
        }
        catch (SolrServerException e) {
            throw new SearchExceptions.SearchProblemException(e.getMessage() + " : " + e.getRootCause().getMessage().split("\n")[0]);
        }
        catch (IOException e) {
            throw new SearchExceptions.SearchProblemException(e.getMessage());
        }
        return facetmap;
    }

    public static HashMap<String, Long> getCategories(String url, String collection) {
        HashMap<String, Long> facetmap = new HashMap<String, Long>();
        try {
            SolrClient client = SolrUtils.getSolrClient(url, collection);
            SolrQuery query = new SolrQuery();
            query.addField(CATEGORY);
            query.addFacetField(new String[]{CATEGORY});
            query.setFacet(true);
            query.setQuery("*:*");
            QueryResponse rsp = client.query((SolrParams)query);
            List ffs = rsp.getFacetFields();
            if (ffs != null) {
                for (FacetField ff : ffs) {
                    List listcount = ff.getValues();
                    if (listcount == null) continue;
                    for (FacetField.Count count : listcount) {
                        facetmap.put(count.getName(), count.getCount());
                    }
                }
            }
        }
        catch (SolrServerException e) {
            throw new SearchExceptions.SearchProblemException(e.getMessage() + " : " + e.getRootCause().getMessage().split("\n")[0]);
        }
        catch (IOException e) {
            throw new SearchExceptions.SearchProblemException(e.getMessage());
        }
        return facetmap;
    }

    public static Map<String, Object> getSearchResult(String url, String collections, String criteria, String prevCriteria, int startrow, int maxrows, String highlightbegin, String highlightend, String category, String categoryTree, String querytype, String language, int passages, int contextbytes, boolean suggest, String orderby, String searchtime, String searchColList, int totalcollectioncount) {
        boolean highlight = false;
        String origQuery = criteria;
        Object field = "contents";
        if (language != null && !language.equalsIgnoreCase("english")) {
            SolrServiceImpl solrservice = (SolrServiceImpl)ServiceFactory.getSolrService();
            Vector<Map> v = solrservice.getLanguages();
            String languagesuffix = IndexTag.getSolrLanguageSuffix(v, language, collections);
            field = "contents_" + languagesuffix;
        }
        String[] splits = collections.split(",");
        SolrClient client = SolrUtils.getSolrClient(url, splits[0]);
        StringBuilder colUrls = new StringBuilder();
        String str = url.substring(url.indexOf("://") + 3, url.length());
        for (String collection : splits) {
            colUrls.append(str).append("/").append(collection).append(",");
        }
        colUrls.deleteCharAt(colUrls.length() - 1);
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (client != null) {
            SolrQuery query = new SolrQuery();
            if (splits.length != 1) {
                query.setParam("shards", new String[]{colUrls.toString()});
            }
            if (passages > 0) {
                highlight = true;
                query.setHighlight(true);
                query.setHighlightFragsize(contextbytes);
                query.setHighlightSnippets(passages);
                query.setHighlightSimplePre(highlightbegin);
                query.setHighlightSimplePost(highlightend);
            }
            if (((String)criteria).trim().equalsIgnoreCase("")) {
                criteria = "*:*";
            } else if (!((String)field).equalsIgnoreCase("contents")) {
                criteria = (String)field + ":" + (String)criteria;
            }
            criteria = SolrUtils.checkBooleanCriteria((String)criteria).trim();
            query.setQuery((String)criteria);
            if (!prevCriteria.equalsIgnoreCase("")) {
                query.addFilterQuery(new String[]{prevCriteria});
            }
            if (SolrUtils.stringNullCheck((String)searchColList)) {
                searchColList = SolrUtils.removeAllSpaces(((String)searchColList).trim(), ",");
                searchColList = SolrUtils.replace((String)searchColList, "type", MIME, ",");
                searchColList = (String)searchColList + ",score";
            } else {
                searchColList = "*,score";
            }
            query.setFields(new String[]{searchColList});
            query.setIncludeScore(true);
            query.setRows(Integer.valueOf(1));
            List<String> sortFields = SolrUtils.doSolrSorting(query, orderby);
            SolrUtils.doTimedSearch(query, searchtime);
            boolean facet = false;
            String filterquery = "";
            boolean categorySearch = false;
            if (category != null && !category.equalsIgnoreCase("")) {
                facet = true;
                categorySearch = true;
                filterquery = SolrUtils.doCategorySearch(query, category, filterquery);
            }
            if (categoryTree != null && !categoryTree.equalsIgnoreCase("")) {
                facet = true;
                filterquery = SolrUtils.doCategoryTreeSearch(query, categoryTree, categorySearch, filterquery);
            }
            if (facet) {
                query.addFilterQuery(new String[]{filterquery});
            }
            if (querytype != null && !querytype.equalsIgnoreCase("")) {
                query.setRequestHandler(querytype);
            } else {
                query.setRequestHandler("standard");
            }
            if (suggest) {
                query.setParam("spellcheck", true);
                query.setParam("spellcheck.build", false);
                query.setParam("spellcheck.q", new String[]{criteria});
                query.setParam("spellcheck.collate", true);
                query.setParam("spellcheck.count", new String[]{"5"});
                query.setParam("spellcheck.alternativeTermCount", new String[]{"5"});
                query.setParam("spellcheck.maxResultsForSuggest", new String[]{"5"});
                query.setParam("spellcheck.extendedResults", new String[]{"true"});
            }
            query.setStart(Integer.valueOf(startrow - 1));
            query.setRows(Integer.valueOf(maxrows));
            retMap = SolrUtils.formatSearchResult(client, query, url, collections, highlight, passages, facet, sortFields, (String)searchColList, totalcollectioncount);
            Map sugMap = (Map)retMap.get("SUGGESTMAP");
            Map<String, Object> tmp = retMap;
            if (((ArrayList)retMap.get("RESULT")).size() == 0 && !((String)criteria).equalsIgnoreCase("*:*")) {
                criteria = "contentsExact:" + origQuery;
                query.setQuery((String)criteria);
                try {
                    query.setParam("spellcheck", false);
                    retMap = SolrUtils.formatSearchResult(client, query, url, collections, highlight, passages, facet, sortFields, (String)searchColList, totalcollectioncount);
                    retMap.remove("SUGGESTMAP");
                    retMap.put("SUGGESTMAP", sugMap);
                }
                catch (Exception e) {
                    retMap = tmp;
                }
            }
        }
        return retMap;
    }

    private static String replace(String mainStr, String origstr, String newstr, String delim) {
        int index = mainStr.indexOf(origstr);
        if (index < 0) {
            return mainStr;
        }
        String[] list = mainStr.split(delim);
        Object output = "";
        for (String str : list) {
            output = str.trim().equals(origstr) ? (String)output + newstr : (String)output + str;
            output = (String)output + ",";
        }
        output = ((String)output).substring(0, ((String)output).length() - 1);
        return output;
    }

    public static String removeAllSpaces(String value, String delim) {
        String[] splits;
        StringBuilder sb = new StringBuilder();
        for (String split : splits = value.trim().split(delim)) {
            sb.append(split.trim()).append(delim);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static String checkBooleanCriteria(String criterias) {
        String[] split = criterias.split(",");
        StringBuilder finalCriterias = new StringBuilder();
        for (String criteria : split) {
            if ((criteria = criteria.trim()).contains("_b:")) {
                String value;
                int startIndex = criteria.indexOf("_b:") + 3;
                int stringEnd = criteria.length();
                if (criteria.contains(" TO ")) {
                    value = criteria.substring(startIndex + 1, stringEnd - 1);
                    String[] innersplit = value.split(" TO ");
                    boolean critstart = Cast._boolean((String)innersplit[0].trim());
                    boolean critend = Cast._boolean((String)innersplit[1].trim());
                    finalCriterias.append(criteria.substring(0, startIndex)).append("[").append(critstart).append(" TO ").append(critend).append("]").append(',');
                    continue;
                }
                value = criteria.substring(startIndex, stringEnd);
                boolean bValue = Cast._boolean((String)value.trim());
                finalCriterias.append(criteria.substring(0, startIndex)).append(bValue);
                continue;
            }
            finalCriterias.append(criteria).append(',');
        }
        finalCriterias.deleteCharAt(finalCriterias.length() - 1);
        return finalCriterias.toString();
    }

    private static String doCategoryTreeSearch(SolrQuery query, String categoryTree, boolean categorySearch, String filterquery) {
        query.setFacet(true);
        query.addField(CATEGORYTREE);
        query.addFacetField(new String[]{CATEGORYTREE});
        Object fq = "";
        if (categoryTree.endsWith("/")) {
            int i = categoryTree.lastIndexOf("/");
            StringBuilder tmp = new StringBuilder(categoryTree);
            tmp.deleteCharAt(i);
            categoryTree = tmp.toString();
        }
        fq = categoryTree + "*";
        fq = ((String)fq).trim();
        if (categorySearch) {
            filterquery = (String)filterquery + " AND ";
        }
        filterquery = (String)filterquery + " categorytree:" + (String)fq;
        query.addFacetQuery((String)fq);
        return filterquery;
    }

    private static String doCategorySearch(SolrQuery query, String category, String filterquery) {
        query.setFacet(true);
        query.addField(CATEGORY);
        query.addFacetField(new String[]{CATEGORY});
        String[] queries = category.split(",");
        filterquery = "category:(";
        for (String q : queries) {
            query.addFacetQuery(q);
            filterquery = (String)filterquery + " " + q;
        }
        filterquery = (String)filterquery + ")";
        return filterquery;
    }

    public static void forceCommit(SolrClient client) {
        block4: {
            try {
                UpdateRequest req = new UpdateRequest();
                req.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, false);
                req.process(client);
            }
            catch (IOException | SolrServerException e) {
                throw new SearchExceptions.IndexProblemException(e);
            }
            catch (SolrException e) {
                if (e.getMessage().contains("Error_while_creating_field")) {
                    throw new SearchExceptions.IndexInvalidAttributevalueException(e);
                }
                if (!e.getMessage().contains("ERRORunknown_field")) break block4;
                throw new SearchExceptions.IndexInvalidAttributeException(e);
            }
        }
    }

    private static void doTimedSearch(SolrQuery query, String searchtime) {
        if (SolrUtils.stringNullCheck(searchtime)) {
            query.setTimeAllowed(Integer.valueOf(searchtime));
        }
    }

    private static List<String> doSolrSorting(SolrQuery query, String orderby) {
        ArrayList<String> sortFields = new ArrayList<String>();
        if (SolrUtils.stringNullCheck(orderby)) {
            String[] fieldOrders;
            orderby = orderby.trim();
            for (String fieldOrder : fieldOrders = orderby.split(",")) {
                String sortField = "";
                String sortOrder = "";
                if ((fieldOrder = fieldOrder.trim()).indexOf(32) > 0) {
                    sortField = fieldOrder.substring(0, fieldOrder.indexOf(32));
                    sortFields.add(sortField);
                    sortOrder = fieldOrder.substring(fieldOrder.indexOf(32) + 1, fieldOrder.length());
                    if (ASC.equals(sortOrder)) {
                        query.addSort(sortField, SolrQuery.ORDER.asc);
                        continue;
                    }
                    query.addSort(sortField, SolrQuery.ORDER.desc);
                    continue;
                }
                sortFields.add(fieldOrder);
                query.addSort(fieldOrder, SolrQuery.ORDER.asc);
            }
        }
        return sortFields;
    }

    public static boolean stringNullCheck(String value) {
        return null != value && 0 != value.trim().length();
    }

    public static void setSeed(String s) {
        seed = s;
    }

    public static String getDihStatus(String collectionname) {
        SolrClient solr = SolrUtils.getHttpsSolrClient(collectionname);
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("qt", new String[]{"/dataimport"});
        String action = "status";
        params.set("command", new String[]{action.toLowerCase()});
        params.set("wt", new String[]{"json"});
        String status = "";
        try {
            QueryResponse response = solr.query((SolrParams)params);
            status = (String)response.getResponse().get("status");
        }
        catch (Exception e) {
            throw new SearchExceptions.DIHIndexingException(e);
        }
        return status;
    }

    public static void deleteByQuery(SolrClient client, String query) throws SolrServerException, IOException {
        client.deleteByQuery("title:" + query);
        client.deleteByQuery("spell:" + query);
    }

    public static void reloadCore(String solrurl, String collection) {
        try {
            SolrClient client = SolrUtils.getSolrClient(solrurl);
            CoreAdminRequest.Create.reloadCore((String)collection, (SolrClient)client);
        }
        catch (IOException | SolrServerException e) {
            throw new SearchExceptions.UnableToReloadCoreException(collection, e);
        }
    }

    public static void mergeCollections(String collection, String collectionnames) {
        List<String> colSet = Arrays.asList(collectionnames.split("\\s*,\\s*"));
        Object srcCores = "";
        SolrService solrService = ServiceFactory.getSolrService();
        String solrUrl = SolrUtils.getSolrURL(solrService);
        for (String col : colSet) {
            if (!SolrUtils.isSolrCore(solrUrl, col)) {
                throw new SearchExceptions.CollectionDoesNotExistException(col);
            }
            srcCores = (String)srcCores + "&srcCore=" + col;
        }
        HttpTag http = new HttpTag();
        Object resp = null;
        Object url = "";
        try {
            url = solrUrl + "/admin/cores?action=mergeindexes&core=" + collection + (String)srcCores;
            http.setUrl((String)url);
            resp = http.runCall().getFilecontent();
            url = solrUrl + "/" + collection + "/update?commit=true";
            http.setUrl((String)url);
            resp = http.runCall().getFilecontent();
        }
        catch (Exception e) {
            throw new SearchExceptions.UnableToMergeCollectionsException(collectionnames, e);
        }
    }

    public static boolean isSolrLocal(String solrurl) {
        return true;
    }

    static {
        solrClientMap = new HashMap<String, SolrClient>();
    }
}

