/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search.Task;

import coldfusion.orm.ORMUtils;
import coldfusion.orm.search.ORMSearchException;
import coldfusion.orm.search.ORMSearchManager;
import coldfusion.orm.search.core.CFCSearchMetadata;
import coldfusion.orm.search.core.EntityWorkSpace;
import coldfusion.orm.search.core.IndexableField;
import coldfusion.orm.search.lucene.HighlighterUtil;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;

public class SearchQueryExecutor {
    private static final int RESULT_RETRIEVAL_SIZE = 50;
    private String userQuery;
    private List<String> fieldsTobeQueried;
    private Map options;
    private String luceneQueryString;
    private QueryResult queryResult;
    private int resultSize = 50;
    private EntityWorkSpace entityWorkSpace;
    private static final String OR_STRING = " OR ";
    private static EntityLoader entityLoader = new EntityLoader();
    public static final String MAX_RESULT_COUNT = "MaxTotalCount";
    public static final String DATA = "DATA";

    public SearchQueryExecutor(String userQuery, List<String> fieldsTobeQueried, Map options) {
        this.userQuery = userQuery;
        this.fieldsTobeQueried = fieldsTobeQueried;
        this.options = options;
    }

    public QueryResult executeQuery(EntityWorkSpace workSpace) throws IOException {
        this.entityWorkSpace = workSpace;
        Query query = this.buildLuceneQuery(workSpace);
        IndexSearcher searcher = new IndexSearcher(workSpace.getIndexReader());
        Sort sort = this.parseSortOption(workSpace);
        this.queryResult = new QueryResult(searcher, query, this.options, sort, this.resultSize, this.fieldsTobeQueried);
        return this.queryResult;
    }

    private Query buildLuceneQuery(EntityWorkSpace workSpace) {
        QueryParser queryParser;
        if (this.fieldsTobeQueried != null && this.fieldsTobeQueried.size() > 0) {
            CFCSearchMetadata smd = workSpace.getSearchMetadata();
            for (String indexableField : this.fieldsTobeQueried) {
                if (smd.isFieldIndexable(indexableField)) continue;
                throw new ORMSearchException(RB.getString((Object)this, (String)"nonIndexableField", (Object)indexableField));
            }
            queryParser = new MultiFieldQueryParser(this.fieldsTobeQueried.toArray(new String[1]), (Analyzer)workSpace.getFieldSpecificAnalyzer());
            if (!this.userQuery.startsWith("\"")) {
                if (this.userQuery.indexOf(" ") > 0) {
                    this.userQuery = "\"" + this.userQuery + "\"";
                } else if (this.userQuery.endsWith("*")) {
                    this.userQuery = "(" + this.userQuery + " OR \"" + this.userQuery + "\")";
                }
            }
        } else {
            queryParser = new QueryParser(null, (Analyzer)workSpace.getFieldSpecificAnalyzer());
        }
        try {
            Query query = queryParser.parse(this.userQuery);
            return this.processRangeQuery(workSpace, query);
        }
        catch (ParseException e) {
            throw new ORMSearchException(RB.getString((Object)this, (String)"luceneQueryParseFailed", (Object)this.luceneQueryString), e);
        }
    }

    private Query processRangeQuery(EntityWorkSpace workSpace, Query query) {
        List clauses;
        if (query instanceof TermRangeQuery) {
            query = this.getNumericRangeQuery(workSpace, (TermRangeQuery)query);
        } else if (query instanceof BooleanQuery && (clauses = ((BooleanQuery)query).clauses()).size() > 0) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(((BooleanQuery)query).isCoordDisabled());
            for (BooleanClause clause : clauses) {
                if (clause.getQuery() instanceof TermRangeQuery) {
                    Query rangeQuery = this.getNumericRangeQuery(workSpace, (TermRangeQuery)clause.getQuery());
                    if (rangeQuery instanceof LegacyNumericRangeQuery) {
                        builder.add(rangeQuery, clause.getOccur());
                        continue;
                    }
                    builder.add(clause);
                    continue;
                }
                if (clause.getQuery() instanceof BooleanQuery) {
                    builder.add(this.processRangeQuery(workSpace, clause.getQuery()), clause.getOccur());
                    continue;
                }
                builder.add(clause);
            }
            return builder.build();
        }
        return query;
    }

    private Query getNumericRangeQuery(EntityWorkSpace workSpace, TermRangeQuery query) {
        String fieldName;
        CFCSearchMetadata smd = workSpace.getSearchMetadata();
        if (!smd.isFieldIndexable(fieldName = query.getField())) {
            throw new ORMSearchException(RB.getString((Object)this, (String)"nonIndexableField", (Object)fieldName));
        }
        SortField.Type type = smd.getIndexableField(fieldName).getSearchableFieldType();
        String lt = query.getLowerTerm().utf8ToString();
        String ht = query.getUpperTerm().utf8ToString();
        boolean minInclusive = query.includesLower();
        boolean maxInclusive = query.includesUpper();
        Query nmQuery = null;
        switch (type) {
            case INT: {
                int ilVal = Integer.parseInt(lt);
                int iuVal = Integer.parseInt(ht);
                if (!minInclusive) {
                    ilVal = Math.addExact(ilVal, 1);
                }
                if (!maxInclusive) {
                    iuVal = Math.addExact(iuVal, -1);
                }
                nmQuery = IntPoint.newRangeQuery((String)fieldName, (int)ilVal, (int)iuVal);
                break;
            }
            case DOUBLE: {
                Double dlVal = Double.parseDouble(lt);
                Double duVal = Double.parseDouble(ht);
                if (!minInclusive) {
                    dlVal = Math.nextUp(dlVal);
                }
                if (!maxInclusive) {
                    duVal = Math.nextDown(duVal);
                }
                nmQuery = DoublePoint.newRangeQuery((String)fieldName, (double)dlVal, (double)duVal);
                break;
            }
            case LONG: {
                long lVal = Long.parseLong(lt);
                long uVal = Long.parseLong(ht);
                if (!minInclusive) {
                    lVal = Math.addExact(lVal, 1L);
                }
                if (!maxInclusive) {
                    uVal = Math.addExact(uVal, -1L);
                }
                nmQuery = LongPoint.newRangeQuery((String)fieldName, (long)lVal, (long)uVal);
                break;
            }
            case FLOAT: {
                Float flVal = Float.valueOf(Float.parseFloat(lt));
                Float fuVal = Float.valueOf(Float.parseFloat(ht));
                if (!minInclusive) {
                    flVal = Float.valueOf(Math.nextUp(flVal.floatValue()));
                }
                if (!maxInclusive) {
                    fuVal = Float.valueOf(Math.nextDown(fuVal.floatValue()));
                }
                nmQuery = FloatPoint.newRangeQuery((String)fieldName, (float)flVal.floatValue(), (float)fuVal.floatValue());
            }
        }
        if (nmQuery != null) {
            return nmQuery;
        }
        return query;
    }

    private Sort parseSortOption(EntityWorkSpace workSpace) {
        Sort sort = null;
        String sortStringValue = (String)this.options.get("sort");
        if (sortStringValue != null) {
            SortField.Type fieldType;
            IndexableField indexableField = workSpace.getSearchMetadata().getIndexableField(sortStringValue);
            if (indexableField == null || indexableField.isIndextokenize()) {
                throw new ORMSearchException(RB.getString((Object)this, (String)"invalidSortField", (Object)sortStringValue));
            }
            SortField.Type type = SortField.Type.STRING;
            if (indexableField.getType() != null && (fieldType = indexableField.getSearchableFieldType()) != SortField.Type.SCORE) {
                type = fieldType;
            }
            sort = new Sort(new SortField(sortStringValue, type));
        }
        return sort;
    }

    public Map getResult() {
        return entityLoader.load(this.entityWorkSpace, this.queryResult);
    }

    public Map getOfflineResult(List<String> fieldsTobeSelected) {
        int firstResultIndex;
        String entityName = this.entityWorkSpace.getEntityName();
        CFCSearchMetadata smd = ORMSearchManager.getCurrentSearchFactory().getCFCSearchMetadata(entityName);
        for (String obj : fieldsTobeSelected) {
            String fieldName = obj;
            if (smd.isFieldStorable(fieldName)) continue;
            throw new ORMSearchException(RB.getString((Object)this, (String)"nonStorableField", (Object)fieldName));
        }
        Struct result = new Struct(2);
        result.put((Object)MAX_RESULT_COUNT, (Object)new Integer(this.queryResult.totalHits));
        ArrayList<Struct> entityDataList = new ArrayList<Struct>(this.queryResult.totalHits);
        result.put((Object)DATA, entityDataList);
        int i = firstResultIndex;
        for (int resultCount = (maxResults = SearchQueryExecutor.getNumericValueFromMap(this.queryResult.options, "maxResults", resultCount = this.queryResult.totalHits - (firstResultIndex = SearchQueryExecutor.getNumericValueFromMap(this.queryResult.options, "offSet", 0)))) < resultCount ? maxResults : resultCount; resultCount > 0; --resultCount) {
            try {
                Document document = this.queryResult.doc(i);
                float docScore = this.queryResult.getDocScore(i);
                Struct struct = new Struct(fieldsTobeSelected.size());
                LinkedHashMap<String, Object> contextMap = new LinkedHashMap<String, Object>(0);
                for (String obj : fieldsTobeSelected) {
                    String fieldName = obj;
                    String fieldValue = document.get(fieldName);
                    if (fieldValue == null) continue;
                    struct.put((Object)fieldName, (Object)fieldValue);
                    SearchQueryExecutor.getSearchContext(this.entityWorkSpace, this.queryResult, fieldName, fieldValue, contextMap);
                }
                Struct recordData = new Struct(2);
                recordData.put((Object)"entity", (Object)struct);
                if (!contextMap.isEmpty()) {
                    recordData.put((Object)"context", contextMap);
                }
                recordData.put((Object)"score", (Object)Float.valueOf(docScore));
                entityDataList.add(recordData);
            }
            catch (Exception e) {
                throw new ORMSearchException(RB.getString((Object)this, (String)"ResultsetParsingFailed"), e);
            }
            ++i;
        }
        return result;
    }

    private static void getSearchContext(EntityWorkSpace workSpace, QueryResult queryResult, String fieldName, String fieldValue, Map<String, Object> contextMap) throws IOException {
        int fragmentSize = SearchQueryExecutor.getNumericValueFromMap(queryResult.options, "maxCharForContext", 100);
        int fragmentNumber = SearchQueryExecutor.getNumericValueFromMap(queryResult.options, "maxBestMatch", 5);
        String beginingMarkup = (String)queryResult.options.get("contextHighlightBegin");
        String endingMarkup = (String)queryResult.options.get("contextHighlightEnd");
        HighlighterUtil highlighter = new HighlighterUtil();
        String[] fragments = highlighter.getFragmentsWithHighlightedTerms(workSpace.getAnalyzer(), queryResult.getQuery(), fieldName, fieldValue, fragmentNumber, fragmentSize);
        if (fragments.length > 0) {
            if (beginingMarkup != null && endingMarkup != null) {
                for (int i = 0; i < fragments.length; ++i) {
                    fragments[i] = fragments[i].replaceAll("<b>|<B>", beginingMarkup);
                    fragments[i] = fragments[i].replaceAll("</b>|</B>", endingMarkup);
                }
            }
            contextMap.put(fieldName, fragments);
        }
    }

    private static int getNumericValueFromMap(Map map, String key, int defaultValue) {
        Object value = map.get(key);
        if (value != null) {
            try {
                return Cast._int(value, (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public class QueryResult {
        private Query luceneQuery;
        private IndexSearcher searcher;
        private Map options;
        private Sort sort;
        private int totalHits;
        private TopDocs topDocs;
        private List<String> fieldsTobeQueried;

        public QueryResult(IndexSearcher searcher, Query preparedQuery, Map options, Sort sort, int resultSize, List<String> fieldsTobeQueried) throws IOException {
            this.luceneQuery = preparedQuery;
            this.searcher = searcher;
            this.options = options;
            this.sort = sort;
            this.fieldsTobeQueried = fieldsTobeQueried;
            this.executeSearchCommand(resultSize);
            this.totalHits = this.topDocs.totalHits;
        }

        public List<String> getFieldsTobeQueried() {
            return this.fieldsTobeQueried;
        }

        public Document doc(int index) throws IOException {
            return this.searcher.doc(this.docId(index));
        }

        public float getDocScore(int index) throws IOException {
            ScoreDoc scoreDoc = this.topDocs.scoreDocs[index];
            if (scoreDoc != null) {
                return scoreDoc.score;
            }
            return 0.0f;
        }

        public int docId(int index) throws IOException {
            return this.scoreDoc((int)index).doc;
        }

        public ScoreDoc scoreDoc(int index) throws IOException {
            if (index >= this.totalHits) {
                throw new ORMSearchException(RB.getString((Object)this, (String)"ResultIndexOutOfBound", (Object)index, (Object)this.totalHits));
            }
            if (index >= this.topDocs.scoreDocs.length) {
                this.executeSearchCommand(2 * index);
            }
            return this.topDocs.scoreDocs[index];
        }

        public Query getQuery() {
            return this.luceneQuery;
        }

        private void executeSearchCommand(int size) throws IOException {
            this.topDocs = this.sort == null ? this.searcher.search(this.luceneQuery, size) : this.searcher.search(this.luceneQuery, size, this.sort, true, false);
        }
    }

    public static class EntityLoader {
        public Map load(EntityWorkSpace workSpace, QueryResult queryResult) {
            String entityName = workSpace.getEntityName();
            CFCSearchMetadata smd = ORMSearchManager.getCurrentSearchFactory().getCFCSearchMetadata(entityName);
            Struct result = new Struct(2);
            result.put((Object)SearchQueryExecutor.MAX_RESULT_COUNT, (Object)new Integer(queryResult.totalHits));
            ArrayList<Struct> entityDataList = new ArrayList<Struct>(queryResult.totalHits);
            result.put((Object)SearchQueryExecutor.DATA, entityDataList);
            int firstResultIndex = SearchQueryExecutor.getNumericValueFromMap(queryResult.options, "offSet", 0);
            int resultCount = queryResult.totalHits - firstResultIndex;
            int maxResults = SearchQueryExecutor.getNumericValueFromMap(queryResult.options, "maxResults", resultCount);
            int i = firstResultIndex;
            for (resultCount = maxResults < resultCount ? maxResults : resultCount; resultCount > 0; --resultCount) {
                block9: {
                    try {
                        Document doc = queryResult.doc(i);
                        float docScore = queryResult.getDocScore(i);
                        HashMap<String, String> pkMap = new HashMap<String, String>();
                        for (IndexableField indexableField : smd.getIndexableIDFields()) {
                            String fieldValue;
                            Field field = (Field)doc.getField(indexableField.getIndexFieldName());
                            if (field == null || (fieldValue = field.stringValue()) == null) continue;
                            pkMap.put(indexableField.getName(), fieldValue);
                        }
                        Object entity = ORMUtils.entityLoad((String)entityName, pkMap, (Object)true);
                        if (entity == null) break block9;
                        LinkedHashMap<String, Object> contextMap = new LinkedHashMap<String, Object>(0);
                        if (queryResult.getFieldsTobeQueried() != null && !queryResult.getFieldsTobeQueried().isEmpty()) {
                            for (String fieldName : queryResult.getFieldsTobeQueried()) {
                                String fieldValue;
                                Field field = (Field)doc.getField(fieldName);
                                if (field == null || (fieldValue = field.stringValue()) == null) continue;
                                SearchQueryExecutor.getSearchContext(workSpace, queryResult, fieldName, fieldValue, contextMap);
                            }
                        } else {
                            for (IndexableField indexableField : smd.getIndexableFields()) {
                                String fieldValue;
                                String fieldName;
                                Field field;
                                if (!indexableField.isIndexStorable() || (field = (Field)doc.getField(fieldName = indexableField.getIndexFieldName())) == null || (fieldValue = field.stringValue()) == null) continue;
                                SearchQueryExecutor.getSearchContext(workSpace, queryResult, fieldName, fieldValue, contextMap);
                            }
                        }
                        Struct recordData = new Struct(2);
                        recordData.put((Object)"entity", entity);
                        if (!contextMap.isEmpty()) {
                            recordData.put((Object)"context", contextMap);
                        }
                        recordData.put((Object)"score", (Object)Float.valueOf(docScore));
                        entityDataList.add(recordData);
                    }
                    catch (Exception e) {
                        throw new ORMSearchException(RB.getString((Object)this, (String)"EntityLoadFailed"), e);
                    }
                }
                ++i;
            }
            return result;
        }
    }
}

