/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search;

import coldfusion.orm.ORMSettings;
import coldfusion.orm.hibernate.HibernateConfiguration;
import coldfusion.orm.search.ORMIndexEventHandler;
import coldfusion.orm.search.ORMSearchManager;
import coldfusion.orm.search.ORMSearchSettings;
import coldfusion.orm.search.core.CFCSearchMetadata;
import coldfusion.orm.search.core.SearchPropertyBinder;
import coldfusion.runtime.ApplicationScope;
import coldfusion.server.ORMSearchService;
import java.util.Map;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;

public class ORMSearchServiceImpl
implements ORMSearchService {
    public Object getSearchSettings(Map<String, Object> ormSettings) {
        return new ORMSearchSettings(ormSettings);
    }

    public void setSearchSettings(Object ormsearchSettings) {
        if (ormsearchSettings instanceof ORMSearchSettings) {
            ORMSearchManager.getCurrentSearchFactory().setSearchSettings((ORMSearchSettings)ormsearchSettings);
        }
    }

    public boolean isAutoIndex(Object ormsearchSettings) {
        if (ormsearchSettings instanceof ORMSearchSettings) {
            return ((ORMSearchSettings)ormsearchSettings).isAutoIndex();
        }
        return false;
    }

    public String getLanguage(Object ormsearchSettings) {
        if (ormsearchSettings instanceof ORMSearchSettings) {
            return ((ORMSearchSettings)ormsearchSettings).getLanguage();
        }
        return null;
    }

    public Object getSearchManager() {
        return ORMSearchManager.getInstance();
    }

    public void onFlush() {
        ((ORMSearchManager)this.getSearchManager()).onFlush();
    }

    public void ORMIndex() {
        ((ORMSearchManager)this.getSearchManager()).ORMIndex();
    }

    public void ORMIndex(Object entityName) {
        ((ORMSearchManager)this.getSearchManager()).ORMIndex(entityName);
    }

    public void ORMIndexPurge() {
        ((ORMSearchManager)this.getSearchManager()).ORMIndexPurge();
    }

    public void ORMIndexPurge(String entityName) {
        ((ORMSearchManager)this.getSearchManager()).ORMIndexPurge(entityName);
    }

    public Object ORMSearch(String query, String entityName) {
        return ((ORMSearchManager)this.getSearchManager()).ORMSearch(query, entityName);
    }

    public Object ORMSearch(String query, String entityName, Object fieldNames) {
        return ((ORMSearchManager)this.getSearchManager()).ORMSearch(query, entityName, fieldNames);
    }

    public Object ORMSearch(String query, String entityName, Object fieldNames, Map options) {
        return ((ORMSearchManager)this.getSearchManager()).ORMSearch(query, entityName, fieldNames, options);
    }

    public Object ORMSearchOffline(String query, String entityName, Object fieldTobeSelected) {
        return ((ORMSearchManager)this.getSearchManager()).ORMSearchOffline(query, entityName, fieldTobeSelected);
    }

    public Object ORMSearchOffline(String query, String entityName, Object fieldTobeSelected, Object fieldNames) {
        return ((ORMSearchManager)this.getSearchManager()).ORMSearchOffline(query, entityName, fieldTobeSelected, fieldNames);
    }

    public Object ORMSearchOffline(String query, String entityName, Object fieldTobeSelected, Object fieldNames, Map options) {
        return ((ORMSearchManager)this.getSearchManager()).ORMSearchOffline(query, entityName, fieldTobeSelected, fieldNames, options);
    }

    public void appendIndexEventListener(Object eventListenerRegistry) {
        ORMIndexEventHandler indexListener = new ORMIndexEventHandler();
        ((EventListenerRegistry)eventListenerRegistry).getEventListenerGroup(EventType.POST_INSERT).appendListener((Object)indexListener);
        ((EventListenerRegistry)eventListenerRegistry).getEventListenerGroup(EventType.POST_UPDATE).appendListener((Object)indexListener);
        ((EventListenerRegistry)eventListenerRegistry).getEventListenerGroup(EventType.POST_DELETE).appendListener((Object)indexListener);
    }

    public void addCFCSearchMetadata(String pathToCFC, Object ormSettings, Object hibernateConf) {
        try {
            SearchPropertyBinder searchBinder = new SearchPropertyBinder(pathToCFC, (ORMSettings)ormSettings, (HibernateConfiguration)hibernateConf);
            if (searchBinder.isIndexable()) {
                CFCSearchMetadata searchMetadata = searchBinder.getCFCSearchMetadata();
                ORMSearchManager.getCurrentSearchFactory().addCFCSearchMetadata(searchMetadata.getEntityName(), searchMetadata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void buildIndexHierarchyGraph() {
        ORMSearchManager.getCurrentSearchFactory().buildIndexHierarchyGraph();
    }

    public void onCommit() {
        ORMSearchManager searchManager = ORMSearchManager.getInstance();
        if (searchManager != null) {
            searchManager.onCommit();
        }
    }

    public void onRollBack() {
        ORMSearchManager searchManager = ORMSearchManager.getInstance();
        if (searchManager != null) {
            searchManager.onRollBack();
        }
    }

    public void onPageRequestEnd(Throwable t) {
        ORMSearchManager searchManager = ORMSearchManager.getInstance();
        if (searchManager != null) {
            searchManager.onPageRequestEnd(t);
        }
    }

    public void onRequestEnd() {
        ORMSearchManager searchManager = ORMSearchManager.getInstance();
        if (searchManager != null) {
            searchManager.onRequestEnd();
        }
    }

    public void removeSearchFactory(ApplicationScope app) {
        ORMSearchManager.removeSearchFactory(app);
    }
}

