/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.search;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.demo.html.HTMLParser;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class HTMLDocument {
    static char dirSep = System.getProperty("file.separator").charAt(0);

    public static String uid(File f) {
        return f.getPath().replace(dirSep, '\u0000') + "\u0000" + DateTools.timeToString((long)f.lastModified(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
    }

    public static String uid2url(String uid) {
        String url = uid.replace('\u0000', '/');
        return url.substring(0, url.lastIndexOf(47));
    }

    public static Document Document(File f, String key, String title, String url, String body) throws IOException, InterruptedException {
        Document doc = new Document();
        Field field = new Field("url", url, TextField.TYPE_STORED);
        doc.add((IndexableField)field);
        field = new Field("path", f.getPath(), TextField.TYPE_STORED);
        doc.add((IndexableField)field);
        FieldType ft = new FieldType(StringField.TYPE_STORED);
        ft.setOmitNorms(false);
        field = new Field("title", title, ft);
        doc.add((IndexableField)field);
        field = new Field("contents", body, ft);
        doc.add((IndexableField)field);
        int summarylength = Math.min(body.length(), 100);
        field = new Field("summary", body.substring(0, summarylength), TextField.TYPE_STORED);
        doc.add((IndexableField)field);
        field = new Field("key", key, TextField.TYPE_STORED);
        doc.add((IndexableField)field);
        return doc;
    }

    public static Document Document(File f, String url) throws IOException, InterruptedException {
        Document doc = new Document();
        Field field = new Field("url", url, TextField.TYPE_STORED);
        doc.add((IndexableField)field);
        field = new Field("key", f.getPath(), TextField.TYPE_STORED);
        doc.add((IndexableField)field);
        FieldType ft = new FieldType(StringField.TYPE_STORED);
        ft.setOmitNorms(false);
        String dt = DateTools.timeToString((long)f.lastModified(), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        doc.add((IndexableField)new Field("modified", dt, ft));
        FieldType nft = new FieldType(StringField.TYPE_NOT_STORED);
        nft.setOmitNorms(false);
        doc.add((IndexableField)new Field("uid", HTMLDocument.uid(f), nft));
        FileInputStream fstream = new FileInputStream(f);
        HTMLParser parser = new HTMLParser((InputStream)fstream);
        doc.add((IndexableField)new Field("contents", parser.getReader(), ft));
        doc.add((IndexableField)new Field("summary", parser.getSummary(), ft));
        doc.add((IndexableField)new Field("title", parser.getTitle(), ft));
        return doc;
    }

    private HTMLDocument() {
    }

    public boolean isStoreOffsetWithTermVector() {
        return true;
    }
}

