/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import coldfusion.document.DocumentFontException;
import coldfusion.document.font.BrowserFontProvider;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.util.JRTextAttribute;

public class JRFontUtil {
    public static Map getNonPdfAttributes(JRFont font) {
        HashMap nonPdfAttributes = new HashMap();
        JRFontUtil.setNonPdfAttributes(nonPdfAttributes, font);
        return nonPdfAttributes;
    }

    private static Map setNonPdfAttributes(Map attributes, JRFont font) {
        String fontName;
        Font awtFont;
        int fontStyle = 0;
        attributes.put(TextAttribute.SIZE, new Float(font.getFontSize()));
        if (font.isBold()) {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            fontStyle |= 1;
        }
        if (font.isItalic()) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            fontStyle |= 2;
        }
        if (font.isUnderline()) {
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (font.isStrikeThrough()) {
            attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if ((awtFont = JRFontUtil.pdfToAwfFont(fontName = font.getPdfFontName(), fontStyle, font.getFontSize())) != null) {
            attributes.put(TextAttribute.FONT, awtFont);
            attributes.put(TextAttribute.FAMILY, font.getFontName());
        } else if (fontName.toLowerCase().startsWith("courier")) {
            attributes.put(TextAttribute.FAMILY, "monospaced");
        } else if (fontName.toLowerCase().startsWith("minionpro")) {
            attributes.put(TextAttribute.FAMILY, "serif");
        } else if (fontName.toLowerCase().startsWith("myriadpro")) {
            attributes.put(TextAttribute.FAMILY, "sansserif");
        } else {
            attributes.put(TextAttribute.FAMILY, font.getFontName());
        }
        return attributes;
    }

    public static Map setAttributes(Map attributes, JRFont font) {
        attributes = JRFontUtil.setNonPdfAttributes(attributes, font);
        attributes.put(JRTextAttribute.PDF_FONT_NAME, font.getPdfFontName());
        attributes.put(JRTextAttribute.PDF_ENCODING, font.getPdfEncoding());
        if (font.isPdfEmbedded()) {
            attributes.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.TRUE);
        }
        return attributes;
    }

    private static Font pdfToAwfFont(String name, int style, int size) {
        Font awtFont = null;
        BrowserFontProvider browserFont = BrowserFontProvider.getInstance();
        try {
            awtFont = browserFont.getFont(name, style, size);
        }
        catch (DocumentFontException documentFontException) {
            // empty catch block
        }
        return awtFont;
    }
}

