/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillBreak;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCrosstab;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillFrame;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRYComparator;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRFillElementContainer
extends JRFillElementGroup {
    protected JRBaseFiller filler;
    private JRFillElement[] ySortedElements = null;
    private JRFillElement[] stretchElements = null;
    private JRFillElement[] bandBottomElements = null;
    private JRFillElement[] removableElements = null;
    private boolean willOverflow = false;
    protected boolean isOverflow = false;
    private int stretchHeight = 0;
    private int firstY = 0;
    protected JRFillElement firstYElement = null;
    protected final JRFillExpressionEvaluator expressionEvaluator;
    protected JRFillElement[] deepElements;
    protected Set stylesToEvaluate = new HashSet();
    protected Map evaluatedStyles = new HashMap();
    protected boolean hasPrintWhenOverflowElement;

    protected JRFillElementContainer(JRBaseFiller filler, JRElementGroup container, JRFillObjectFactory factory) {
        super(container, factory);
        this.expressionEvaluator = factory.getExpressionEvaluator();
        this.initDeepElements();
        this.filler = filler;
    }

    protected JRFillElementContainer(JRFillElementContainer container, JRFillCloneFactory factory) {
        super(container, factory);
        this.expressionEvaluator = container.expressionEvaluator;
        this.initDeepElements();
        this.filler = container.filler;
    }

    private void initDeepElements() {
        if (this.elements == null) {
            this.deepElements = new JRFillElement[0];
        } else {
            ArrayList deepElementsList = new ArrayList(this.elements.length);
            JRFillElementContainer.collectDeepElements(this.elements, deepElementsList);
            this.deepElements = new JRFillElement[deepElementsList.size()];
            deepElementsList.toArray(this.deepElements);
        }
    }

    private static void collectDeepElements(JRElement[] elements, List deepElementsList) {
        for (int i = 0; i < elements.length; ++i) {
            JRElement element = elements[i];
            deepElementsList.add(element);
            if (!(element instanceof JRFillFrame)) continue;
            JRFrame frame = (JRFrame)element;
            JRFillElementContainer.collectDeepElements(frame.getElements(), deepElementsList);
        }
    }

    protected final void initElements() {
        this.hasPrintWhenOverflowElement = false;
        if (this.elements != null && this.elements.length > 0) {
            ArrayList<JRFillElement> sortedElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> stretchElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> bandBottomElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> removableElemsList = new ArrayList<JRFillElement>();
            for (int i = 0; i < this.elements.length; ++i) {
                JRFillElement element = this.elements[i];
                sortedElemsList.add(element);
                if (element.getPositionType() == 3) {
                    bandBottomElemsList.add(element);
                }
                if (element.getStretchType() != 0) {
                    stretchElemsList.add(element);
                }
                if (element.isRemoveLineWhenBlank()) {
                    removableElemsList.add(element);
                }
                if (!element.isPrintWhenDetailOverflows()) continue;
                this.hasPrintWhenOverflowElement = true;
            }
            Collections.sort(sortedElemsList, new JRYComparator());
            this.ySortedElements = new JRFillElement[this.elements.length];
            sortedElemsList.toArray(this.ySortedElements);
            this.stretchElements = new JRFillElement[stretchElemsList.size()];
            stretchElemsList.toArray(this.stretchElements);
            this.bandBottomElements = new JRFillElement[bandBottomElemsList.size()];
            bandBottomElemsList.toArray(this.bandBottomElements);
            this.removableElements = new JRFillElement[removableElemsList.size()];
            removableElemsList.toArray(this.removableElements);
        }
        this.setDependentElements();
        this.setElementsBandBottomY();
    }

    protected final void setElementsBandBottomY() {
        if (this.elements != null && this.elements.length > 0) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i].setBandBottomY(this.getContainerHeight() - this.elements[i].getY() - this.elements[i].getHeight());
            }
        }
    }

    private void setDependentElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length - 1; ++i) {
                JRFillElement iElem = this.ySortedElements[i];
                boolean isBreakElem = iElem instanceof JRFillBreak;
                for (int j = i + 1; j < this.ySortedElements.length; ++j) {
                    JRFillElement jElem = this.ySortedElements[j];
                    int left = Math.min(iElem.getX(), jElem.getX());
                    int right = Math.max(iElem.getX() + iElem.getWidth(), jElem.getX() + jElem.getWidth());
                    if ((!isBreakElem || jElem.getPositionType() != 2) && jElem.getPositionType() != 1 || iElem.getY() + iElem.getHeight() > jElem.getY() || iElem.getWidth() + jElem.getWidth() <= right - left) continue;
                    iElem.addDependantElement(jElem);
                }
            }
        }
    }

    protected void evaluate(byte evaluation) throws JRException {
        JRElement[] allElements = this.getElements();
        if (allElements != null && allElements.length > 0) {
            for (int i = 0; i < allElements.length; ++i) {
                JRFillElement element = (JRFillElement)allElements[i];
                element.setCurrentEvaluation(evaluation);
                element.evaluate(evaluation);
            }
        }
    }

    protected void resetElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement element = this.ySortedElements[i];
                element.reset();
                if (this.isOverflow) continue;
                element.setAlreadyPrinted(false);
            }
        }
    }

    protected boolean willOverflow() {
        return this.willOverflow;
    }

    protected void initFill() {
        this.isOverflow = this.willOverflow;
        this.firstY = 0;
        this.firstYElement = null;
    }

    protected void prepareElements(int availableStretchHeight, boolean isOverflowAllowed) throws JRException {
        boolean tmpWillOverflow = false;
        int maxBandStretch = 0;
        int bandStretch = 0;
        if (availableStretchHeight < 0) {
            availableStretchHeight = 0;
        }
        this.firstY = this.isOverflow ? this.getContainerHeight() : 0;
        this.firstYElement = null;
        boolean isFirstYFound = false;
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement element = this.ySortedElements[i];
                tmpWillOverflow = element.prepare(availableStretchHeight + this.getElementFirstY(element), this.isOverflow) || tmpWillOverflow;
                element.moveDependantElements();
                if (!element.isToPrint()) continue;
                if (this.isOverflow) {
                    if (element.isReprinted()) {
                        this.firstY = 0;
                    } else if (!isFirstYFound) {
                        this.firstY = element.getY();
                    }
                    isFirstYFound = true;
                }
                this.firstYElement = element;
                bandStretch = element.getRelativeY() + element.getStretchHeight() - this.getContainerHeight() + element.getBandBottomY();
                if (bandStretch <= maxBandStretch) continue;
                maxBandStretch = bandStretch;
            }
        }
        if (maxBandStretch > availableStretchHeight + this.firstY) {
            tmpWillOverflow = true;
        }
        this.stretchHeight = tmpWillOverflow ? this.getContainerHeight() + availableStretchHeight : this.getContainerHeight() + maxBandStretch;
        this.willOverflow = tmpWillOverflow && isOverflowAllowed;
    }

    private int getElementFirstY(JRFillElement element) {
        int elemFirstY = !this.isOverflow || this.hasPrintWhenOverflowElement ? 0 : (element.getY() >= this.firstY ? this.firstY : element.getY());
        return elemFirstY;
    }

    protected void setStretchHeight(int stretchHeight) {
        if (stretchHeight > this.stretchHeight) {
            this.stretchHeight = stretchHeight;
        }
    }

    protected void stretchElements() {
        JRFillElement element;
        int i;
        if (this.stretchElements != null && this.stretchElements.length > 0) {
            for (i = 0; i < this.stretchElements.length; ++i) {
                element = this.stretchElements[i];
                element.stretchElement(this.stretchHeight - this.getContainerHeight());
                element.moveDependantElements();
            }
        }
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (i = 0; i < this.ySortedElements.length; ++i) {
                element = this.ySortedElements[i];
                element.stretchHeightFinal();
            }
        }
    }

    protected int getStretchHeight() {
        return this.stretchHeight;
    }

    protected void moveBandBottomElements() {
        if (this.bandBottomElements != null && this.bandBottomElements.length > 0) {
            for (int i = 0; i < this.bandBottomElements.length; ++i) {
                JRFillElement element = this.bandBottomElements[i];
                element.setRelativeY(element.getY() + this.stretchHeight - this.getContainerHeight());
                element.setToPrint(element.isToPrint() && !this.willOverflow);
            }
        }
    }

    protected void removeBlankElements() {
        JRFillElement[] remElems = this.removableElements;
        if (remElems != null && remElems.length > 0) {
            JRFillElement[] elems = this.ySortedElements;
            for (int i = 0; i < remElems.length; ++i) {
                JRFillElement jElem;
                int j;
                JRFillElement iElem = remElems[i];
                int blankHeight = iElem.isToPrint() ? iElem.getHeight() - iElem.getStretchHeight() : iElem.getHeight();
                if (blankHeight <= 0 || iElem.getRelativeY() + iElem.getStretchHeight() > this.stretchHeight || iElem.getRelativeY() < this.firstY) continue;
                int blankY = iElem.getRelativeY() + iElem.getHeight() - blankHeight;
                boolean isToRemove = true;
                for (j = 0; j < elems.length; ++j) {
                    jElem = elems[j];
                    if (iElem == jElem || !jElem.isToPrint()) continue;
                    int top = Math.min(blankY, jElem.getRelativeY());
                    int bottom = Math.max(blankY + blankHeight, jElem.getRelativeY() + jElem.getStretchHeight());
                    if (blankHeight + jElem.getStretchHeight() <= bottom - top) continue;
                    isToRemove = false;
                    break;
                }
                if (!isToRemove) continue;
                for (j = 0; j < elems.length; ++j) {
                    jElem = elems[j];
                    if (jElem.getRelativeY() < blankY + blankHeight) continue;
                    jElem.setRelativeY(jElem.getRelativeY() - blankHeight);
                }
                this.stretchHeight -= blankHeight;
            }
        }
    }

    protected void fillElements(JRPrintElementContainer printContainer) throws JRException {
        JRElement[] allElements = this.getElements();
        if (allElements != null && allElements.length > 0) {
            for (int i = 0; i < allElements.length; ++i) {
                JRPrintElement printElement;
                JRFillElement element = (JRFillElement)allElements[i];
                element.setRelativeY(element.getRelativeY() - this.firstY);
                if (element.getRelativeY() + element.getStretchHeight() > this.stretchHeight) {
                    if (this.getIsStretchWithOverflow()) {
                        this.stretchHeight = element.getRelativeY() + element.getStretchHeight();
                    } else {
                        element.setToPrint(false);
                    }
                }
                element.setAlreadyPrinted(element.isToPrint() || element.isAlreadyPrinted());
                if (!element.isToPrint() || (printElement = element.fill()) == null) continue;
                printContainer.addElement(printElement);
                if (element instanceof JRFillSubreport) {
                    JRStyle[] styles;
                    JRFillSubreport subreport = (JRFillSubreport)element;
                    JRReportFont[] fonts = subreport.getFonts();
                    if (fonts != null) {
                        for (int j = 0; j < fonts.length; ++j) {
                            this.filler.getJasperPrint().addFont(fonts[j], true);
                        }
                    }
                    if ((styles = subreport.getStyles()) != null) {
                        for (int j = 0; j < styles.length; ++j) {
                            this.filler.getJasperPrint().addStyle(styles[j], true);
                        }
                    }
                    Collection printElements = subreport.getPrintElements();
                    this.addSubElements(printContainer, element, printElements);
                    continue;
                }
                if (!(element instanceof JRFillCrosstab)) continue;
                List printElements = ((JRFillCrosstab)element).getPrintElements();
                this.addSubElements(printContainer, element, printElements);
            }
        }
        printContainer.setHeight(this.stretchHeight - this.firstY);
    }

    protected void addSubElements(JRPrintElementContainer printContainer, JRFillElement element, Collection printElements) {
        if (printElements != null && printElements.size() > 0) {
            for (JRPrintElement printElement : printElements) {
                printElement.setX(element.getX() + printElement.getX());
                printElement.setY(element.getRelativeY() + printElement.getY());
                printContainer.addElement(printElement);
            }
        }
    }

    protected void rewind() throws JRException {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement element = this.ySortedElements[i];
                element.rewind();
                element.setAlreadyPrinted(false);
            }
        }
        this.willOverflow = false;
    }

    protected int getFirstY() {
        return this.firstY;
    }

    protected abstract int getContainerHeight();

    protected void initConditionalStyles() {
        int i;
        this.collectConditionalStyle(this.filler.getDefaultStyle());
        for (i = 0; i < this.deepElements.length; ++i) {
            JRStyle style = this.deepElements[i].initStyle;
            this.collectConditionalStyle(style);
        }
        if (this.deepElements.length > 0) {
            for (i = 0; i < this.deepElements.length; ++i) {
                this.deepElements[i].setConditionalStylesContainer(this);
            }
        }
    }

    protected void collectConditionalStyle(JRStyle style) {
        if (style != null) {
            this.stylesToEvaluate.add(style);
        }
    }

    protected void evaluateConditionalStyles(byte evaluation) throws JRException {
        Iterator it = this.stylesToEvaluate.iterator();
        while (it.hasNext()) {
            this.evaluateConditionalStyle((JRStyle)it.next(), evaluation);
        }
    }

    protected JRStyle evaluateConditionalStyle(JRStyle initialStyle, byte evaluation) throws JRException {
        String consolidatedStyleName;
        JRStyle consolidatedStyle = initialStyle;
        StringBuffer code = new StringBuffer();
        ArrayList condStylesToApply = new ArrayList();
        boolean anyTrue = this.buildConsolidatedStyle(initialStyle, evaluation, code, condStylesToApply);
        if (anyTrue && (consolidatedStyle = this.filler.getConsolidatedStyle(consolidatedStyleName = initialStyle.getName() + code.toString())) == null) {
            consolidatedStyle = new JRBaseStyle(consolidatedStyleName);
            for (int j = condStylesToApply.size() - 1; j >= 0; --j) {
                JRStyleResolver.appendStyle(consolidatedStyle, (JRStyle)condStylesToApply.get(j));
            }
            this.filler.putConsolidatedStyle(consolidatedStyle);
        }
        this.evaluatedStyles.put(initialStyle, consolidatedStyle);
        return consolidatedStyle;
    }

    protected boolean buildConsolidatedStyle(JRStyle style, byte evaluation, StringBuffer code, List condStylesToApply) throws JRException {
        boolean anyTrue = false;
        JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
        if (conditionalStyles != null && conditionalStyles.length > 0) {
            for (int j = 0; j < conditionalStyles.length; ++j) {
                JRConditionalStyle conditionalStyle = conditionalStyles[j];
                Boolean expressionValue = (Boolean)this.expressionEvaluator.evaluate(conditionalStyle.getConditionExpression(), evaluation);
                boolean condition = expressionValue == null ? false : expressionValue;
                code.append(condition ? (char)'1' : '0');
                anyTrue |= condition;
                if (!condition) continue;
                condStylesToApply.add(conditionalStyle);
            }
        }
        condStylesToApply.add(style);
        if (style.getStyle() != null) {
            anyTrue |= this.buildConsolidatedStyle(style.getStyle(), evaluation, code, condStylesToApply);
        }
        return anyTrue;
    }

    public JRStyle getEvaluatedConditionalStyle(JRStyle parentStyle) {
        return (JRStyle)this.evaluatedStyles.get(parentStyle);
    }

    public abstract boolean getIsStretchWithOverflow();
}

