/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.base;

import java.io.Serializable;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public abstract class JRBaseCrosstabGroup
implements JRCrosstabGroup,
Serializable {
    protected String name;
    protected byte totalPosition = 0;
    protected JRCrosstabBucket bucket;
    protected JRCellContents header;
    protected JRCellContents totalHeader;
    protected JRVariable variable;

    protected JRBaseCrosstabGroup() {
    }

    public JRBaseCrosstabGroup(JRCrosstabGroup group, JRBaseObjectFactory factory) {
        factory.put(group, this);
        this.name = group.getName();
        this.totalPosition = group.getTotalPosition();
        this.bucket = factory.getCrosstabBucket(group.getBucket());
        this.header = factory.getCell(group.getHeader());
        this.totalHeader = factory.getCell(group.getTotalHeader());
        this.variable = factory.getVariable(group.getVariable());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JRCrosstabBucket getBucket() {
        return this.bucket;
    }

    @Override
    public byte getTotalPosition() {
        return this.totalPosition;
    }

    @Override
    public boolean hasTotal() {
        return this.totalPosition != 0;
    }

    @Override
    public JRCellContents getHeader() {
        return this.header;
    }

    @Override
    public JRCellContents getTotalHeader() {
        return this.totalHeader;
    }

    @Override
    public JRVariable getVariable() {
        return this.variable;
    }
}

