/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.report;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.report.X11Color;
import com.lowagie.text.FontFactory;
import java.awt.Color;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.css.sac.LexicalUnit;

class CSSStyleImporter {
    private static final String CSS_default_style = "default-style";
    private static final String CCS_transparency_mode = "transparency-mode";
    private static final String CSS_color = "color";
    private static final String CSS_background_color = "background-color";
    private static final String CSS_style = "parent-style";
    private static final String CSS_line_size = "line-size";
    private static final String CSS_corner_radius = "corner-radius";
    private static final String CSS_clip = "clip";
    private static final String CSS_text_align = "text-align";
    private static final String CSS_vertical_align = "vertical-align";
    private static final String CSS_border = "border";
    private static final String CSS_border_style = "border-style";
    private static final String CSS_border_color = "border-color";
    private static final String CSS_border_width = "border-width";
    private static final String CSS_border_top_style = "border-top-style";
    private static final String CSS_border_top_color = "border-top-color";
    private static final String CSS_border_top_width = "border-top-width";
    private static final String CSS_border_left_style = "border-left-style";
    private static final String CSS_border_left_color = "border-left-color";
    private static final String CSS_border_left_width = "border-left-width";
    private static final String CSS_border_bottom_style = "border-bottom-style";
    private static final String CSS_border_bottom_color = "border-bottom-color";
    private static final String CSS_border_bottom_width = "border-bottom-width";
    private static final String CSS_border_right_style = "border-right-style";
    private static final String CSS_border_right_color = "border-right-color";
    private static final String CSS_border_right_width = "border-right-width";
    public static final String CSS_margin = "margin";
    private static final String CSS_margin_top = "margin-top";
    private static final String CSS_margin_left = "margin-left";
    private static final String CSS_margin_bottom = "margin-bottom";
    private static final String CSS_margin_right = "margin-right";
    public static final String CSS_font = "font";
    public static final String CSS_font_style = "font-style";
    private static final String CSS_font_weight = "font-weight";
    private static final String CSS_font_size = "font-size";
    private static final String CSS_font_family = "font-family";
    private static final String CSS_text_rotation = "text-rotation";
    public static final String CSS_text_decoration = "text-decoration";
    private static final String CSS_line_height = "line-height";
    private static final String CSS_embed_pdf = "embed-pdf-font";
    private static final String CSS_xhtml_formatted_text = "xhtml-formatted-text";
    private static final String CSS_empty_cells = "empty-cells";
    private static final String[] defaultFontList = new String[]{"Arial", "Helvetcia", "sansserif"};
    private static final Logger logger = CFLogs.APPLICATION_LOG;
    private JasperDesign jasperDesign;
    private Map propertiesMap;
    private JRDesignStyle style = null;
    String[] fontList = null;
    private ByteBox borderBox = new ByteBox();
    private ColorBox borderColorBox = new ColorBox();

    protected CSSStyleImporter(Map propertiesMap, JasperDesign jasperDesign) {
        this.propertiesMap = propertiesMap;
        this.jasperDesign = jasperDesign;
    }

    protected void replaceStyle(String styleName) {
        Boolean isStyled;
        Color backcolor;
        JRDesignStyle oldStyle;
        if (styleName == null || styleName.length() == 0) {
            return;
        }
        Boolean isDefault = this.getBoolean(CSS_default_style);
        if (isDefault == null) {
            isDefault = new Boolean(false);
        }
        if ((oldStyle = (JRDesignStyle)this.jasperDesign.getStylesMap().get(styleName)) == null) {
            this.style = new JRDesignStyle();
            this.style.setName(styleName);
            try {
                this.jasperDesign.addStyle(this.style);
            }
            catch (JRException jRException) {}
        } else {
            this.style = oldStyle;
            this.style.init();
            this.style.setName(styleName);
        }
        this.style.setDefault(isDefault);
        if (isDefault.booleanValue()) {
            this.jasperDesign.setDefaultStyle(this.style);
        }
        this.setParentStyle();
        this.setTransparencyMode();
        this.setBorder();
        this.setBorderStyle();
        this.setBorderWidth();
        this.setBorderColor();
        Color forecolor = this.getColor(CSS_color);
        if (forecolor != null) {
            this.style.setForecolor(forecolor);
        }
        if ((backcolor = this.getColor(CSS_background_color)) != null) {
            this.style.setBackcolor(backcolor);
        }
        this.setLineSize();
        Integer radius = this.getInteger(CSS_corner_radius);
        if (radius != null) {
            this.style.setRadius(radius);
        }
        this.setClip();
        this.setMargin();
        this.setFont();
        this.setFontStyle();
        this.setFontWeight();
        this.setFontSize();
        this.setLineHeight();
        this.setFontFamily();
        this.setTextDecoration();
        this.setTextRotation();
        this.setTextAlign();
        this.setVerticalAlign();
        Boolean isEmbedded = this.getBoolean(CSS_embed_pdf);
        if (isEmbedded != null) {
            this.style.setPdfEmbedded(isEmbedded);
        }
        if ((isStyled = this.getBoolean(CSS_xhtml_formatted_text)) != null) {
            this.style.setStyledText(isStyled);
        }
        this.setEmptyCells();
        this.dumpStyle();
    }

    private void dumpStyle() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("++++" + this.style.getName() + "++++"));
            logger.debug((Object)("color:" + this.style.getOwnForecolor()));
            logger.debug((Object)("background-color:" + this.style.getOwnBackcolor()));
            logger.debug((Object)("transparency-mode:" + JRXmlConstants.getModeMap().get(this.style.getOwnMode())));
            logger.debug((Object)("line-size:" + JRXmlConstants.getPenMap().get(this.style.getOwnPen())));
            logger.debug((Object)("corner-radius:" + this.style.getOwnRadius()));
            logger.debug((Object)("clip:" + JRXmlConstants.getScaleImageMap().get(this.style.getOwnScaleImage())));
            if (this.style.getOwnBorder() != null) {
                logger.debug((Object)("border:" + JRXmlConstants.getPenMap().get(this.style.getOwnBorder())));
            }
            if (this.style.getOwnTopBorder() != null) {
                System.out.print("top:" + JRXmlConstants.getPenMap().get(this.style.getOwnTopBorder()) + " ");
            }
            if (this.style.getOwnRightBorder() != null) {
                System.out.print("right:" + JRXmlConstants.getPenMap().get(this.style.getOwnRightBorder()) + " ");
            }
            if (this.style.getOwnBottomBorder() != null) {
                System.out.print("bottom:" + JRXmlConstants.getPenMap().get(this.style.getOwnBottomBorder()) + " ");
            }
            if (this.style.getOwnLeftBorder() != null) {
                logger.debug((Object)("left:" + JRXmlConstants.getPenMap().get(this.style.getOwnLeftBorder())));
            }
            logger.debug((Object)("border-color:" + this.style.getOwnBorderColor()));
            logger.debug((Object)("border-top-color:" + this.style.getOwnTopBorderColor()));
            logger.debug((Object)("border-right-color:" + this.style.getOwnRightBorderColor()));
            logger.debug((Object)("border-bottom-color:" + this.style.getOwnBottomBorderColor()));
            logger.debug((Object)("border-left-color:" + this.style.getOwnTopBorderColor()));
            logger.debug((Object)("margin: " + this.style.getOwnPadding()));
            logger.debug((Object)("border-top-margin: " + this.style.getOwnTopPadding()));
            logger.debug((Object)("border-right-margin: " + this.style.getOwnRightPadding()));
            logger.debug((Object)("border-bottom-margin: " + this.style.getOwnBottomPadding()));
            logger.debug((Object)("border-left-margin: " + this.style.getOwnLeftPadding()));
            logger.debug((Object)("font-style: " + this.style.isOwnItalic()));
            logger.debug((Object)("font-weight: " + this.style.isOwnBold()));
            logger.debug((Object)("font-size: " + this.style.getOwnFontSize()));
            logger.debug((Object)("line-height: " + JRXmlConstants.getLineSpacingMap().get(this.style.getOwnLineSpacing())));
            logger.debug((Object)("font-family: " + this.style.getOwnPdfFontName()));
            logger.debug((Object)("embed-pdf: " + this.style.isOwnPdfEmbedded()));
            logger.debug((Object)("text-align: " + JRXmlConstants.getHorizontalAlignMap().get(this.style.getOwnHorizontalAlignment())));
            logger.debug((Object)("vertical-align: " + JRXmlConstants.getVerticalAlignMap().get(this.style.getOwnVerticalAlignment())));
            logger.debug((Object)("text-rotation: " + JRXmlConstants.getRotationMap().get(this.style.getOwnRotation())));
            logger.debug((Object)("text-decoration: underline: " + this.style.isOwnUnderline() + " strike: " + this.style.isOwnStrikeThrough()));
            logger.debug((Object)("text-decoration: underline: " + this.style.isOwnUnderline() + " strike: " + this.style.isOwnStrikeThrough()));
            logger.debug((Object)("xhtm-formatted-text: " + this.style.isOwnStyledText()));
            logger.debug((Object)("empty-cells: " + this.style.isOwnBlankWhenNull()));
            logger.debug((Object)("++++" + this.style.getName() + "++++"));
        }
    }

    private Boolean getBoolean(String cssProperty) {
        String lu = this.getIdent(cssProperty);
        if (lu != null) {
            return new Boolean(lu);
        }
        return null;
    }

    private Byte getBorderStyle(LexicalUnit lu) {
        Byte borderStyle = null;
        String value = this.getIdent(lu);
        if (value != null) {
            if (value.equalsIgnoreCase("dashed") || value.equalsIgnoreCase("dotted")) {
                borderStyle = new Byte(4);
            } else if (value.equalsIgnoreCase("solid") || value.equalsIgnoreCase("dounble") || value.equalsIgnoreCase("hidden") || value.equalsIgnoreCase("groove") || value.equalsIgnoreCase("inset") || value.equalsIgnoreCase("outset") || value.equalsIgnoreCase("ridge") || value.equalsIgnoreCase("hidden")) {
                borderStyle = new Byte(1);
            } else if (value.equalsIgnoreCase("none")) {
                borderStyle = new Byte(0);
            }
        }
        return borderStyle;
    }

    private Byte getBorderWidth(LexicalUnit lu) {
        Byte width = null;
        if (lu != null) {
            String value = this.getIdent(lu);
            if (value != null) {
                if (value.equalsIgnoreCase("thin")) {
                    width = new Byte(5);
                } else if (value.equalsIgnoreCase("medium")) {
                    width = new Byte(2);
                } else if (value.equalsIgnoreCase("thick")) {
                    width = new Byte(3);
                }
            } else {
                Float floatValue = this.getPixel(lu);
                if (floatValue.doubleValue() == 1.0) {
                    width = new Byte(1);
                } else if (floatValue.doubleValue() == 2.0) {
                    width = new Byte(2);
                }
                if (floatValue.doubleValue() == 4.0) {
                    width = new Byte(3);
                }
            }
        }
        return width;
    }

    private Color getColor(String cssColorProperty) {
        return this.getColor(cssColorProperty, null);
    }

    private Color getColor(String cssColorProperty, Color defaultColor) {
        Color color = this.getColor(this.getLexicalUnit(cssColorProperty));
        if (color == null) {
            color = defaultColor;
        }
        return color;
    }

    private Color getColor(LexicalUnit lu) {
        Color color = null;
        if (lu != null) {
            switch (lu.getLexicalUnitType()) {
                case 35: 
                case 36: {
                    color = X11Color.getColorByName(lu.getStringValue());
                    break;
                }
                case 27: {
                    int red = -1;
                    int green = -1;
                    int blue = -1;
                    lu = lu.getParameters();
                    if (lu != null) {
                        if (lu.getLexicalUnitType() == 13) {
                            red = lu.getIntegerValue();
                        } else if (lu.getLexicalUnitType() == 23) {
                            red = (int)(lu.getFloatValue() / 100.0f * 255.0f);
                        }
                        lu = this.skipComma(lu.getNextLexicalUnit());
                    }
                    if (lu != null) {
                        if (lu.getLexicalUnitType() == 13) {
                            green = lu.getIntegerValue();
                        } else if (lu.getLexicalUnitType() == 23) {
                            green = (int)(lu.getFloatValue() / 100.0f * 255.0f);
                        }
                        lu = this.skipComma(lu.getNextLexicalUnit());
                    }
                    if (lu != null) {
                        if (lu.getLexicalUnitType() == 13) {
                            blue = lu.getIntegerValue();
                        } else if (lu.getLexicalUnitType() == 23) {
                            blue = (int)(lu.getFloatValue() / 100.0f * 255.0f);
                        }
                    }
                    try {
                        color = new Color(red, green, blue);
                    }
                    catch (IllegalArgumentException e) {
                        logger.debug((Object)("Style property color: " + e.getMessage()));
                    }
                    break;
                }
            }
        }
        return color;
    }

    private Boolean getFontStyle(String fontStyle) {
        Boolean isItalic = null;
        if (fontStyle != null) {
            if (fontStyle.equalsIgnoreCase("oblique") || fontStyle.equalsIgnoreCase("italic")) {
                isItalic = new Boolean(true);
            } else if (fontStyle.equalsIgnoreCase("normal")) {
                isItalic = new Boolean(false);
            }
        }
        return isItalic;
    }

    private Boolean getFontWeight(LexicalUnit lu) {
        Boolean isBold = null;
        if (lu != null) {
            String valueStr = this.getIdent(lu);
            if (valueStr != null) {
                if (valueStr.equalsIgnoreCase("normal") || valueStr.equalsIgnoreCase("lighter")) {
                    isBold = new Boolean(false);
                } else if (valueStr.equalsIgnoreCase("bold") || valueStr.equalsIgnoreCase("bolder")) {
                    isBold = new Boolean(true);
                }
            } else {
                int value;
                Integer intVal = this.getInteger(lu);
                if (intVal != null && (value = intVal.intValue()) >= 100 && value <= 900 && value % 100 == 0) {
                    isBold = new Boolean(true);
                }
            }
        }
        return isBold;
    }

    private String getIdent(String cssProperty) {
        return this.getIdent(this.getLexicalUnit(cssProperty));
    }

    private String getIdent(LexicalUnit lu) {
        if (lu != null && lu.getLexicalUnitType() == 35) {
            return lu.getStringValue();
        }
        return null;
    }

    private Integer getInteger(String cssProperty) {
        LexicalUnit lu = this.getLexicalUnit(cssProperty);
        if (lu != null && lu.getLexicalUnitType() == 13) {
            return new Integer(lu.getIntegerValue());
        }
        return null;
    }

    private Integer getInteger(LexicalUnit lu) {
        if (lu != null && lu.getLexicalUnitType() == 13) {
            return new Integer(lu.getIntegerValue());
        }
        return null;
    }

    private LexicalUnit getLexicalUnit(String cssProperty) {
        return (LexicalUnit)this.propertiesMap.get(cssProperty);
    }

    private Float getPercentage(LexicalUnit lu) {
        if (lu != null && lu.getLexicalUnitType() == 23) {
            return new Float(lu.getFloatValue());
        }
        return null;
    }

    private Float getPixel(LexicalUnit lu) {
        if (lu != null && lu.getLexicalUnitType() == 17) {
            return new Float(lu.getFloatValue());
        }
        return null;
    }

    private Float getPoint(LexicalUnit lu) {
        if (lu != null && lu.getLexicalUnitType() == 21) {
            return new Float(lu.getFloatValue());
        }
        return null;
    }

    private String getString(LexicalUnit lu) {
        if (lu != null && lu.getLexicalUnitType() == 36) {
            return lu.getStringValue();
        }
        return null;
    }

    private boolean isDashedOrNoneBorder(Byte value) {
        return value != null && (value == 4 || value == 0);
    }

    private void setBorder() {
        LexicalUnit lu = this.getLexicalUnit(CSS_border);
        if (lu == null) {
            return;
        }
        if (this.setBorderWidth(lu, true)) {
            lu = lu.getNextLexicalUnit();
        }
        if (this.setBorderStyle(lu, true)) {
            lu = lu.getNextLexicalUnit();
        }
        this.setBorderColor(lu, true);
    }

    private boolean setBorderColor() {
        return this.setBorderColor(null, false);
    }

    private boolean setBorderColor(LexicalUnit lu, boolean isShorthand) {
        if (!isShorthand) {
            lu = this.getLexicalUnit(CSS_border_color);
        }
        ColorBox colorBox = new ColorBox();
        if (lu != null) {
            colorBox.setTop(this.getColor(lu));
            lu = lu.getNextLexicalUnit();
            if (!isShorthand) {
                if (lu != null) {
                    colorBox.setRight(this.getColor(lu));
                    lu = lu.getNextLexicalUnit();
                }
                if (lu != null) {
                    colorBox.setBottom(this.getColor(lu));
                    lu = lu.getNextLexicalUnit();
                }
                if (lu != null) {
                    colorBox.setLeft(this.getColor(lu));
                }
            }
            colorBox.initSides();
        }
        if (!isShorthand) {
            Color color = this.getColor(this.getLexicalUnit(CSS_border_top_color));
            if (color != null) {
                colorBox.setTop(color);
            }
            if ((color = this.getColor(this.getLexicalUnit(CSS_border_right_color))) != null) {
                colorBox.setRight(color);
            }
            if ((color = this.getColor(this.getLexicalUnit(CSS_border_bottom_color))) != null) {
                colorBox.setBottom(color);
            }
            if ((color = this.getColor(this.getLexicalUnit(CSS_border_left_color))) != null) {
                colorBox.setLeft(color);
            }
        }
        if (colorBox.isOneSet()) {
            if (colorBox.getTop() != null) {
                this.borderColorBox.setTop(colorBox.getTop());
            }
            if (colorBox.getRight() != null) {
                this.borderColorBox.setRight(colorBox.getRight());
            }
            if (colorBox.getBottom() != null) {
                this.borderColorBox.setBottom(colorBox.getBottom());
            }
            if (colorBox.getLeft() != null) {
                this.borderColorBox.setLeft(colorBox.getLeft());
            }
            if (this.borderColorBox.isSameSides()) {
                this.style.setBorderColor(this.borderColorBox.getTop());
            } else {
                this.style.setBorderColor(null);
                if (this.borderColorBox.getTop() != null) {
                    this.style.setTopBorderColor(this.borderColorBox.getTop());
                }
                if (this.borderColorBox.getRight() != null) {
                    this.style.setRightBorderColor(this.borderColorBox.getRight());
                }
                if (this.borderColorBox.getBottom() != null) {
                    this.style.setBottomBorderColor(this.borderColorBox.getBottom());
                }
                if (this.borderColorBox.getLeft() != null) {
                    this.style.setLeftBorderColor(this.borderColorBox.getLeft());
                }
            }
            if (this.borderColorBox.getTop() != null) {
                this.style.setForecolor(this.borderColorBox.getTop());
            }
            return true;
        }
        return false;
    }

    private void setBorderStyle() {
        this.setBorderStyle(null, false);
    }

    private boolean setBorderStyle(LexicalUnit lu, boolean isShorthand) {
        ByteBox styleBox = new ByteBox();
        if (!isShorthand) {
            lu = this.getLexicalUnit(CSS_border_style);
        }
        if (lu != null) {
            styleBox.setTop(this.getBorderStyle(lu));
            if (!isShorthand) {
                if ((lu = lu.getNextLexicalUnit()) != null) {
                    styleBox.setRight(this.getBorderStyle(lu));
                    lu = lu.getNextLexicalUnit();
                }
                if (lu != null) {
                    styleBox.setBottom(this.getBorderStyle(lu));
                    lu = lu.getNextLexicalUnit();
                }
                if (lu != null) {
                    styleBox.setLeft(this.getBorderStyle(lu));
                }
            }
            styleBox.initSides();
        }
        if (!isShorthand) {
            Byte borderStyle = this.getBorderStyle(this.getLexicalUnit(CSS_border_top_style));
            if (borderStyle != null) {
                styleBox.setTop(borderStyle);
            }
            if ((borderStyle = this.getBorderStyle(this.getLexicalUnit(CSS_border_right_style))) != null) {
                styleBox.setRight(borderStyle);
            }
            if ((borderStyle = this.getBorderStyle(this.getLexicalUnit(CSS_border_bottom_style))) != null) {
                styleBox.setBottom(borderStyle);
            }
            if ((borderStyle = this.getBorderStyle(this.getLexicalUnit(CSS_border_left_style))) != null) {
                styleBox.setLeft(borderStyle);
            }
        }
        if (styleBox.isOneSet()) {
            if (styleBox.getTop() != null) {
                this.borderBox.setTop(styleBox.getTop());
            }
            if (styleBox.getRight() != null) {
                this.borderBox.setRight(styleBox.getRight());
            }
            if (styleBox.getBottom() != null) {
                this.borderBox.setBottom(styleBox.getBottom());
            }
            if (styleBox.getLeft() != null) {
                this.borderBox.setLeft(styleBox.getLeft());
            }
            this.setBorderStyleFromBorderBox();
            return true;
        }
        return false;
    }

    private void setBorderStyleFromBorderBox() {
        if (this.borderBox.isSameSides()) {
            this.style.setBorder(this.borderBox.getTop());
            this.style.setTopBorder(null);
            this.style.setRightBorder(null);
            this.style.setBottomBorder(null);
            this.style.setLeftBorder(null);
        } else {
            this.style.setBorder(null);
            if (this.borderBox.getTop() != null) {
                this.style.setTopBorder(this.borderBox.getTop());
            }
            if (this.borderBox.getRight() != null) {
                this.style.setRightBorder(this.borderBox.getRight());
            }
            if (this.borderBox.getBottom() != null) {
                this.style.setBottomBorder(this.borderBox.getBottom());
            }
            if (this.borderBox.getLeft() != null) {
                this.style.setLeftBorder(this.borderBox.getLeft());
            }
        }
        if (this.borderBox.getTop() != null) {
            this.style.setPen(this.borderBox.getTop());
        }
    }

    private boolean setBorderWidth() {
        return this.setBorderWidth(null, false);
    }

    private boolean setBorderWidth(LexicalUnit lu, boolean isShorthand) {
        ByteBox widthBox = new ByteBox();
        if (!isShorthand) {
            lu = this.getLexicalUnit(CSS_border_width);
        }
        if (lu != null) {
            widthBox.setTop(this.getBorderWidth(lu));
            lu = lu.getNextLexicalUnit();
            if (!isShorthand) {
                if (lu != null) {
                    widthBox.setRight(this.getBorderWidth(lu));
                    lu = lu.getNextLexicalUnit();
                }
                if (lu != null) {
                    widthBox.setBottom(this.getBorderWidth(lu));
                    lu = lu.getNextLexicalUnit();
                }
                if (lu != null) {
                    widthBox.setLeft(this.getBorderWidth(lu));
                }
            }
            widthBox.initSides();
        }
        if (!isShorthand) {
            Byte borderWidth = this.getBorderWidth(this.getLexicalUnit(CSS_border_top_width));
            if (borderWidth != null) {
                widthBox.setTop(borderWidth);
            }
            if ((borderWidth = this.getBorderWidth(this.getLexicalUnit(CSS_border_right_width))) != null) {
                widthBox.setRight(borderWidth);
            }
            if ((borderWidth = this.getBorderWidth(this.getLexicalUnit(CSS_border_bottom_width))) != null) {
                widthBox.setBottom(borderWidth);
            }
            if ((borderWidth = this.getBorderWidth(this.getLexicalUnit(CSS_border_left_width))) != null) {
                widthBox.setLeft(borderWidth);
            }
        }
        if (widthBox.isOneSet()) {
            if (widthBox.getTop() != null && !this.isDashedOrNoneBorder(this.borderBox.getTop())) {
                this.borderBox.setTop(widthBox.getTop());
            }
            if (widthBox.getRight() != null && !this.isDashedOrNoneBorder(this.borderBox.getRight())) {
                this.borderBox.setRight(widthBox.getRight());
            }
            if (widthBox.getBottom() != null && !this.isDashedOrNoneBorder(this.borderBox.getBottom())) {
                this.borderBox.setBottom(widthBox.getBottom());
            }
            if (widthBox.getLeft() != null && !this.isDashedOrNoneBorder(this.borderBox.getLeft())) {
                this.borderBox.setLeft(widthBox.getLeft());
            }
            this.setBorderStyleFromBorderBox();
            return true;
        }
        return false;
    }

    private boolean setLineHeight() {
        LexicalUnit lu = this.getLexicalUnit(CSS_line_height);
        return this.setLineHeight(lu);
    }

    private boolean setLineHeight(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        String value = this.getIdent(lu);
        double result = -1.0;
        if (value != null) {
            if (value.equalsIgnoreCase("normal")) {
                result = 1.0;
            }
        } else {
            Integer line_height = this.getInteger(lu);
            if (line_height != null) {
                Integer fontSize = this.style.getFontSize();
                if (fontSize == null) {
                    fontSize = new Integer(10);
                }
                result = fontSize.doubleValue() / line_height.doubleValue();
            } else {
                Float length = this.getPixel(lu);
                if (length != null) {
                    result = length.doubleValue() * 0.75;
                } else {
                    length = this.getPoint(lu);
                    if (length != null) {
                        result = length.doubleValue();
                    } else {
                        length = this.getPercentage(lu);
                        if (length != null) {
                            result = length.doubleValue() / 100.0;
                        }
                    }
                }
            }
        }
        if (result >= 0.0) {
            byte spacing = result <= 1.25 ? (byte)0 : (result <= 1.75 ? (byte)1 : 2);
            this.style.setLineSpacing(spacing);
            return true;
        }
        return false;
    }

    private void setLineSize() {
        LexicalUnit lu = this.getLexicalUnit(CSS_line_size);
        if (lu != null) {
            Byte pen = null;
            String value = this.getIdent(lu);
            if (value != null) {
                if (value.equalsIgnoreCase("none")) {
                    pen = new Byte(0);
                } else if (value.equalsIgnoreCase("thin")) {
                    pen = new Byte(5);
                } else if (value.equalsIgnoreCase("dashed") || value.equalsIgnoreCase("dotted")) {
                    pen = new Byte(4);
                }
            } else {
                Float floatValue = this.getPixel(lu);
                if (floatValue.doubleValue() == 1.0) {
                    pen = new Byte(1);
                } else if (floatValue.doubleValue() == 2.0) {
                    pen = new Byte(2);
                }
                if (floatValue.doubleValue() == 4.0) {
                    pen = new Byte(3);
                }
            }
            if (pen != null) {
                this.style.setPen(pen);
            }
        }
    }

    private void setMargin() {
        IntegerBox box = new IntegerBox();
        LexicalUnit lu = this.getLexicalUnit(CSS_margin);
        if (lu != null) {
            box.setTop(this.getInteger(lu));
            lu = lu.getNextLexicalUnit();
        }
        if (lu != null) {
            box.setRight(this.getInteger(lu));
            lu = lu.getNextLexicalUnit();
        }
        if (lu != null) {
            box.setBottom(this.getInteger(lu));
            lu = lu.getNextLexicalUnit();
        }
        if (lu != null) {
            box.setLeft(this.getInteger(lu));
        }
        box.initSides();
        Integer side = this.getInteger(CSS_margin_top);
        if (side != null) {
            box.setTop(side);
        }
        if ((side = this.getInteger(CSS_margin_right)) != null) {
            box.setRight(side);
        }
        if ((side = this.getInteger(CSS_margin_bottom)) != null) {
            box.setBottom(side);
        }
        if ((side = this.getInteger(CSS_margin_left)) != null) {
            box.setLeft(side);
        }
        if (box.isSameSides()) {
            this.style.setPadding(box.getTop());
        } else {
            this.style.setPadding(null);
            if (box.getTop() != null) {
                this.style.setTopPadding(box.getTop());
            }
            if (box.getRight() != null) {
                this.style.setRightPadding(box.getRight());
            }
            if (box.getBottom() != null) {
                this.style.setBottomPadding(box.getBottom());
            }
            if (box.getLeft() != null) {
                this.style.setLeftPadding(box.getLeft());
            }
        }
    }

    private void setClip() {
        String value = this.getIdent(CSS_clip);
        if (value != null) {
            Byte scaleImage = null;
            if (value.equalsIgnoreCase("auto")) {
                scaleImage = new Byte(1);
            } else if (value.equalsIgnoreCase("stretch")) {
                scaleImage = new Byte(2);
            } else if (value.equalsIgnoreCase("ratio")) {
                scaleImage = new Byte(3);
            }
            if (scaleImage != null) {
                this.style.setScaleImage(scaleImage);
            }
        }
    }

    private void setEmptyCells() {
        String lu = this.getIdent(CSS_empty_cells);
        if (lu != null) {
            if (lu.equalsIgnoreCase("show")) {
                this.style.setBlankWhenNull(false);
            } else if (lu.equalsIgnoreCase("hide")) {
                this.style.setBlankWhenNull(true);
            }
        }
    }

    private void setFont() {
        LexicalUnit lu = this.getLexicalUnit(CSS_font);
        if (lu == null) {
            return;
        }
        if (this.setFontStyle(lu)) {
            lu = lu.getNextLexicalUnit();
        }
        if (this.setFontWeight(lu)) {
            lu = lu.getNextLexicalUnit();
        }
        if (this.setFontSize(lu)) {
            lu = lu.getNextLexicalUnit();
        }
        if (lu != null && lu.getLexicalUnitType() == 4) {
            if (this.setLineHeight(lu = lu.getNextLexicalUnit())) {
                lu = lu.getNextLexicalUnit();
            } else {
                return;
            }
        }
        this.setFontFamily(lu);
    }

    private void setFontFamily() {
        LexicalUnit lu = this.getLexicalUnit(CSS_font_family);
        this.setFontFamily(lu);
    }

    private void setFontFamily(LexicalUnit lu) {
        if (lu != null) {
            while (lu != null && (lu.getLexicalUnitType() == 36 || lu.getLexicalUnitType() == 35)) {
                String font = lu.getStringValue();
                if (FontFactory.isRegistered((String)font)) {
                    this.style.setPdfFontName(font);
                    return;
                }
                lu = this.skipComma(lu);
            }
        }
        if (this.style.getOwnPdfFontName() != null) {
            return;
        }
    }

    private void setFontSize() {
        this.setFontSize(this.getLexicalUnit(CSS_font_size));
    }

    private boolean setFontSize(LexicalUnit lu) {
        Double fontSize = null;
        Float size = this.getPixel(lu);
        if (size != null) {
            fontSize = new Double(size.doubleValue() * 0.75);
        } else {
            size = this.getPoint(lu);
            if (size != null) {
                fontSize = new Double(size.doubleValue());
            }
        }
        if (fontSize != null && fontSize.intValue() > 0) {
            this.style.setFontSize(fontSize.intValue());
        }
        return fontSize != null;
    }

    private void setFontStyle() {
        this.setFontStyle(this.getLexicalUnit(CSS_font_style));
    }

    private boolean setFontStyle(LexicalUnit lu) {
        Boolean isItalic = this.getFontStyle(this.getIdent(lu));
        if (isItalic != null) {
            this.style.setItalic(isItalic);
        }
        return isItalic != null;
    }

    private void setFontWeight() {
        this.setFontWeight(this.getLexicalUnit(CSS_font_weight));
    }

    private boolean setFontWeight(LexicalUnit lu) {
        Boolean isBold = this.getFontWeight(lu);
        if (isBold != null) {
            this.style.setBold(isBold);
        }
        return isBold != null;
    }

    private void setParentStyle() {
        JRDesignStyle parentStyle;
        LexicalUnit lu = this.getLexicalUnit(CSS_style);
        String parentStyleName = this.getIdent(lu);
        if (parentStyleName == null) {
            parentStyleName = this.getString(lu);
        }
        if (parentStyleName != null && (parentStyle = (JRDesignStyle)this.jasperDesign.getStylesMap().get(parentStyleName)) != null) {
            this.style.setParentStyle(parentStyle);
        }
    }

    private void setTextAlign() {
        String value = this.getIdent(CSS_text_align);
        if (value != null) {
            Byte align = null;
            if (value.equalsIgnoreCase("left")) {
                align = new Byte(1);
            } else if (value.equalsIgnoreCase("center")) {
                align = new Byte(2);
            } else if (value.equalsIgnoreCase("right")) {
                align = new Byte(3);
            } else if (value.equalsIgnoreCase("justify")) {
                align = new Byte(4);
            }
            if (align != null) {
                this.style.setHorizontalAlignment(align);
            }
        }
    }

    private void setTextDecoration() {
        for (LexicalUnit lu = this.getLexicalUnit(CSS_text_decoration); lu != null; lu = lu.getNextLexicalUnit()) {
            String value = this.getIdent(lu);
            if (value == null) {
                return;
            }
            if (value.equalsIgnoreCase("none")) {
                this.style.setUnderline(false);
                this.style.setStrikeThrough(false);
                continue;
            }
            if (value.equalsIgnoreCase("underline")) {
                this.style.setUnderline(true);
                continue;
            }
            if (!value.equalsIgnoreCase("line-through")) continue;
            this.style.setStrikeThrough(true);
        }
    }

    private void setTextRotation() {
        String value = this.getIdent(CSS_text_rotation);
        if (value != null) {
            Byte rotation = null;
            if (value.equalsIgnoreCase("none")) {
                rotation = new Byte(0);
            } else if (value.equalsIgnoreCase("left")) {
                rotation = new Byte(1);
            } else if (value.equalsIgnoreCase("right")) {
                rotation = new Byte(2);
            }
            if (rotation != null) {
                this.style.setRotation(rotation);
            }
        }
    }

    private void setTransparencyMode() {
        String value = this.getIdent(CCS_transparency_mode);
        if (value != null) {
            Byte mode = null;
            if (value.equalsIgnoreCase("opaque")) {
                mode = new Byte(1);
            } else if (value.equalsIgnoreCase("transparent")) {
                mode = new Byte(2);
            }
            if (mode != null) {
                this.style.setMode(mode);
            }
        }
    }

    private void setVerticalAlign() {
        String value = this.getIdent(CSS_vertical_align);
        if (value != null) {
            Byte align = null;
            if (value.equalsIgnoreCase("top")) {
                align = new Byte(1);
            } else if (value.equalsIgnoreCase("middle")) {
                align = new Byte(2);
            } else if (value.equalsIgnoreCase("bottom")) {
                align = new Byte(3);
            }
            if (align != null) {
                this.style.setVerticalAlignment(align);
            }
        }
    }

    private LexicalUnit skipComma(LexicalUnit lu) {
        if (lu != null && lu.getLexicalUnitType() == 0) {
            return lu.getNextLexicalUnit();
        }
        return null;
    }

    class ByteBox
    extends Box {
        ByteBox() {
        }

        Byte getTop() {
            return (Byte)this.top;
        }

        Byte getRight() {
            return (Byte)this.right;
        }

        Byte getLeft() {
            return (Byte)this.left;
        }

        Byte getBottom() {
            return (Byte)this.bottom;
        }
    }

    class ColorBox
    extends Box {
        ColorBox() {
        }

        Color getTop() {
            return (Color)this.top;
        }

        Color getRight() {
            return (Color)this.right;
        }

        Color getLeft() {
            return (Color)this.left;
        }

        Color getBottom() {
            return (Color)this.bottom;
        }
    }

    class IntegerBox
    extends Box {
        IntegerBox() {
        }

        Integer getTop() {
            return (Integer)this.top;
        }

        Integer getRight() {
            return (Integer)this.right;
        }

        Integer getLeft() {
            return (Integer)this.left;
        }

        Integer getBottom() {
            return (Integer)this.bottom;
        }
    }

    class Box {
        Object top;
        Object right;
        Object bottom;
        Object left;

        Box() {
        }

        void setTop(Object o) {
            this.top = o;
        }

        void setRight(Object o) {
            this.right = o;
        }

        void setLeft(Object o) {
            this.left = o;
        }

        void setBottom(Object o) {
            this.bottom = o;
        }

        boolean isOneSet() {
            return this.top != null || this.right != null || this.bottom != null || this.left != null;
        }

        boolean isAllSet() {
            return this.top != null && this.right != null && this.bottom != null && this.left != null;
        }

        boolean isSameSides() {
            return this.isAllSet() && this.top.equals(this.bottom) && this.right.equals(this.left) && this.top.equals(this.right);
        }

        void initSides() {
            if (this.top != null) {
                if (this.right != null) {
                    if (this.bottom != null) {
                        if (this.left == null) {
                            this.setLeft(this.right);
                        }
                    } else {
                        this.setBottom(this.top);
                        this.setLeft(this.right);
                    }
                } else {
                    this.setRight(this.top);
                    this.setBottom(this.top);
                    this.setLeft(this.top);
                }
            }
        }
    }
}

