/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml.idp;

import coldfusion.saml.IdpConfiguration;
import coldfusion.saml.idp.FileMetadataProvider;
import coldfusion.saml.idp.HttpMetadataProvider;
import coldfusion.saml.idp.MetadataProvider;
import coldfusion.saml.idp.RawMetadataProvider;
import coldfusion.saml.util.Utils;
import com.onelogin.saml2.settings.Saml2Settings;
import java.util.HashMap;
import java.util.Map;

public class MetadataCache {
    private static Map<String, MetadataProvider> cache = new HashMap<String, MetadataProvider>();

    public static Saml2Settings fetch(IdpConfiguration idpConfiguration) {
        String key = MetadataCache.getKey(idpConfiguration);
        MetadataProvider provider = cache.get(key);
        if (provider == null) {
            provider = MetadataCache.createMetadataProvider(idpConfiguration);
            cache.put(key, provider);
        }
        return provider.provide();
    }

    private static MetadataProvider createMetadataProvider(IdpConfiguration idpConfiguration) {
        if (!Utils.isEmpty(idpConfiguration.getMetadataUrl())) {
            return new HttpMetadataProvider(idpConfiguration);
        }
        if (!Utils.isEmpty(idpConfiguration.getMetadataFilePath())) {
            return new FileMetadataProvider(idpConfiguration);
        }
        return new RawMetadataProvider(idpConfiguration);
    }

    private static String getKey(IdpConfiguration idpConfiguration) {
        if (!Utils.isEmpty(idpConfiguration.getMetadataUrl())) {
            return idpConfiguration.getMetadataUrl();
        }
        if (!Utils.isEmpty(idpConfiguration.getMetadataFilePath())) {
            return idpConfiguration.getMetadataFilePath();
        }
        return idpConfiguration.getMetadataRaw();
    }
}

