/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3.credentials;

import coldfusion.log.Logger;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.vfs.s3.credentials.AWSCredentialsProvider;
import coldfusion.vfs.s3.credentials.AWSCredentialsWithRegion;
import coldfusion.vfs.s3.credentials.AWSSystemSettings;
import java.io.File;
import java.util.Scanner;
import org.jets3t.service.security.AWSCredentials;

public final class DefaultProfileCredentialsProvider
implements AWSCredentialsProvider {
    private final Logger logger = ServiceFactory.getLoggingService().getLogger("awsS3Legacy");
    private static final String WINDOWS_CREDENTIAL_FILE = "\\.aws\\credentials";
    private static final String WINDOWS_CONFIG_FILE = "\\.aws\\config";
    private static final String LINUX_MAC_CREDENTIAL_FILE = "/.aws/credentials";
    private static final String LINUX_MAC_CONFIG_FILE = "/.aws/config";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSCredentials loadCredentials() {
        String credFilePath = null;
        String configFilePath = null;
        String region = null;
        if (SystemInfo.isWindows()) {
            credFilePath = System.getenv("USERPROFILE") + WINDOWS_CREDENTIAL_FILE;
            configFilePath = System.getenv("USERPROFILE") + WINDOWS_CONFIG_FILE;
        } else if (SystemInfo.isLinux() || SystemInfo.isMac()) {
            credFilePath = System.getProperty("user.home") + LINUX_MAC_CREDENTIAL_FILE;
            configFilePath = System.getProperty("user.home") + LINUX_MAC_CONFIG_FILE;
        }
        String accessKeyId = null;
        String secretKey = null;
        File credFile = new File(credFilePath);
        try (Scanner sc = null;){
            AWSCredentialsWithRegion aWSCredentialsWithRegion;
            sc = new Scanner(credFile);
            while (sc.hasNextLine()) {
                String current = sc.nextLine();
                if (current.trim().compareTo("[" + AWSSystemSettings.DEFAULT_PROFILE.getValue() + "]") != 0) continue;
                accessKeyId = sc.nextLine().replace("aws_access_key_id=", "");
                secretKey = sc.nextLine().replace("aws_secret_access_key=", "");
                break;
            }
            sc.close();
            File configFile = new File(configFilePath);
            sc = new Scanner(configFile);
            while (sc.hasNextLine()) {
                String current = sc.nextLine();
                if (current.trim().compareTo("[" + AWSSystemSettings.DEFAULT_PROFILE.getValue() + "]") != 0) continue;
                region = sc.nextLine().replace("region", "").replace("=", "").trim();
                break;
            }
            this.logger.info((Object)"AWS Credentials found in the shared credentials and config files");
            if (region != null) {
                aWSCredentialsWithRegion = new AWSCredentialsWithRegion(accessKeyId, secretKey, region);
                return aWSCredentialsWithRegion;
            }
            aWSCredentialsWithRegion = new AWSCredentials(accessKeyId, secretKey);
            return aWSCredentialsWithRegion;
        }
        return null;
    }
}

