/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3.credentials;

import coldfusion.runtime.JSONUtils;
import coldfusion.vfs.s3.credentials.AWSSystemSettings;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.jets3t.service.security.AWSSessionCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;

public class AWSS3EC2IAMSessionCredentials
extends AWSSessionCredentials {
    protected static String baseCredentialsUrl = "http://169.254.169.254/latest/meta-data/iam/security-credentials";
    protected String roleName = null;
    protected Date expiration = null;
    protected boolean automaticRefreshEnabled = true;
    protected long automaticRefreshRetryDelaySeconds = 10L;
    private volatile long automaticRefreshLastRetryMS = 0L;

    public AWSS3EC2IAMSessionCredentials(String awsAccessKey, String awsSecretAccessKey, String sessionToken, String roleName, Date expiration, boolean automaticRefreshEnabled) {
        super(awsAccessKey, awsSecretAccessKey, sessionToken, null);
        this.roleName = roleName;
        this.expiration = expiration;
        this.automaticRefreshEnabled = automaticRefreshEnabled;
    }

    protected String getTypeName() {
        return "ec2-iam-session";
    }

    public boolean isAutomaticRefreshEnabled() {
        return this.automaticRefreshEnabled;
    }

    public String getSessionToken() {
        this.refreshFromEC2InstanceDataIfNearExpiration();
        return this.sessionToken;
    }

    public String getAccessKey() {
        this.refreshFromEC2InstanceDataIfNearExpiration();
        return this.accessKey;
    }

    public String getSecretKey() {
        this.refreshFromEC2InstanceDataIfNearExpiration();
        return this.secretKey;
    }

    public String getRoleName() {
        this.refreshFromEC2InstanceDataIfNearExpiration();
        return this.roleName;
    }

    public Date getExpiration() {
        this.refreshFromEC2InstanceDataIfNearExpiration();
        return this.expiration;
    }

    public boolean isNearExpiration() {
        long diffOf15MinsInMS;
        Date now = new Date();
        long difference = this.expiration.getTime() - now.getTime();
        return difference <= (diffOf15MinsInMS = 900000L);
    }

    public void refreshFromEC2InstanceData() {
        AWSS3EC2IAMSessionCredentials loadedCredentials = AWSS3EC2IAMSessionCredentials.loadFromEC2InstanceData(this.roleName, this.automaticRefreshEnabled);
        this.accessKey = loadedCredentials.getAccessKey();
        this.secretKey = loadedCredentials.getSecretKey();
        this.sessionToken = loadedCredentials.getSessionToken();
        this.expiration = loadedCredentials.getExpiration();
    }

    public synchronized void refreshFromEC2InstanceDataIfNearExpiration() {
        if (this.automaticRefreshEnabled && this.isNearExpiration()) {
            long msSinceLastRetry = System.currentTimeMillis() - this.automaticRefreshLastRetryMS;
            if (msSinceLastRetry / 1000L < this.automaticRefreshRetryDelaySeconds) {
                return;
            }
            try {
                this.automaticRefreshLastRetryMS = System.currentTimeMillis();
                this.refreshFromEC2InstanceData();
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to automatically refresh IAM role credentials from EC2 instance data", (Throwable)ex);
            }
        }
    }

    public static AWSS3EC2IAMSessionCredentials loadFromEC2InstanceData(String urlPrefix, String roleName, boolean automaticRefreshEnabled) {
        try {
            Object url = urlPrefix;
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            url = (String)url + roleName;
            String iamRoleData = RestUtils.httpGetUrlAsString((String)url);
            return AWSS3EC2IAMSessionCredentials.parseEC2InstanceData(iamRoleData, roleName, automaticRefreshEnabled);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static AWSS3EC2IAMSessionCredentials loadFromEC2InstanceData(String roleName, boolean automaticRefreshEnabled) {
        return AWSS3EC2IAMSessionCredentials.loadFromEC2InstanceData(baseCredentialsUrl, roleName, automaticRefreshEnabled);
    }

    public static AWSS3EC2IAMSessionCredentials loadFromEC2InstanceData(boolean automaticRefreshEnabled) {
        String roleName;
        try {
            roleName = RestUtils.httpGetUrlAsString((String)(baseCredentialsUrl + "/")).trim();
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not fetch IAM role name from EC2 meta data!", ex);
        }
        if (roleName == null || roleName.length() == 0) {
            throw new RuntimeException("Empty IAM role name in EC2 meta data!");
        }
        return AWSS3EC2IAMSessionCredentials.loadFromEC2InstanceData(baseCredentialsUrl, roleName, automaticRefreshEnabled);
    }

    public static AWSS3EC2IAMSessionCredentials parseEC2InstanceData(String iamRoleData, String roleName, boolean automaticRefreshEnabled) throws IOException, ParseException {
        Map iamCredentials = (Map)JSONUtils.deserializeJSON((Object)iamRoleData);
        String resultCode = (String)iamCredentials.get("Code");
        if (!resultCode.equals("Success")) {
            throw new RuntimeException("Status 'Code' != 'Success'");
        }
        String accessKey = (String)iamCredentials.get(AWSSystemSettings.ACCESS_KEY_ID.getValue());
        String secretKey = (String)iamCredentials.get(AWSSystemSettings.SECRET_ACCESS_KEY.getValue());
        String sessionToken = (String)iamCredentials.get(AWSSystemSettings.TOKEN.getValue());
        Date expiration = ServiceUtils.parseIso8601Date((String)((String)iamCredentials.get(AWSSystemSettings.EXPIRATION.getValue())));
        return new AWSS3EC2IAMSessionCredentials(accessKey, secretKey, sessionToken, roleName, expiration, automaticRefreshEnabled);
    }
}

