/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3.credentials;

import coldfusion.log.Logger;
import coldfusion.server.ServiceFactory;
import coldfusion.vfs.s3.credentials.AWSCredentialsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jets3t.service.security.AWSCredentials;

public final class AWSCredentialsProviderChain
implements AWSCredentialsProvider {
    private final Logger logger = ServiceFactory.getLoggingService().getLogger("awsS3Legacy");
    private final List<AWSCredentialsProvider> credentialsProviders;

    private AWSCredentialsProviderChain(BuilderImpl builder) {
        this.credentialsProviders = Collections.unmodifiableList(builder.credentialsProviders);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static AWSCredentialsProviderChain of(AWSCredentialsProvider ... awsCredentialsProviders) {
        return AWSCredentialsProviderChain.builder().credentialsProviders(awsCredentialsProviders).build();
    }

    @Override
    public AWSCredentials loadCredentials() {
        for (AWSCredentialsProvider provider : this.credentialsProviders) {
            try {
                AWSCredentials credentials = provider.loadCredentials();
                if (credentials == null) continue;
                return credentials;
            }
            catch (RuntimeException e) {
                this.logger.info((Object)e.getMessage());
            }
        }
        this.logger.info((Object)"Unable to load credentials from any of the credential providers in the chain.");
        return null;
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AWSCredentialsProvider> credentialsProviders = new ArrayList<AWSCredentialsProvider>();

        private BuilderImpl() {
        }

        @Override
        public Builder credentialsProviders(Collection<? extends AWSCredentialsProvider> credentialsProviders) {
            this.credentialsProviders = new ArrayList<AWSCredentialsProvider>(credentialsProviders);
            return this;
        }

        @Override
        public Builder credentialsProviders(AWSCredentialsProvider ... credentialsProviders) {
            return this.credentialsProviders(Arrays.asList(credentialsProviders));
        }

        @Override
        public Builder addCredentialsProvider(AWSCredentialsProvider credentialsProviders) {
            this.credentialsProviders.add(credentialsProviders);
            return this;
        }

        @Override
        public AWSCredentialsProviderChain build() {
            return new AWSCredentialsProviderChain(this);
        }
    }

    public static interface Builder {
        public Builder credentialsProviders(Collection<? extends AWSCredentialsProvider> var1);

        public Builder credentialsProviders(AWSCredentialsProvider ... var1);

        public Builder addCredentialsProvider(AWSCredentialsProvider var1);

        public AWSCredentialsProviderChain build();
    }
}

