/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3;

import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.UnrecoverableIOException;

public class RepeatableVFileInputStream
extends InputStream
implements InputStreamWrapper {
    private static final Log log = LogFactory.getLog(RepeatableVFileInputStream.class);
    protected File file = null;
    protected InputStream fis = null;
    protected long bytesReadPastMarkPoint = 0L;
    protected long markPoint = 0L;

    public RepeatableVFileInputStream(VFile vfile) throws FileNotFoundException {
        if (vfile == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.fis = VFSFileFactory.getInputStream((File)vfile);
        this.file = vfile;
    }

    @Override
    public long skip(long toSkip) throws IOException {
        long skipped = this.fis.skip(toSkip);
        this.bytesReadPastMarkPoint += skipped;
        return skipped;
    }

    @Override
    public void reset() throws IOException {
        try {
            this.fis.close();
            this.fis = VFSFileFactory.getInputStream((File)this.file);
            long skipped = 0L;
            for (long toSkip = this.markPoint; toSkip > 0L; toSkip -= skipped) {
                skipped = this.skip(toSkip);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reset to mark point " + this.markPoint + " after returning " + this.bytesReadPastMarkPoint + " bytes"));
            }
            this.bytesReadPastMarkPoint = 0L;
        }
        catch (IOException e) {
            throw new UnrecoverableIOException("Input stream is not repeatable: " + e.getMessage());
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.markPoint += this.bytesReadPastMarkPoint;
        this.bytesReadPastMarkPoint = 0L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input stream marked at " + this.markPoint + " bytes"));
        }
    }

    @Override
    public int available() throws IOException {
        return this.fis.available();
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
    }

    @Override
    public int read() throws IOException {
        int byteRead = this.fis.read();
        if (byteRead != -1) {
            ++this.bytesReadPastMarkPoint;
            return byteRead;
        }
        return -1;
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int count = this.fis.read(arg0, arg1, arg2);
        this.bytesReadPastMarkPoint += (long)count;
        return count;
    }

    public InputStream getWrappedInputStream() {
        return this.fis;
    }
}

