/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.smscsim;

import org.smpp.debug.FileLog;
import org.smpp.smscsim.DeliveryInfoSender;
import org.smpp.smscsim.MessageSender;
import org.smpp.smscsim.PDUProcessor;
import org.smpp.smscsim.PDUProcessorFactory;
import org.smpp.smscsim.PDUProcessorGroup;
import org.smpp.smscsim.SMSCSession;
import org.smpp.smscsim.ShortMessageStore;
import org.smpp.smscsim.SimulatorPDUProcessor;
import org.smpp.smscsim.util.Table;

public class SimulatorPDUProcessorFactory
implements PDUProcessorFactory {
    private PDUProcessorGroup procGroup;
    private ShortMessageStore messageStore;
    private DeliveryInfoSender deliveryInfoSender;
    private MessageSender messageSender;
    private Table users;
    private boolean displayInfo = false;

    public SimulatorPDUProcessorFactory(PDUProcessorGroup procGroup, ShortMessageStore messageStore, DeliveryInfoSender deliveryInfoSender, Table users, MessageSender messageSender) {
        this.procGroup = procGroup;
        this.messageStore = messageStore;
        this.deliveryInfoSender = deliveryInfoSender;
        this.users = users;
        this.messageSender = messageSender;
    }

    public PDUProcessor createPDUProcessor(SMSCSession session) {
        SimulatorPDUProcessor simPDUProcessor = new SimulatorPDUProcessor(session, this.messageStore, this.users);
        simPDUProcessor.setDisplayInfo(this.getDisplayInfo());
        simPDUProcessor.setGroup(this.procGroup);
        simPDUProcessor.setDeliveryInfoSender(this.deliveryInfoSender);
        simPDUProcessor.setMessageSender(this.messageSender);
        this.display("new connection accepted");
        return simPDUProcessor;
    }

    public void setDisplayInfo(boolean on) {
        this.displayInfo = on;
    }

    public boolean getDisplayInfo() {
        return this.displayInfo;
    }

    private void display(String info) {
        if (this.getDisplayInfo()) {
            System.out.println(FileLog.getLineTimeStamp() + " [sys] " + info);
        }
    }
}

