/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu.tlv;

import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.tlv.TLV;
import org.smpp.pdu.tlv.TLVException;
import org.smpp.pdu.tlv.WrongLengthException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class TLVString
extends TLV {
    private String value;

    public TLVString() {
    }

    public TLVString(short tag) {
        super(tag);
    }

    public TLVString(short tag, int min, int max) {
        super(tag, min, max);
    }

    public TLVString(short tag, String value) throws TLVException {
        super(tag);
        this.setValue(value);
    }

    public TLVString(short tag, int min, int max, String value) throws TLVException {
        super(tag, min, max);
        this.setValue(value);
    }

    public void setValueData(ByteBuffer buffer) throws TLVException {
        this.checkLength(buffer);
        if (buffer != null) {
            try {
                this.value = buffer.removeCString();
            }
            catch (NotEnoughDataInByteBufferException e) {
                throw new TLVException("Not enough data for string in the buffer.");
            }
            catch (TerminatingZeroNotFoundException e) {
                throw new TLVException("String terminating zero not found in the buffer.");
            }
        } else {
            this.value = new String("");
        }
        this.markValueSet();
    }

    public ByteBuffer getValueData() throws ValueNotSetException {
        ByteBuffer valueBuf = new ByteBuffer();
        valueBuf.appendCString(this.getValue());
        return valueBuf;
    }

    public void setValue(String value) throws WrongLengthException {
        this.checkLength(value.length() + 1);
        this.value = value;
        this.markValueSet();
    }

    public String getValue() throws ValueNotSetException {
        if (this.hasValue()) {
            return this.value;
        }
        throw new ValueNotSetException();
    }

    public String debugString() {
        String dbgs = "(str: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.value;
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

