/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu.tlv;

import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.tlv.TLV;
import org.smpp.pdu.tlv.TLVException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;

public class TLVOctets
extends TLV {
    private ByteBuffer value = null;

    public TLVOctets() {
    }

    public TLVOctets(short p_tag) {
        super(p_tag);
    }

    public TLVOctets(short p_tag, int min, int max) {
        super(p_tag, min, max);
    }

    public TLVOctets(short p_tag, ByteBuffer p_value) throws TLVException {
        super(p_tag);
        this.setValueData(p_value);
    }

    public TLVOctets(short p_tag, int min, int max, ByteBuffer p_value) throws TLVException {
        super(p_tag, min, max);
        this.setValueData(p_value);
    }

    protected void setValueData(ByteBuffer buffer) throws TLVException {
        this.checkLength(buffer);
        if (buffer != null) {
            try {
                this.value = buffer.removeBuffer(buffer.length());
            }
            catch (NotEnoughDataInByteBufferException e) {
                throw new Error("Removing buf.length() data from ByteBuffer buf reported too little data in buf, which shouldn't happen.");
            }
        } else {
            this.value = null;
        }
        this.markValueSet();
    }

    protected ByteBuffer getValueData() throws ValueNotSetException {
        ByteBuffer valueBuf = new ByteBuffer();
        valueBuf.appendBuffer(this.getValue());
        return valueBuf;
    }

    public void setValue(ByteBuffer p_value) {
        if (p_value != null) {
            try {
                this.value = p_value.removeBuffer(p_value.length());
            }
            catch (NotEnoughDataInByteBufferException e) {
                throw new Error("Removing buf.length() data from ByteBuffer buf reported too little data in buf, which shouldn't happen.");
            }
        } else {
            this.value = null;
        }
        this.markValueSet();
    }

    public ByteBuffer getValue() throws ValueNotSetException {
        if (this.hasValue()) {
            return this.value;
        }
        throw new ValueNotSetException();
    }

    public String debugString() {
        String dbgs = "(oct: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + (this.value == null ? "" : this.value.getHexDump());
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

