/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import java.io.UnsupportedEncodingException;
import org.smpp.pdu.ByteData;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;
import sun.io.CharToByteConverter;

public class ShortMessage
extends ByteData {
    int minLength = 0;
    int maxLength = 0;
    String message = null;
    String encoding = null;
    int length = 0;
    byte[] messageData = null;

    public ShortMessage(int maxLength) {
        this.maxLength = maxLength;
    }

    public ShortMessage(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public void setData(ByteBuffer buffer) throws PDUException, NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException {
        byte[] messageData = null;
        int length = 0;
        if (buffer != null) {
            messageData = buffer.getBuffer();
            length = messageData == null ? 0 : messageData.length;
            ShortMessage.checkString(this.minLength, length, this.maxLength);
        }
        this.message = null;
        this.messageData = messageData;
        this.length = length;
    }

    public ByteBuffer getData() {
        ByteBuffer buffer = null;
        buffer = new ByteBuffer(this.messageData);
        return buffer;
    }

    public void setMessage(String message) throws WrongLengthOfStringException {
        try {
            this.setMessage(message, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setMessage(String message, String encoding) throws WrongLengthOfStringException, UnsupportedEncodingException {
        ShortMessage.checkString(message, this.minLength, this.maxLength, encoding);
        if (message != null) {
            try {
                this.messageData = message.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                debug.write("encoding " + encoding + " not supported. Exception " + e);
                event.write(e, "encoding " + encoding + " not supported");
                throw e;
            }
            this.message = message;
            this.length = this.messageData.length;
            this.encoding = encoding;
        } else {
            this.message = null;
            this.messageData = null;
            this.encoding = encoding;
            this.length = 0;
        }
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.message = new String(this.messageData, encoding);
        this.encoding = encoding;
    }

    public String getMessage() {
        String useEncoding = this.encoding != null ? this.encoding : "UTF8";
        String theMessage = null;
        try {
            theMessage = this.getMessage(useEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return theMessage;
    }

    public String getMessage(String encoding) throws UnsupportedEncodingException {
        String message = null;
        if (this.messageData != null) {
            if (encoding != null && this.encoding != null && encoding.equals(this.encoding)) {
                if (this.message == null) {
                    this.message = new String(this.messageData, encoding);
                }
                message = this.message;
            } else {
                message = encoding != null ? new String(this.messageData, encoding) : new String(this.messageData);
            }
        }
        return message;
    }

    public int getLength() {
        return this.messageData.length;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static boolean encodingSuported(String encoding) {
        boolean supported = true;
        try {
            CharToByteConverter.getConverter((String)encoding);
        }
        catch (UnsupportedEncodingException e) {
            supported = false;
        }
        return supported;
    }

    public String debugString() {
        String dbgs = "(sm: ";
        if (this.encoding != null) {
            dbgs = dbgs + "enc: ";
            dbgs = dbgs + this.encoding;
            dbgs = dbgs + " ";
        }
        dbgs = dbgs + "msg: ";
        dbgs = dbgs + this.getMessage();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

