/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import java.io.UnsupportedEncodingException;
import org.smpp.pdu.Address;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.ReplaceSMResp;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.pdu.ShortMessage;
import org.smpp.pdu.WrongDateFormatException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class ReplaceSM
extends Request {
    private String messageId = "";
    private Address sourceAddr = new Address();
    private String scheduleDeliveryTime = "";
    private String validityPeriod = "";
    private byte registeredDelivery = 0;
    private byte smDefaultMsgId = 0;
    private short smLength = 0;
    private ShortMessage shortMessage = new ShortMessage(254);

    public ReplaceSM() {
        super(7);
    }

    protected Response createResponse() {
        return new ReplaceSMResp();
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        this.setMessageId(buffer.removeCString());
        this.sourceAddr.setData(buffer);
        this.setScheduleDeliveryTime(buffer.removeCString());
        this.setValidityPeriod(buffer.removeCString());
        this.setRegisteredDelivery(buffer.removeByte());
        this.setSmDefaultMsgId(buffer.removeByte());
        this.setSmLength(ReplaceSM.decodeUnsigned(buffer.removeByte()));
        this.shortMessage.setData(buffer.removeBuffer(this.getSmLength()));
    }

    public ByteBuffer getBody() {
        ByteBuffer buffer = new ByteBuffer();
        buffer.appendCString(this.messageId);
        buffer.appendBuffer(this.getSourceAddr().getData());
        buffer.appendCString(this.getScheduleDeliveryTime());
        buffer.appendCString(this.getValidityPeriod());
        buffer.appendByte(this.getRegisteredDelivery());
        buffer.appendByte(this.getSmDefaultMsgId());
        buffer.appendByte(ReplaceSM.encodeUnsigned(this.getSmLength()));
        buffer.appendBuffer(this.shortMessage.getData());
        return buffer;
    }

    public void setMessageId(String value) throws WrongLengthOfStringException {
        ReplaceSM.checkString(value, 64);
        this.messageId = value;
    }

    public void setScheduleDeliveryTime(String value) throws WrongDateFormatException {
        ReplaceSM.checkDate(value);
        this.scheduleDeliveryTime = value;
    }

    public void setValidityPeriod(String value) throws WrongDateFormatException {
        ReplaceSM.checkDate(value);
        this.validityPeriod = value;
    }

    public void setShortMessage(String value) throws WrongLengthOfStringException {
        this.shortMessage.setMessage(value);
        this.setSmLength((short)this.shortMessage.getLength());
    }

    public void setShortMessage(String value, String encoding) throws WrongLengthOfStringException, UnsupportedEncodingException {
        this.shortMessage.setMessage(value, encoding);
        this.setSmLength((short)this.shortMessage.getLength());
    }

    public void setSourceAddr(Address value) {
        this.sourceAddr = value;
    }

    public void setSourceAddr(String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(address));
    }

    public void setSourceAddr(byte ton, byte npi, String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(ton, npi, address));
    }

    public void setRegisteredDelivery(byte value) {
        this.registeredDelivery = value;
    }

    public void setSmDefaultMsgId(byte value) {
        this.smDefaultMsgId = value;
    }

    private void setSmLength(short value) {
        this.smLength = value;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getScheduleDeliveryTime() {
        return this.scheduleDeliveryTime;
    }

    public String getValidityPeriod() {
        return this.validityPeriod;
    }

    public String getShortMessage() {
        return this.shortMessage.getMessage();
    }

    public String getShortMessage(String encoding) throws UnsupportedEncodingException {
        return this.shortMessage.getMessage(encoding);
    }

    public Address getSourceAddr() {
        return this.sourceAddr;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public byte getSmDefaultMsgId() {
        return this.smDefaultMsgId;
    }

    public short getSmLength() {
        return this.smLength;
    }

    public String debugString() {
        String dbgs = "(replace: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getMessageId();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getSourceAddr().debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.shortMessage.debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.debugStringOptional();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

