/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.Address;
import org.smpp.pdu.DataSMResp;
import org.smpp.pdu.IntegerOutOfRangeException;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.pdu.tlv.TLVByte;
import org.smpp.pdu.tlv.TLVEmpty;
import org.smpp.pdu.tlv.TLVInt;
import org.smpp.pdu.tlv.TLVOctets;
import org.smpp.pdu.tlv.TLVShort;
import org.smpp.pdu.tlv.TLVString;
import org.smpp.pdu.tlv.TLVUByte;
import org.smpp.pdu.tlv.WrongLengthException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class DataSM
extends Request {
    private String serviceType = "";
    private Address sourceAddr = new Address(65);
    private Address destAddr = new Address(65);
    private byte esmClass = 0;
    private byte registeredDelivery = 0;
    private byte dataCoding = 0;
    private TLVShort userMessageReference = new TLVShort(516);
    private TLVShort sourcePort = new TLVShort(522);
    private TLVByte sourceAddrSubunit = new TLVByte(13);
    private TLVByte sourceNetworkType = new TLVByte(14);
    private TLVByte sourceBearerType = new TLVByte(15);
    private TLVByte sourceTelematicsId = new TLVByte(16);
    private TLVShort destinationPort = new TLVShort(523);
    private TLVByte destAddrSubunit = new TLVByte(5);
    private TLVByte destNetworkType = new TLVByte(6);
    private TLVByte destBearerType = new TLVByte(7);
    private TLVShort destTelematicsId = new TLVShort(8);
    private TLVShort sarMsgRefNum = new TLVShort(524);
    private TLVUByte sarTotalSegments = new TLVUByte(526);
    private TLVUByte sarSegmentSeqnum = new TLVUByte(527);
    private TLVByte moreMsgsToSend = new TLVByte(1062);
    private TLVInt qosTimeToLive = new TLVInt(23);
    private TLVByte payloadType = new TLVByte(25);
    private TLVOctets messagePayload = new TLVOctets(1060, 1, 1500);
    private TLVByte setDpf = new TLVByte(1057);
    private TLVString receiptedMessageId = new TLVString(30, 1, 65);
    private TLVByte messageState = new TLVByte(1063);
    private TLVOctets networkErrorCode = new TLVOctets(1059, 3, 3);
    private TLVByte privacyIndicator = new TLVByte(513);
    private TLVOctets callbackNum = new TLVOctets(897, 4, 19);
    private TLVByte callbackNumPresInd = new TLVByte(770);
    private TLVOctets callbackNumAtag = new TLVOctets(771, 1, 65);
    private TLVOctets sourceSubaddress = new TLVOctets(514, 2, 23);
    private TLVOctets destSubaddress = new TLVOctets(515, 2, 23);
    private TLVByte userResponseCode = new TLVByte(517);
    private TLVByte displayTime = new TLVByte(4609);
    private TLVShort smsSignal = new TLVShort(4611);
    private TLVByte msValidity = new TLVByte(4612);
    private TLVByte msMsgWaitFacilities = new TLVByte(2);
    private TLVByte numberOfMessages = new TLVByte(772);
    private TLVEmpty alertOnMsgDelivery = new TLVEmpty(4876);
    private TLVByte languageIndicator = new TLVByte(525);
    private TLVByte itsReplyType = new TLVByte(4992);
    private TLVShort itsSessionInfo = new TLVShort(4995);

    public DataSM() {
        super(259);
        this.registerOptional(this.userMessageReference);
        this.registerOptional(this.sourcePort);
        this.registerOptional(this.sourceAddrSubunit);
        this.registerOptional(this.sourceNetworkType);
        this.registerOptional(this.sourceBearerType);
        this.registerOptional(this.sourceTelematicsId);
        this.registerOptional(this.destinationPort);
        this.registerOptional(this.destAddrSubunit);
        this.registerOptional(this.destNetworkType);
        this.registerOptional(this.destBearerType);
        this.registerOptional(this.destTelematicsId);
        this.registerOptional(this.sarMsgRefNum);
        this.registerOptional(this.sarTotalSegments);
        this.registerOptional(this.sarSegmentSeqnum);
        this.registerOptional(this.moreMsgsToSend);
        this.registerOptional(this.qosTimeToLive);
        this.registerOptional(this.payloadType);
        this.registerOptional(this.messagePayload);
        this.registerOptional(this.setDpf);
        this.registerOptional(this.receiptedMessageId);
        this.registerOptional(this.messageState);
        this.registerOptional(this.networkErrorCode);
        this.registerOptional(this.privacyIndicator);
        this.registerOptional(this.callbackNum);
        this.registerOptional(this.callbackNumPresInd);
        this.registerOptional(this.callbackNumAtag);
        this.registerOptional(this.sourceSubaddress);
        this.registerOptional(this.destSubaddress);
        this.registerOptional(this.userResponseCode);
        this.registerOptional(this.displayTime);
        this.registerOptional(this.smsSignal);
        this.registerOptional(this.msValidity);
        this.registerOptional(this.msMsgWaitFacilities);
        this.registerOptional(this.numberOfMessages);
        this.registerOptional(this.alertOnMsgDelivery);
        this.registerOptional(this.languageIndicator);
        this.registerOptional(this.itsReplyType);
        this.registerOptional(this.itsSessionInfo);
    }

    protected Response createResponse() {
        return new DataSMResp();
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        this.setServiceType(buffer.removeCString());
        this.sourceAddr.setData(buffer);
        this.destAddr.setData(buffer);
        this.setEsmClass(buffer.removeByte());
        this.setRegisteredDelivery(buffer.removeByte());
        this.setDataCoding(buffer.removeByte());
    }

    public ByteBuffer getBody() {
        ByteBuffer buffer = new ByteBuffer();
        buffer.appendCString(this.getServiceType());
        buffer.appendBuffer(this.getSourceAddr().getData());
        buffer.appendBuffer(this.getDestAddr().getData());
        buffer.appendByte(this.getEsmClass());
        buffer.appendByte(this.getRegisteredDelivery());
        buffer.appendByte(this.getDataCoding());
        return buffer;
    }

    public void setServiceType(String value) throws WrongLengthOfStringException {
        DataSM.checkCString(value, 6);
        this.serviceType = value;
    }

    public void setSourceAddr(Address value) {
        this.sourceAddr = value;
    }

    public void setSourceAddr(String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(address));
    }

    public void setSourceAddr(byte ton, byte npi, String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(ton, npi, address));
    }

    public void setDestAddr(Address value) {
        this.destAddr = value;
    }

    public void setDestAddr(String address) throws WrongLengthOfStringException {
        this.setDestAddr(new Address(address));
    }

    public void setDestAddr(byte ton, byte npi, String address) throws WrongLengthOfStringException {
        this.setDestAddr(new Address(ton, npi, address));
    }

    public void setEsmClass(byte value) {
        this.esmClass = value;
    }

    public void setRegisteredDelivery(byte value) {
        this.registeredDelivery = value;
    }

    public void setDataCoding(byte value) {
        this.dataCoding = value;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public Address getSourceAddr() {
        return this.sourceAddr;
    }

    public Address getDestAddr() {
        return this.destAddr;
    }

    public byte getEsmClass() {
        return this.esmClass;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public byte getDataCoding() {
        return this.dataCoding;
    }

    public boolean hasUserMessageReference() {
        return this.userMessageReference.hasValue();
    }

    public boolean hasSourcePort() {
        return this.sourcePort.hasValue();
    }

    public boolean hasSourceAddrSubunit() {
        return this.sourceAddrSubunit.hasValue();
    }

    public boolean hasSourceNetworkType() {
        return this.sourceNetworkType.hasValue();
    }

    public boolean hasSourceBearerType() {
        return this.sourceBearerType.hasValue();
    }

    public boolean hasSourceTelematicsId() {
        return this.sourceTelematicsId.hasValue();
    }

    public boolean hasDestinationPort() {
        return this.destinationPort.hasValue();
    }

    public boolean hasDestAddrSubunit() {
        return this.destAddrSubunit.hasValue();
    }

    public boolean hasDestNetworkType() {
        return this.destNetworkType.hasValue();
    }

    public boolean hasDestBearerType() {
        return this.destBearerType.hasValue();
    }

    public boolean hasDestTelematicsId() {
        return this.destTelematicsId.hasValue();
    }

    public boolean hasSarMsgRefNum() {
        return this.sarMsgRefNum.hasValue();
    }

    public boolean hasSarTotalSegments() {
        return this.sarTotalSegments.hasValue();
    }

    public boolean hasSarSegmentSeqnum() {
        return this.sarSegmentSeqnum.hasValue();
    }

    public boolean hasMoreMsgsToSend() {
        return this.moreMsgsToSend.hasValue();
    }

    public boolean hasQosTimeToLive() {
        return this.qosTimeToLive.hasValue();
    }

    public boolean hasPayloadType() {
        return this.payloadType.hasValue();
    }

    public boolean hasMessagePayload() {
        return this.messagePayload.hasValue();
    }

    public boolean hasSetDpf() {
        return this.setDpf.hasValue();
    }

    public boolean hasReceiptedMessageId() {
        return this.receiptedMessageId.hasValue();
    }

    public boolean hasMessageState() {
        return this.messageState.hasValue();
    }

    public boolean hasNetworkErrorCode() {
        return this.networkErrorCode.hasValue();
    }

    public boolean hasPrivacyIndicator() {
        return this.privacyIndicator.hasValue();
    }

    public boolean hasCallbackNum() {
        return this.callbackNum.hasValue();
    }

    public boolean hasCallbackNumPresInd() {
        return this.callbackNumPresInd.hasValue();
    }

    public boolean hasCallbackNumAtag() {
        return this.callbackNumAtag.hasValue();
    }

    public boolean hasSourceSubaddress() {
        return this.sourceSubaddress.hasValue();
    }

    public boolean hasDestSubaddress() {
        return this.destSubaddress.hasValue();
    }

    public boolean hasUserResponseCode() {
        return this.userResponseCode.hasValue();
    }

    public boolean hasDisplayTime() {
        return this.displayTime.hasValue();
    }

    public boolean hasSmsSignal() {
        return this.smsSignal.hasValue();
    }

    public boolean hasMsValidity() {
        return this.msValidity.hasValue();
    }

    public boolean hasMsMsgWaitFacilities() {
        return this.msMsgWaitFacilities.hasValue();
    }

    public boolean hasNumberOfMessages() {
        return this.numberOfMessages.hasValue();
    }

    public boolean hasAlertOnMsgDelivery() {
        return this.alertOnMsgDelivery.hasValue();
    }

    public boolean hasLanguageIndicator() {
        return this.languageIndicator.hasValue();
    }

    public boolean hasItsReplyType() {
        return this.itsReplyType.hasValue();
    }

    public boolean hasItsSessionInfo() {
        return this.itsSessionInfo.hasValue();
    }

    public void setUserMessageReference(short value) {
        this.userMessageReference.setValue(value);
    }

    public void setSourcePort(short value) {
        this.sourcePort.setValue(value);
    }

    public void setSourceAddrSubunit(byte value) {
        this.sourceAddrSubunit.setValue(value);
    }

    public void setSourceNetworkType(byte value) {
        this.sourceNetworkType.setValue(value);
    }

    public void setSourceBearerType(byte value) {
        this.sourceBearerType.setValue(value);
    }

    public void setSourceTelematicsId(byte value) {
        this.sourceTelematicsId.setValue(value);
    }

    public void setDestinationPort(short value) {
        this.destinationPort.setValue(value);
    }

    public void setDestAddrSubunit(byte value) {
        this.destAddrSubunit.setValue(value);
    }

    public void setDestNetworkType(byte value) {
        this.destNetworkType.setValue(value);
    }

    public void setDestBearerType(byte value) {
        this.destBearerType.setValue(value);
    }

    public void setDestTelematicsId(short value) {
        this.destTelematicsId.setValue(value);
    }

    public void setSarMsgRefNum(short value) {
        this.sarMsgRefNum.setValue(value);
    }

    public void setSarTotalSegments(short value) throws IntegerOutOfRangeException {
        this.sarTotalSegments.setValue(value);
    }

    public void setSarSegmentSeqnum(short value) throws IntegerOutOfRangeException {
        this.sarSegmentSeqnum.setValue(value);
    }

    public void setMoreMsgsToSend(byte value) {
        this.moreMsgsToSend.setValue(value);
    }

    public void setQosTimeToLive(int value) {
        this.qosTimeToLive.setValue(value);
    }

    public void setPayloadType(byte value) {
        this.payloadType.setValue(value);
    }

    public void setMessagePayload(ByteBuffer value) {
        this.messagePayload.setValue(value);
    }

    public void setSetDpf(byte value) {
        this.setDpf.setValue(value);
    }

    public void setReceiptedMessageId(String value) throws WrongLengthException {
        this.receiptedMessageId.setValue(value);
    }

    public void setMessageState(byte value) {
        this.messageState.setValue(value);
    }

    public void setNetworkErrorCode(ByteBuffer value) {
        this.networkErrorCode.setValue(value);
    }

    public void setPrivacyIndicator(byte value) {
        this.privacyIndicator.setValue(value);
    }

    public void setCallbackNum(ByteBuffer value) {
        this.callbackNum.setValue(value);
    }

    public void setCallbackNumPresInd(byte value) {
        this.callbackNumPresInd.setValue(value);
    }

    public void setCallbackNumAtag(ByteBuffer value) {
        this.callbackNumAtag.setValue(value);
    }

    public void setSourceSubaddress(ByteBuffer value) {
        this.sourceSubaddress.setValue(value);
    }

    public void setDestSubaddress(ByteBuffer value) {
        this.destSubaddress.setValue(value);
    }

    public void setUserResponseCode(byte value) {
        this.userResponseCode.setValue(value);
    }

    public void setDisplayTime(byte value) {
        this.displayTime.setValue(value);
    }

    public void setSmsSignal(short value) {
        this.smsSignal.setValue(value);
    }

    public void setMsValidity(byte value) {
        this.msValidity.setValue(value);
    }

    public void setMsMsgWaitFacilities(byte value) {
        this.msMsgWaitFacilities.setValue(value);
    }

    public void setNumberOfMessages(byte value) {
        this.numberOfMessages.setValue(value);
    }

    public void setAlertOnMsgDelivery(boolean value) {
        this.alertOnMsgDelivery.setValue(value);
    }

    public void setLanguageIndicator(byte value) {
        this.languageIndicator.setValue(value);
    }

    public void setItsReplyType(byte value) {
        this.itsReplyType.setValue(value);
    }

    public void setItsSessionInfo(short value) {
        this.itsSessionInfo.setValue(value);
    }

    public short getUserMessageReference() throws ValueNotSetException {
        return this.userMessageReference.getValue();
    }

    public short getSourcePort() throws ValueNotSetException {
        return this.sourcePort.getValue();
    }

    public byte getSourceAddrSubunit() throws ValueNotSetException {
        return this.sourceAddrSubunit.getValue();
    }

    public byte getSourceNetworkType() throws ValueNotSetException {
        return this.sourceNetworkType.getValue();
    }

    public byte getSourceBearerType() throws ValueNotSetException {
        return this.sourceBearerType.getValue();
    }

    public byte getSourceTelematicsId() throws ValueNotSetException {
        return this.sourceTelematicsId.getValue();
    }

    public short getDestinationPort() throws ValueNotSetException {
        return this.destinationPort.getValue();
    }

    public byte getDestAddrSubunit() throws ValueNotSetException {
        return this.destAddrSubunit.getValue();
    }

    public byte getDestNetworkType() throws ValueNotSetException {
        return this.destNetworkType.getValue();
    }

    public byte getDestBearerType() throws ValueNotSetException {
        return this.destBearerType.getValue();
    }

    public short getDestTelematicsId() throws ValueNotSetException {
        return this.destTelematicsId.getValue();
    }

    public short getSarMsgRefNum() throws ValueNotSetException {
        return this.sarMsgRefNum.getValue();
    }

    public short getSarTotalSegments() throws ValueNotSetException {
        return this.sarTotalSegments.getValue();
    }

    public short getSarSegmentSeqnum() throws ValueNotSetException {
        return this.sarSegmentSeqnum.getValue();
    }

    public byte getMoreMsgsToSend() throws ValueNotSetException {
        return this.moreMsgsToSend.getValue();
    }

    public int getQosTimeToLive() throws ValueNotSetException {
        return this.qosTimeToLive.getValue();
    }

    public byte getPayloadType() throws ValueNotSetException {
        return this.payloadType.getValue();
    }

    public ByteBuffer getMessagePayload() throws ValueNotSetException {
        return this.messagePayload.getValue();
    }

    public byte getSetDpf() throws ValueNotSetException {
        return this.setDpf.getValue();
    }

    public String getReceiptedMessageId() throws ValueNotSetException {
        return this.receiptedMessageId.getValue();
    }

    public byte getMessageState() throws ValueNotSetException {
        return this.messageState.getValue();
    }

    public ByteBuffer getNetworkErrorCode() throws ValueNotSetException {
        return this.networkErrorCode.getValue();
    }

    public byte getPrivacyIndicator() throws ValueNotSetException {
        return this.privacyIndicator.getValue();
    }

    public ByteBuffer callbackNum() throws ValueNotSetException {
        return this.callbackNum.getValue();
    }

    public byte getCallbackNumPresInd() throws ValueNotSetException {
        return this.callbackNumPresInd.getValue();
    }

    public ByteBuffer getCallbackNumAtag() throws ValueNotSetException {
        return this.callbackNumAtag.getValue();
    }

    public ByteBuffer getSourceSubaddress() throws ValueNotSetException {
        return this.sourceSubaddress.getValue();
    }

    public ByteBuffer getDestSubaddress() throws ValueNotSetException {
        return this.destSubaddress.getValue();
    }

    public byte getUserResponseCode() throws ValueNotSetException {
        return this.userResponseCode.getValue();
    }

    public byte getDisplayTime() throws ValueNotSetException {
        return this.displayTime.getValue();
    }

    public short getSmsSignal() throws ValueNotSetException {
        return this.smsSignal.getValue();
    }

    public byte getMsValidity() throws ValueNotSetException {
        return this.msValidity.getValue();
    }

    public byte getMsMsgWaitFacilities() throws ValueNotSetException {
        return this.msMsgWaitFacilities.getValue();
    }

    public byte getNumberOfMessages() throws ValueNotSetException {
        return this.numberOfMessages.getValue();
    }

    public boolean getAlertOnMsgDelivery() throws ValueNotSetException {
        return this.alertOnMsgDelivery.getValue();
    }

    public byte getLanguageIndicator() throws ValueNotSetException {
        return this.languageIndicator.getValue();
    }

    public byte getItsReplyType() throws ValueNotSetException {
        return this.itsReplyType.getValue();
    }

    public short getItsSessionInfo() throws ValueNotSetException {
        return this.itsSessionInfo.getValue();
    }

    public String debugString() {
        String dbgs = "(data: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getSourceAddr().debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getDestAddr().debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.debugStringOptional();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

