/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.Address;
import org.smpp.pdu.CancelSMResp;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class CancelSM
extends Request {
    private String serviceType = "";
    private String messageId = "";
    private Address sourceAddr = new Address();
    private Address destAddr = new Address();

    public CancelSM() {
        super(8);
    }

    protected Response createResponse() {
        return new CancelSMResp();
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        this.setServiceType(buffer.removeCString());
        this.setMessageId(buffer.removeCString());
        this.sourceAddr.setData(buffer);
        this.destAddr.setData(buffer);
    }

    public ByteBuffer getBody() {
        ByteBuffer buffer = new ByteBuffer();
        buffer.appendCString(this.getServiceType());
        buffer.appendCString(this.messageId);
        buffer.appendBuffer(this.getSourceAddr().getData());
        buffer.appendBuffer(this.getDestAddr().getData());
        return buffer;
    }

    public void setServiceType(String value) throws WrongLengthOfStringException {
        CancelSM.checkCString(value, 6);
        this.serviceType = value;
    }

    public void setMessageId(String value) throws WrongLengthOfStringException {
        CancelSM.checkString(value, 64);
        this.messageId = value;
    }

    public void setSourceAddr(Address value) {
        this.sourceAddr = value;
    }

    public void setSourceAddr(String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(address));
    }

    public void setSourceAddr(byte ton, byte npi, String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(ton, npi, address));
    }

    public void setDestAddr(Address value) {
        this.destAddr = value;
    }

    public void setDestAddr(String address) throws WrongLengthOfStringException {
        this.setDestAddr(new Address(address));
    }

    public void setDestAddr(byte ton, byte npi, String address) throws WrongLengthOfStringException {
        this.setDestAddr(new Address(ton, npi, address));
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Address getSourceAddr() {
        return this.sourceAddr;
    }

    public Address getDestAddr() {
        return this.destAddr;
    }

    public String debugString() {
        String dbgs = "(cancel: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getServiceType();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getMessageId();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getSourceAddr().debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getDestAddr().debugString();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

