/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.AddressRange;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.Request;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public abstract class BindRequest
extends Request {
    private String systemId = "";
    private String password = "";
    private String systemType = "";
    private AddressRange addressRange = new AddressRange();
    private byte interfaceVersion = (byte)52;

    public abstract boolean isTransmitter();

    public abstract boolean isReceiver();

    public BindRequest(int commandId) {
        super(commandId);
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        this.setSystemId(buffer.removeCString());
        this.setPassword(buffer.removeCString());
        this.setSystemType(buffer.removeCString());
        this.setInterfaceVersion(buffer.removeByte());
        this.addressRange.setData(buffer);
    }

    public ByteBuffer getBody() {
        ByteBuffer buffer = new ByteBuffer();
        buffer.appendCString(this.getSystemId());
        buffer.appendCString(this.getPassword());
        buffer.appendCString(this.getSystemType());
        buffer.appendByte(this.getInterfaceVersion());
        buffer.appendBuffer(this.getAddressRange().getData());
        return buffer;
    }

    public void setSystemId(String sysId) throws WrongLengthOfStringException {
        BindRequest.checkString(sysId, 16);
        this.systemId = sysId;
    }

    public void setPassword(String pwd) throws WrongLengthOfStringException {
        BindRequest.checkString(pwd, 9);
        this.password = pwd;
    }

    public void setSystemType(String type) throws WrongLengthOfStringException {
        BindRequest.checkString(type, 13);
        this.systemType = type;
    }

    public void setInterfaceVersion(byte vers) {
        this.interfaceVersion = vers;
    }

    public void setAddressRange(AddressRange adr) {
        this.addressRange = adr;
    }

    public void setAddressRange(String rangeString) throws WrongLengthOfStringException {
        this.setAddressRange(new AddressRange(rangeString));
    }

    public void setAddressRange(byte ton, byte npi, String rangeString) throws WrongLengthOfStringException {
        this.setAddressRange(new AddressRange(ton, npi, rangeString));
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public byte getInterfaceVersion() {
        return this.interfaceVersion;
    }

    public AddressRange getAddressRange() {
        return this.addressRange;
    }

    public String debugString() {
        String dbgs = "(bindreq: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getSystemId();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getPassword();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getSystemType();
        dbgs = dbgs + " ";
        dbgs = dbgs + Integer.toString(this.getInterfaceVersion());
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getAddressRange().debugString();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

