/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.debug;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;

public class FileLog {
    private boolean active = false;
    private long filesize = 1024000L;
    private String fileExtension = "";
    private String endLine = "";
    private String fileName = "";
    private String fileDir = "";
    private File logFile;
    private BufferedWriter fileOut;
    private char currentFileIndex = (char)48;
    private static String[] WEEK_DAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public FileLog() {
        this.endLine = System.getProperty("line.separator", "");
    }

    public FileLog(String dir, String name) {
        this.endLine = System.getProperty("line.separator", "");
        this.setCurrentFileIndex('0');
        this.setFileDir(dir);
        if (name != "") {
            this.setFileName(name.substring(0, name.length() - 4));
            this.setFileExtension(name.substring(name.length() - 4, name.length()));
            this.openFile(this.getFullName());
        } else {
            this.deactivate();
        }
    }

    public void finalize() {
        try {
            this.fileOut.flush();
            this.fileOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setCurrentFileIndex(char c) {
        this.currentFileIndex = c;
    }

    protected void setFileDir(String fd) {
        this.fileDir = fd;
    }

    protected void setFileName(String fnr) {
        this.fileName = fnr;
    }

    public void setFileSize(int size) {
        this.filesize = size;
    }

    protected void setFileExtension(String extension) {
        this.fileExtension = extension;
    }

    protected char getCurrentFileIndex() {
        return this.currentFileIndex;
    }

    protected String getFileDir() {
        return this.fileDir;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected String getFileExtension() {
        return this.fileExtension;
    }

    protected String getFullName() {
        return new String(this.getFileDir() + this.getFileName() + this.getCurrentFileIndex() + this.getFileExtension());
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    protected void openFile(String filename) {
        try {
            this.logFile = new File(filename);
            this.fileOut = new BufferedWriter(new FileWriter(filename, false));
        }
        catch (Exception e) {
            System.err.println("The file stream could not be opened in openFile() " + e);
        }
    }

    private void changeFile() {
        if (this.getCurrentFileIndex() < '2') {
            this.setCurrentFileIndex((char)(this.getCurrentFileIndex() + '\u0001'));
        } else {
            this.setCurrentFileIndex('0');
        }
        try {
            this.fileOut = new BufferedWriter(new FileWriter(this.getFullName()));
        }
        catch (Exception e) {
            System.err.println("Error setting fileOut to next file in changeFile() " + e);
        }
        this.logFile = new File(this.getFullName());
    }

    protected synchronized void genericWrite(String msg) {
        long size = this.logFile.length();
        try {
            if (size >= this.filesize) {
                this.changeFile();
            }
            String tmStamp = FileLog.getLineTimeStamp();
            this.fileOut.write(tmStamp + " " + msg + this.endLine);
            this.fileOut.flush();
        }
        catch (Exception e) {
            System.err.println("Event log failure in genericWrite() " + e);
        }
    }

    public static String getLineTimeStamp() {
        String retDate = "";
        String padString = "";
        Calendar fullCalendar = Calendar.getInstance();
        padString = Integer.toString(fullCalendar.get(10));
        retDate = retDate + FileLog.zeroPad(2, padString);
        padString = Integer.toString(fullCalendar.get(12));
        retDate = retDate + ":" + FileLog.zeroPad(2, padString);
        padString = Integer.toString(fullCalendar.get(13));
        retDate = retDate + ":" + FileLog.zeroPad(2, padString);
        return retDate;
    }

    protected static String zeroPad(int length, String toPad) {
        int numberOfZeroes = length - toPad.length();
        for (int counter = 0; counter < numberOfZeroes; ++counter) {
            toPad = "0" + toPad;
        }
        return toPad;
    }

    protected synchronized void blankLine() {
        try {
            if (this.logFile.length() < this.filesize) {
                this.fileOut.write(this.endLine);
                this.fileOut.flush();
            }
        }
        catch (Exception e) {
            System.err.println("Event log failure in blankLine() " + e);
        }
    }
}

