/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.debug;

import java.util.Hashtable;
import java.util.Stack;
import org.smpp.debug.Debug;
import org.smpp.debug.FileLog;

public class FileDebug
implements Debug {
    Hashtable threads = new Hashtable();
    private FileLog log = new FileLog();
    private static final int DFLT_GROUP_COUNT = 64;
    private int groupCount;
    private boolean[] groups = new boolean[this.groupCount];

    public FileDebug(String dir, String name) {
        this.log = new FileLog(dir, name);
        this.setGroupCount(64);
        this.activate();
    }

    public void enter(int group, Object from, String name) {
        if (this.isActive(group) && this.isActive()) {
            this.enter(from, name);
        }
    }

    public void enter(Object from, String name) {
        if (this.isActive()) {
            ThreadDebugInfo thread = this.getThreadInfo();
            String className = from.getClass().getName();
            int i = className.lastIndexOf(46);
            if (i != -1) {
                className = className.substring(i + 1, className.length());
            }
            thread.enter(className, name);
            this.write("entered");
        }
    }

    public void write(int group, String msg) {
        if (this.isActive(group) && this.isActive()) {
            this.write(msg + " (" + group + ")");
        }
    }

    public void write(String msg) {
        if (this.isActive()) {
            ThreadDebugInfo thread = this.getThreadInfo();
            this.log.genericWrite(thread.signature() + " " + msg);
        }
    }

    public void exit(int group, Object from) {
        if (this.isActive(group) && this.isActive()) {
            this.exit(from);
        }
    }

    public void exit(Object from) {
        if (this.isActive()) {
            this.write("exited");
            ThreadDebugInfo thread = this.getThreadInfo();
            thread.exit();
        }
    }

    public void activate() {
        if (this.log != null) {
            this.log.activate();
        }
    }

    public void activate(int group) {
        if (0 <= group && group < this.groupCount) {
            this.groups[group] = true;
            this.write("trace group " + group + " activated");
        }
    }

    public void deactivate() {
        if (this.log != null) {
            this.log.deactivate();
        }
    }

    public void deactivate(int group) {
        if (0 <= group && group < this.groupCount) {
            this.groups[group] = false;
            this.write("trace group " + group + " deactivated");
        }
    }

    public boolean active(int group) {
        return this.isActive(group);
    }

    public boolean isActive() {
        return this.log != null ? this.log.isActive() : false;
    }

    public boolean isActive(int group) {
        return 0 <= group && group < this.groupCount ? this.groups[group] : false;
    }

    public void setGroupCount(int groupCount) {
        this.groups = new boolean[groupCount];
        this.groupCount = groupCount;
        for (int group = 0; group < groupCount; ++group) {
            this.activate(group);
        }
    }

    private String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadDebugInfo getThreadInfo() {
        ThreadDebugInfo thread;
        String threadName = this.getCurrentThreadName();
        Hashtable hashtable = this.threads;
        synchronized (hashtable) {
            thread = (ThreadDebugInfo)this.threads.get(threadName);
            if (thread == null) {
                thread = new ThreadDebugInfo(threadName);
                this.threads.put(threadName, thread);
            }
        }
        return thread;
    }

    class ThreadDebugInfo {
        String threadName;
        Stack callStack = new Stack();
        int nesting = 0;
        String indent = "";
        static final int INDENT_POSITIONS = 3;

        public ThreadDebugInfo(String threadName) {
            this.threadName = threadName;
            this.callStack.push("main()");
        }

        public void enter(String className, String functionName) {
            this.enter(className + "." + functionName);
        }

        public void enter(String signature) {
            this.callStack.push(signature);
            ++this.nesting;
            this.indent = this.generateIndent();
        }

        public void exit() {
            this.callStack.pop();
            if (this.nesting > 1) {
                --this.nesting;
            }
            this.indent = this.generateIndent();
        }

        public String signature() {
            return this.indent + this.threadName + ": " + (String)this.callStack.peek();
        }

        private String generateIndent() {
            int i;
            String indent = "";
            String single = "";
            if (this.nesting >= 32) {
                for (i = 0; i < this.nesting; ++i) {
                    single = single + " ";
                }
            } else {
                byte nbyte = (byte)(this.nesting & 0x1F);
                if ((nbyte & 0x10) != 0) {
                    single = single + "                ";
                }
                if ((nbyte & 8) != 0) {
                    single = single + "        ";
                }
                if ((nbyte & 4) != 0) {
                    single = single + "    ";
                }
                if ((nbyte & 2) != 0) {
                    single = single + "  ";
                }
                if ((nbyte & 1) != 0) {
                    single = single + " ";
                }
            }
            for (i = 0; i < 3; ++i) {
                indent = indent + single;
            }
            return indent;
        }
    }
}

