/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.debug;

import org.smpp.debug.Debug;

public class DefaultDebug
implements Debug {
    private int indent = 0;
    private boolean active = false;

    public void enter(int group, Object from, String name) {
        this.enter(from, name);
    }

    public void enter(Object from, String name) {
        if (this.active) {
            System.out.println(this.getDelimiter(true, from, name));
            ++this.indent;
        }
    }

    public void write(int group, String msg) {
        this.write(msg);
    }

    public void write(String msg) {
        if (this.active) {
            System.out.println(this.getIndent() + " " + msg);
        }
    }

    public void exit(int group, Object from) {
        this.exit(from);
    }

    public void exit(Object from) {
        if (this.active) {
            --this.indent;
            if (this.indent < 0) {
                this.indent = 0;
            }
            System.out.println(this.getDelimiter(false, from, ""));
        }
    }

    public void activate() {
        this.active = true;
    }

    public void activate(int group) {
    }

    public void deactivate() {
        this.active = false;
    }

    public void deactivate(int group) {
    }

    public boolean active(int group) {
        return true;
    }

    private String getDelimiter(boolean start, Object from, String name) {
        String indentStr = this.getIndent();
        indentStr = start ? indentStr + "-> " : indentStr + "<- ";
        return indentStr + from.toString() + (name == "" ? "" : " " + name);
    }

    private String getIndent() {
        String result = new String("");
        for (int i = 0; i < this.indent; ++i) {
            result = result + "  ";
        }
        return result;
    }
}

