/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xwpf.usermodel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;

public class SimpleDocumentWithHeader {
    public static void main(String[] args) throws IOException {
        try (XWPFDocument doc = new XWPFDocument();){
            XWPFParagraph p = doc.createParagraph();
            XWPFRun r = p.createRun();
            r.setText("Some Text");
            r.setBold(true);
            r = p.createRun();
            r.setText("Goodbye");
            CTP ctP = (CTP)CTP.Factory.newInstance();
            CTText t = ctP.addNewR().addNewT();
            t.setStringValue("header");
            p = new XWPFParagraph(ctP, doc);
            XWPFParagraph[] pars = new XWPFParagraph[]{p};
            XWPFHeaderFooterPolicy hfPolicy = doc.createHeaderFooterPolicy();
            hfPolicy.createHeader(XWPFHeaderFooterPolicy.DEFAULT, pars);
            ctP = (CTP)CTP.Factory.newInstance();
            t = ctP.addNewR().addNewT();
            t.setStringValue("My Footer");
            pars[0] = new XWPFParagraph(ctP, doc);
            hfPolicy.createFooter(XWPFHeaderFooterPolicy.DEFAULT, pars);
            try (FileOutputStream os = new FileOutputStream(new File("header.docx"));){
                doc.write(os);
            }
        }
    }
}

