/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xssf.usermodel;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.extractor.XSSFExportToXml;
import org.apache.poi.xssf.usermodel.XSSFMap;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class CustomXMLMapping {
    private CustomXMLMapping() {
    }

    public static void main(String[] args) throws Exception {
        try (OPCPackage pkg = OPCPackage.open(args[0]);
             XSSFWorkbook wb = new XSSFWorkbook(pkg);){
            for (XSSFMap map : wb.getCustomXMLMappings()) {
                XSSFExportToXml exporter = new XSSFExportToXml(map);
                UnsynchronizedByteArrayOutputStream os = UnsynchronizedByteArrayOutputStream.builder().get();
                exporter.exportToXML((OutputStream)os, true);
                String xml = os.toString(StandardCharsets.UTF_8);
                System.out.println(xml);
            }
        }
    }
}

