/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hwmf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.draw.HwmfROP3Composite;
import org.apache.poi.hwmf.record.HwmfTernaryRasterOp;

public final class ROP3Table {
    private static final long PATTERN = -6134559832493151659L;
    private static final HwmfTernaryRasterOp[] OPS = HwmfTernaryRasterOp.values();
    private static final int COLS = 16;
    private static final int BOX = 100;
    private static final double SCALE = 2.0;
    private static final double HEADER = 1.1;
    private static final Rectangle2D RECT = new Rectangle2D.Double(5.0, 5.0, 90.0, 90.0);
    private static final Shape CIRCLE_BIG = new Ellipse2D.Double(15.0, 15.0, 70.0, 70.0);
    private static final Shape CIRCLE_SMALL = new Ellipse2D.Double(40.0, 40.0, 20.0, 20.0);
    private static final Shape LABEL_BOX = new Rectangle2D.Double(6.0, 85.0, 88.0, 10.0);
    private static final AlphaComposite SRC_OVER = AlphaComposite.getInstance(3);
    private static final AffineTransform INIT_AT = AffineTransform.getScaleInstance(2.0, 2.0);

    private ROP3Table() {
    }

    public static void main(String[] args) throws IOException {
        BufferedImage pattern = ROP3Table.getPattern();
        BufferedImage source = ROP3Table.getSource();
        BufferedImage dest = new BufferedImage(3200, (int)(100.0 * ((double)Math.max(OPS.length / 16, 1) + 1.1) * 2.0), 2);
        Graphics2D g = dest.createGraphics();
        g.setTransform(INIT_AT);
        g.setFont(new Font("SansSerif", 0, 10));
        g.translate(550.0, 0.0);
        g.setColor(Color.BLACK);
        ROP3Table.fillDest(g);
        ROP3Table.fillLabel(g, "Dest");
        g.translate(200, 0);
        g.drawImage((Image)source, 0, 0, null);
        ROP3Table.fillLabel(g, "Source");
        g.translate(200, 0);
        g.setPaint(new TexturePaint(pattern, RECT));
        g.fill(RECT);
        ROP3Table.fillLabel(g, "Pattern");
        int idx = 0;
        for (HwmfTernaryRasterOp op : OPS) {
            g.setTransform(INIT_AT);
            g.translate(0.0, 110.00000000000001);
            g.translate(100 * (idx % 16), 100 * (idx / 16));
            ROP3Table.fillDest(g);
            ROP3Table.fillPattern(g, op, pattern, source);
            ROP3Table.fillLabel(g, op.name());
            ++idx;
        }
        g.dispose();
        ImageIO.write((RenderedImage)dest, "PNG", new File("rop3.png"));
    }

    private static BufferedImage getPattern() {
        return HwmfGraphics.getPatternFromLong(-6134559832493151659L, Color.BLACK, Color.WHITE, false);
    }

    private static BufferedImage getSource() {
        BufferedImage checker = new BufferedImage(100, 100, 2);
        Graphics2D cg = checker.createGraphics();
        cg.setColor(Color.PINK);
        cg.fill(RECT);
        cg.setColor(new Color(15132410, false));
        cg.fill(new Rectangle2D.Double(5.0, 5.0, 45.0, 45.0));
        cg.fill(new Rectangle2D.Double(50.0, 50.0, 45.0, 45.0));
        cg.dispose();
        return checker;
    }

    private static void fillDest(Graphics2D g) {
        g.setComposite(SRC_OVER);
        g.setColor(Color.LIGHT_GRAY);
        g.fill(RECT);
        g.setColor(new Color(14329120, false));
        g.fill(CIRCLE_BIG);
        g.setColor(Color.RED);
        g.fill(CIRCLE_SMALL);
    }

    private static void fillPattern(Graphics2D g, HwmfTernaryRasterOp op, BufferedImage pattern, BufferedImage source) {
        g.setComposite(new HwmfROP3Composite(g.getTransform(), RECT, op, pattern, Color.YELLOW, Color.BLUE));
        g.setClip(RECT);
        g.drawImage((Image)source, 0, 0, null);
        g.setClip(null);
        g.setComposite(SRC_OVER);
    }

    private static void fillLabel(Graphics2D g, String str) {
        g.setColor(Color.WHITE);
        g.fill(LABEL_BOX);
        g.setColor(Color.BLACK);
        TextLayout t = new TextLayout(str, g.getFont(), g.getFontRenderContext());
        Rectangle2D b = t.getBounds();
        g.drawString(str, (float)((100.0 - b.getWidth()) / 2.0), 94.0f);
    }
}

