/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hpsf;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.Section;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;

public final class ReadCustomPropertySets {
    private ReadCustomPropertySets() {
    }

    public static void main(String[] args) throws IOException {
        String filename = args[0];
        POIFSReader r = new POIFSReader();
        r.registerListener(ReadCustomPropertySets::processPOIFSReaderEvent);
        r.read(new File(filename));
    }

    public static void processPOIFSReaderEvent(POIFSReaderEvent event) {
        PropertySet ps;
        String streamName = event.getPath() + event.getName();
        try {
            ps = PropertySetFactory.create(event.getStream());
        }
        catch (NoPropertySetStreamException ex) {
            ReadCustomPropertySets.out("No property set stream: \"" + streamName + "\"");
            return;
        }
        catch (Exception ex) {
            throw new HPSFRuntimeException("Property set stream \"" + streamName + "\": " + ex);
        }
        ReadCustomPropertySets.out("Property set stream \"" + streamName + "\":");
        long sectionCount = ps.getSectionCount();
        ReadCustomPropertySets.out("   No. of sections: " + sectionCount);
        List<Section> sections = ps.getSections();
        int nr = 0;
        for (Section sec : sections) {
            Property[] properties;
            ReadCustomPropertySets.out("   Section " + nr++ + ":");
            String s = sec.getFormatID().toString();
            s = s.substring(0, s.length() - 1);
            ReadCustomPropertySets.out("      Format ID: " + s);
            int propertyCount = sec.getPropertyCount();
            ReadCustomPropertySets.out("      No. of properties: " + propertyCount);
            for (Property p : properties = sec.getProperties()) {
                long id = p.getID();
                long type = p.getType();
                Object value = p.getValue();
                ReadCustomPropertySets.out("      Property ID: " + id + ", type: " + type + ", value: " + value);
            }
        }
    }

    private static void out(String msg) {
        System.out.println(msg);
    }
}

