/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.riff;

import com.drew.imaging.riff.RiffHandler;
import com.drew.imaging.riff.RiffProcessingException;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import java.io.IOException;

public class RiffReader {
    public void processRiff(@NotNull SequentialReader sequentialReader, @NotNull RiffHandler riffHandler) throws RiffProcessingException, IOException {
        int n;
        sequentialReader.setMotorolaByteOrder(false);
        String string = sequentialReader.getString(4);
        if (!string.equals("RIFF")) {
            throw new RiffProcessingException("Invalid RIFF header: " + string);
        }
        int n2 = n = sequentialReader.getInt32();
        String string2 = sequentialReader.getString(4);
        n2 -= 4;
        if (!riffHandler.shouldAcceptRiffIdentifier(string2)) {
            return;
        }
        while (n2 != 0) {
            String string3 = sequentialReader.getString(4);
            int n3 = sequentialReader.getInt32();
            if (n3 < 0 || (n2 -= 8) < n3) {
                throw new RiffProcessingException("Invalid RIFF chunk size");
            }
            if (riffHandler.shouldAcceptChunk(string3)) {
                riffHandler.processChunk(string3, sequentialReader.getBytes(n3));
            } else {
                sequentialReader.skip(n3);
            }
            n2 -= n3;
            if (n3 % 2 != 1) continue;
            sequentialReader.getInt8();
            --n2;
        }
    }
}

