/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.jvm;

import com.zerog.util.jvm.ValidatorUtils;
import com.zerog.util.jvm.Version;
import java.util.StringTokenizer;

public class Filter {
    public static final String JRE_JVM_TYPE = "JRE";
    public static final String JDK_JVM_TYPE = "JDK";
    public static final String ALL_JVM_TYPE = "ALL";
    public static final String UNKNOW_JVM_TYPE = "UNKNOW";
    private String vendor;
    private String type;
    private Version version;

    public Filter() {
    }

    public Filter(String string, String string2, String string3) {
        this.setVendor(string);
        this.setType(string2);
        if (string3 != null && string3.trim().length() > 0) {
            this.setVersion(Version.parse(string3));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String toString() {
        Object object = "";
        if (!ValidatorUtils.isEmpty(this.vendor)) {
            object = this.vendor;
        }
        if (!ValidatorUtils.isEmpty(this.type)) {
            object = ValidatorUtils.isEmpty((String)object) ? (String)object + this.type : (String)object + "_" + this.type;
        }
        if (this.version != null) {
            object = ValidatorUtils.isEmpty((String)object) ? (String)object + this.version.toString() : (String)object + "_" + this.version.toString();
        }
        return object;
    }

    public static Filter parse(String string) {
        block16: {
            block15: {
                if (string == null) break block15;
                if (!string.trim().equals("")) break block16;
            }
            return null;
        }
        Filter filter = new Filter();
        Object object = "";
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            block18: {
                block17: {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equalsIgnoreCase(JRE_JVM_TYPE)) break block17;
                    if (string2.equalsIgnoreCase(JDK_JVM_TYPE)) break block17;
                    if (!string2.equalsIgnoreCase(ALL_JVM_TYPE)) break block18;
                }
                filter.setType(string2);
                continue;
            }
            if (ValidatorUtils.containsOnlyDigitAndChars(string2, new char[]{'.', '_', '+', '*'})) {
                if (ValidatorUtils.isEmpty((String)object)) {
                    if (Version.isValid(string2)) {
                        object = string2;
                        bl = true;
                        continue;
                    }
                    return null;
                }
                if (bl) {
                    if (ValidatorUtils.contains(string2, '.') || ValidatorUtils.contains(string2, '*') || ValidatorUtils.contains(string2, '+')) {
                        if (ValidatorUtils.containsOnlyDigitAndChars(string2, new char[]{'*', '+'})) {
                            object = (String)object + "_" + string2;
                            continue;
                        }
                        if (!Character.isDigit(string2.charAt(0)) || !ValidatorUtils.contains(string2, '*')) continue;
                        object = (String)object + "_" + string2;
                        continue;
                    }
                    object = (String)object + "_" + string2;
                    continue;
                }
                object = (String)object + "_" + string2;
                continue;
            }
            filter.setVendor(string2);
        }
        if (!ValidatorUtils.isEmpty((String)object)) {
            filter.setVersion(Version.parse((String)object));
        }
        if (!Filter.isValid(filter, string)) {
            return null;
        }
        return filter;
    }

    private static boolean isValid(Filter filter, String string) {
        if (filter != null) {
            int n = 0;
            if (!ValidatorUtils.isEmpty(filter.getVendor())) {
                ++n;
            }
            if (!ValidatorUtils.isEmpty(filter.getType())) {
                ++n;
            }
            if (filter.getVersion() != null) {
                ++n;
                if (filter.getVersion().toString().indexOf(95) > -1) {
                    ++n;
                }
            }
            return n > 0 && ValidatorUtils.getCharCount(string, '_') == n - 1;
        }
        return false;
    }

    public static boolean isValid(String string) {
        return Filter.isValid(Filter.parse(string), string);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.type == null ? 0 : this.type.hashCode());
        n2 = 31 * n2 + (this.vendor == null ? 0 : this.vendor.hashCode());
        n2 = 31 * n2 + (this.version == null ? 0 : this.version.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Filter filter = (Filter)object;
        if (this.type == null ? filter.type != null : !this.type.equals(filter.type)) {
            return false;
        }
        if (this.vendor == null ? filter.vendor != null : !this.vendor.equals(filter.vendor)) {
            return false;
        }
        return !(this.version == null ? filter.version != null : !this.version.equals(filter.version));
    }
}

