/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.iseries.service;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400FTP;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSTextFileInputStream;
import com.ibm.as400.access.IFSTextFileOutputStream;
import com.ibm.as400.access.MessageQueue;
import com.zerog.ia.installer.IAStatus;
import com.zerog.ia.installer.iseries.i5OSLibraryBaseOverride;
import com.zerog.ia.installer.iseries.service.i5OSService;
import com.zerog.ia.installer.iseries.util.i5OSObjectCoord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class i5OSServiceImpl
implements i5OSService {
    private static File successFile = null;
    private static File errorFile = null;
    private static final String FNPIM_SUCCESS = "FNPIM_AUTHORIZED";
    private static final String FNPIM_ERROR = "FNPIM_NOTAUTHORIZED";
    private static final boolean NOISY = System.getProperty("debug.i5OSService") != null;
    private AS400Message[] lastMessages;
    private CommandCall command_;
    public static int seed = 0;
    private static transient int uniquifier = 0;
    private static String IATempPath = "/tmp/InstallAnywhere";
    private static String middleName = null;
    private static boolean installRemote;
    private static boolean registrationEnabled_;
    private static boolean checkedRemote;

    public i5OSServiceImpl() {
        this.lastMessages = new AS400Message[0];
        this.command_ = null;
    }

    public i5OSServiceImpl(String string) {
        try {
            this.geti5(string);
        }
        catch (Exception exception) {
            System.out.println("i5OSServiceImpl(string) threw Exception");
        }
        this.lastMessages = new AS400Message[0];
        this.command_ = null;
    }

    public IAStatus installResource() {
        return null;
    }

    public String getResourceName() {
        return "";
    }

    public String getResourceType() {
        return "iseries";
    }

    public String getResourcePath() {
        return "";
    }

    public String getResourceArguments() {
        return "";
    }

    public Object getService(Class clazz) {
        return super.getClass();
    }

    @Override
    public String normalizePathToi5(String string) {
        String string2 = string;
        String string3 = File.separator + File.separator;
        if (string2.startsWith(string3)) {
            string2 = string2.substring(1, string2.length());
        }
        String string4 = string;
        if (string4.indexOf(":") == 1) {
            string4 = string4.substring(2, string4.length());
        }
        return string4;
    }

    public void moveIFS2Client(AS400 aS400, IFSFile iFSFile, String string) throws IOException, FileNotFoundException {
        AS400FTP aS400FTP = new AS400FTP(aS400);
        aS400FTP.setDataTransferType(1);
        aS400FTP.get(iFSFile.getAbsolutePath(), string);
        iFSFile.delete();
    }

    @Override
    public void moveIFS2Client(AS400 aS400, IFSFile iFSFile, String string, boolean bl) throws IOException, FileNotFoundException {
        AS400FTP aS400FTP = new AS400FTP(aS400);
        aS400FTP.setDataTransferType(1);
        aS400FTP.get(iFSFile.getAbsolutePath(), string);
        if (!bl) {
            iFSFile.delete();
        }
    }

    public void moveModule2Host(AS400 aS400, File file, String string) throws IOException, FileNotFoundException {
        AS400FTP aS400FTP = new AS400FTP(aS400);
        aS400FTP.setDataTransferType(1);
        aS400FTP.put(file, string);
        file.delete();
    }

    @Override
    public void moveModule2Host(AS400 aS400, File file, String string, boolean bl) throws IOException, FileNotFoundException {
        AS400FTP aS400FTP = new AS400FTP(aS400);
        aS400FTP.setDataTransferType(1);
        aS400FTP.put(file, string);
        if (!bl) {
            file.delete();
        }
    }

    private void setLastMessages(AS400Message[] aS400MessageArray) {
        if (aS400MessageArray == null) {
            this.lastMessages = new AS400Message[0];
        } else {
            AS400Message[] aS400MessageArray2 = new AS400Message[aS400MessageArray.length];
            System.arraycopy(aS400MessageArray, 0, aS400MessageArray2, 0, aS400MessageArray.length);
            this.lastMessages = aS400MessageArray2;
        }
    }

    private AS400Message[] getLastMessages() {
        if (this.lastMessages == null) {
            return new AS400Message[0];
        }
        AS400Message[] aS400MessageArray = new AS400Message[this.lastMessages.length];
        System.arraycopy(this.lastMessages, 0, aS400MessageArray, 0, this.lastMessages.length);
        return aS400MessageArray;
    }

    @Override
    public String nextUniquifier() {
        int n = 4;
        Object object = new Integer(uniquifier++).toString();
        object = ((String)object).trim();
        int n2 = n;
        while (n2 > ((String)object).length()) {
            object = "0" + (String)object;
        }
        if (((String)object).length() > n) {
            object = ((String)object).substring(((String)object).length() - n);
        }
        return object;
    }

    @Override
    public int getSystemCompatibility() {
        return 100;
    }

    @Override
    public void logToQHST(String string) {
        try {
            i5OSObjectCoord i5OSObjectCoord2 = new i5OSObjectCoord();
            AS400 aS400 = i5OSObjectCoord.getAS400Object();
            MessageQueue messageQueue = new MessageQueue(aS400, "/QSYS.LIB/QHST.MSGQ");
            messageQueue.sendInformational(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getPropertiesResourceName() {
        return "i5OS.properties";
    }

    @Override
    public String generateName(int n) {
        int n2;
        Object object;
        if (n == 999) {
            n = 0;
            middleName = null;
        }
        if (middleName == null) {
            object = new Integer((int)(Math.random() * 10000.0));
            middleName = ((Integer)object).toString();
            n2 = 4;
            while (n2 > middleName.length()) {
                middleName = "0" + middleName;
            }
        }
        object = new Integer(n + 1).toString();
        object = ((String)object).trim();
        n2 = 3;
        while (n2 > ((String)object).length()) {
            object = "0" + (String)object;
        }
        return "Q" + middleName + (String)object;
    }

    @Override
    public boolean makeI5Dirs(IFSFile iFSFile) throws IOException {
        return iFSFile.mkdirs();
    }

    @Override
    public OutputStream sendTextOutStream(AS400 aS400, String string, int n) throws IOException, AS400SecurityException, IOException {
        return new IFSTextFileOutputStream(aS400, string, n);
    }

    @Override
    public InputStream retrieveTextInStream(AS400 aS400, String string, int n) throws IOException, AS400SecurityException, IOException {
        return new IFSTextFileInputStream(aS400, string, n);
    }

    @Override
    public int getCCSID(IFSFile iFSFile) throws Exception {
        IFSFile iFSFile2 = new IFSFile(this.geti5(), iFSFile.getAbsolutePath());
        return iFSFile2.getCCSID();
    }

    @Override
    public AS400 geti5() throws Exception {
        i5OSObjectCoord i5OSObjectCoord2;
        i5OSObjectCoord i5OSObjectCoord3 = i5OSObjectCoord2 = new i5OSObjectCoord();
        return i5OSObjectCoord.getAS400Object();
    }

    public AS400 geti5(String string) throws Exception {
        i5OSObjectCoord i5OSObjectCoord2;
        i5OSObjectCoord i5OSObjectCoord3 = i5OSObjectCoord2 = new i5OSObjectCoord(Flexeraavu.ab(string, "/"));
        return i5OSObjectCoord.getAS400Object();
    }

    @Override
    public AS400Message[] getLastMessageArray() throws Exception {
        return this.getLastMessages();
    }

    @Override
    public boolean deleteIFS(IFSFile iFSFile) throws IOException {
        return iFSFile.delete();
    }

    @Override
    public boolean deleteIFSRecursively(IFSFile iFSFile) throws IOException {
        boolean bl = true;
        if (iFSFile.exists()) {
            if (iFSFile.isDirectory()) {
                IFSFile[] iFSFileArray = iFSFile.listFiles();
                for (int i = 0; i < iFSFileArray.length; ++i) {
                    bl = iFSFileArray[i].isDirectory() ? bl && this.deleteIFSRecursively(iFSFileArray[i]) : bl && iFSFileArray[i].delete();
                }
                bl = bl && iFSFile.delete();
            }
        } else {
            return iFSFile.delete();
        }
        return bl;
    }

    @Override
    public boolean runCLCommand(AS400 aS400, String string, String[] stringArray) throws Exception {
        boolean bl;
        block12: {
            block11: {
                bl = false;
                if (aS400 == null) {
                    throw new Exception("i5 parameter cannot be null.");
                }
                if (string == null) break block11;
                if (!string.equals("")) break block12;
            }
            throw new Exception("commandName parameter (\"" + string + "\") is invalid.");
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(" " + stringArray[i].trim());
                }
            }
            String string2 = stringBuffer.toString();
            if (this.command_ == null) {
                this.command_ = new CommandCall(aS400, string2);
                this.command_.setThreadSafe(false);
            } else {
                this.command_.setCommand(string2);
            }
            bl = this.command_.run();
            AS400Message[] aS400MessageArray = this.command_.getMessageList();
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                System.out.println(aS400MessageArray[i].getID() + " - " + aS400MessageArray[i].getText());
            }
            this.setLastMessages(aS400MessageArray);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public AS400Message[] runCLCommand(String string) throws Exception {
        this.runCLCommand(this.geti5(), string, null);
        return this.getLastMessageArray();
    }

    @Override
    public boolean isInstallRemote() throws Exception {
        if (!checkedRemote) {
            String string = System.getProperty("os.name");
            installRemote = !string.equals("OS/400");
            checkedRemote = true;
        }
        return installRemote;
    }

    @Override
    public int installType() throws Exception {
        return 1;
    }

    @Override
    public IFSFile createIFSTempDir() {
        try {
            i5OSObjectCoord i5OSObjectCoord2 = new i5OSObjectCoord();
            AS400 aS400 = i5OSObjectCoord2.getAS400Object();
            AS400 aS4002 = i5OSObjectCoord.getAS400Object();
            IFSFile iFSFile = new IFSFile(aS4002, IATempPath);
            iFSFile.mkdirs();
            iFSFile = new IFSFile(aS4002, IATempPath);
            boolean bl = false;
            IFSFile iFSFile2 = new IFSFile(aS4002, IATempPath + this.generateName(seed));
            iFSFile2.mkdirs();
            ++seed;
            return iFSFile2;
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            return null;
        }
    }

    @Override
    public File createTempDir(String string) {
        try {
            File file = null;
            File file2 = new File(string);
            file2.mkdirs();
            file2 = new File(string);
            boolean bl = false;
            do {
                if (!bl) {
                    file = new File(string + "/" + this.generateName(seed));
                }
                ++seed;
            } while (file.exists());
            return file;
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            return null;
        }
    }

    @Override
    public String getIATempPath() {
        return IATempPath;
    }

    @Override
    public int incrementSeed() {
        return seed + 1;
    }

    @Override
    public IFSFile createIFSTempFile() {
        try {
            i5OSObjectCoord i5OSObjectCoord2 = new i5OSObjectCoord();
            AS400 aS400 = i5OSObjectCoord2.getAS400Object();
            IFSFile iFSFile = new IFSFile(aS400, IATempPath);
            iFSFile.mkdirs();
            iFSFile = new IFSFile(aS400, IATempPath);
            boolean bl = false;
            while (!bl) {
                IFSFile iFSFile2 = new IFSFile(aS400, IATempPath + "/" + this.generateName(seed));
                ++seed;
                if (iFSFile2.exists()) continue;
                return iFSFile2;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public void copyLocalToi5OS(String string, String string2) throws Exception {
        this.copyLocalToi5OS(new String[]{string}, new String[]{string2});
    }

    @Override
    public IFSFile createIFSDir(String string) {
        try {
            i5OSObjectCoord i5OSObjectCoord2 = new i5OSObjectCoord();
            AS400 aS400 = i5OSObjectCoord2.getAS400Object();
            AS400 aS4002 = i5OSObjectCoord.getAS400Object();
            IFSFile iFSFile = new IFSFile(aS4002, IATempPath + "/" + string);
            iFSFile.mkdirs();
            return iFSFile;
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            return null;
        }
    }

    @Override
    public String createIFSFile(String string) {
        try {
            i5OSObjectCoord i5OSObjectCoord2 = new i5OSObjectCoord();
            AS400 aS400 = i5OSObjectCoord2.getAS400Object();
            AS400 aS4002 = i5OSObjectCoord.getAS400Object();
            IFSFile iFSFile = new IFSFile(aS4002, string);
            iFSFile.mkdirs();
            return iFSFile.getAbsolutePath();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            return null;
        }
    }

    @Override
    public boolean testIFSWithTempPathExists(String string) {
        try {
            i5OSObjectCoord i5OSObjectCoord2 = new i5OSObjectCoord();
            AS400 aS400 = i5OSObjectCoord2.getAS400Object();
            AS400 aS4002 = i5OSObjectCoord.getAS400Object();
            IFSFile iFSFile = new IFSFile(aS4002, IATempPath + "/" + string);
            return iFSFile.exists();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public long testIFSFileTimeStamp(String string) {
        try {
            IFSFile iFSFile = new IFSFile(this.geti5(), string);
            return iFSFile.lastModified();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            return 0L;
        }
    }

    @Override
    public boolean testIFSPathExists(String string) {
        try {
            i5OSObjectCoord i5OSObjectCoord2 = new i5OSObjectCoord();
            AS400 aS400 = i5OSObjectCoord2.getAS400Object();
            AS400 aS4002 = i5OSObjectCoord.getAS400Object();
            IFSFile iFSFile = new IFSFile(aS4002, string);
            return iFSFile.exists();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public void copyLocalToi5OS(String[] stringArray, String[] stringArray2) throws Exception {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                String string = this.normalizePathToi5(stringArray2[i]);
                if (!file.exists() || !file.isFile()) continue;
                if (string == "") continue;
                AS400 aS400 = this.geti5();
                String string2 = this.normalizePathToi5(string);
                IFSFile iFSFile = new IFSFile(aS400, string2);
                IFSFile iFSFile2 = new IFSFile(aS400, iFSFile.getParent());
                iFSFile2.mkdirs();
                IFSFileOutputStream iFSFileOutputStream = new IFSFileOutputStream(i5OSObjectCoord.getAS400Object(), string2);
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[65536];
                int n = fileInputStream.read(byArray);
                while (n > 0) {
                    iFSFileOutputStream.write(byArray, 0, n);
                    n = fileInputStream.read(byArray);
                }
                iFSFileOutputStream.close();
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    @Override
    public void copyi5OSToLocal(String string, String string2) throws Exception {
        this.copyi5OSToLocal(new String[]{string}, new String[]{string2});
    }

    @Override
    public void copyi5OSToLocal(String[] stringArray, String[] stringArray2) throws Exception {
        try {
            for (int i = 0; i < stringArray2.length; ++i) {
                String string = this.normalizePathToi5(stringArray[i]);
                AS400 aS400 = this.geti5();
                IFSFile iFSFile = new IFSFile(aS400, string);
                if (!iFSFile.exists() || !iFSFile.isFile()) continue;
                IFSFileInputStream iFSFileInputStream = new IFSFileInputStream(aS400, string);
                File file = new File(stringArray2[i]);
                File file2 = new File(file.getParent());
                if (!file2.exists() || !file2.isDirectory()) {
                    file2.mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[65536];
                int n = iFSFileInputStream.read(byArray);
                while (n > 0) {
                    fileOutputStream.write(byArray, 0, n);
                    n = iFSFileInputStream.read(byArray);
                }
                iFSFileInputStream.close();
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    @Override
    public String resolveLibraryName(String string) throws Exception {
        return i5OSLibraryBaseOverride.resolveLib(string);
    }

    public static void main(String[] stringArray) {
        i5OSServiceImpl i5OSServiceImpl2 = new i5OSServiceImpl();
        try {
            i5OSServiceImpl2.runCLCommand("touch /tmp/edtestok");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void findiasignon(String string) throws Exception {
        if (string != null) {
            if (!string.startsWith("$")) {
                String[] stringArray = new String[3];
                string = string.toUpperCase();
                string = string.replace('\\', '/');
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                if (stringTokenizer.hasMoreElements()) {
                    stringArray[0] = (String)stringTokenizer.nextElement();
                }
                if (stringTokenizer.hasMoreElements()) {
                    stringArray[1] = (String)stringTokenizer.nextElement();
                }
                if (stringTokenizer.hasMoreElements()) {
                    stringArray[2] = (String)stringTokenizer.nextElement();
                }
                i5OSObjectCoord i5OSObjectCoord2 = new i5OSObjectCoord(stringArray);
                return;
            }
        }
        i5OSObjectCoord i5OSObjectCoord3 = new i5OSObjectCoord();
    }

    @Override
    public File getFailureFile() {
        errorFile = new File(IATempPath, FNPIM_ERROR);
        return errorFile;
    }

    @Override
    public File getSuccessFile() {
        successFile = new File(IATempPath, FNPIM_SUCCESS);
        return successFile;
    }

    @Override
    public boolean isConnected() {
        return i5OSObjectCoord.getConnectResult() == 2;
    }

    static {
        registrationEnabled_ = false;
        checkedRemote = false;
    }
}

