/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer;

import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.LifeCycleManager;
import com.zerog.ia.installer.actions.Version;
import com.zerog.ia.installer.util.VariableFacade;
import com.zerog.ia.installer.util.VariableManager;
import com.zerog.util.IAResourceBundle;
import com.zerog.util.TemporaryDirectory;
import com.zerog.util.ZGUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerFactory;

public class InstallerUpdate {
    private static InstallerUpdate instance = null;
    private Flexeraax6 iaUpdateXmlParser = null;
    private Installer installer;
    private String downloadUrl = "";
    private String ID_ATTRIB = "Id";
    private String VERSION_ATTRIB = "Version";
    private String OS_ATTRIB = "OS";
    private String URL_ATTRIB = "Url";
    private String NOVM_ATTRIB = "NoVM";
    private String VM_ATTRIB = "VM";
    private String UPDATE_ID_KEY = "Id";
    private String VERSION_KEY = "LatestVersion";
    private String VM_URL_KEY = "VMURL";
    private String NOVM_URL_KEY = "NoVMURL";
    private Map iaUpdateProps = new HashMap();
    private boolean isInstallerUpdateRequired = false;
    private final String BUILD_TARGET_WINDOWS = IAResourceBundle.getValue("Designer.Customizer.windows");
    private final String BUILD_TARGET_LINUX = IAResourceBundle.getValue("Designer.Customizer.TBuild.linux");
    private final String BUILD_TARGET_MAC = IAResourceBundle.getValue("Designer.Customizer.macOSX");
    private final String BUILD_TARGET_SOLARIS = IAResourceBundle.getValue("Designer.Customizer.TBuild.solaris");
    private final String BUILD_TARGET_AIX = IAResourceBundle.getValue("Designer.Customizer.TBuild.aix");
    private final String BUILD_TARGET_HPUX = IAResourceBundle.getValue("Designer.Customizer.TBuild.hpux");
    private final String BUILD_TARGET_GENERIC_UNIX = IAResourceBundle.getValue("Designer.Customizer.TBuild.unixAll");
    private final String BUILD_TARGET_UNIX_WITH_VM = IAResourceBundle.getValue("Designer.Customizer.TBuild.unixWithVM");
    private final String BUILD_TARGET_WINDOWS_PURE_64_BIT = IAResourceBundle.getValue("Designer.Customizer.windows64");
    private final String NAMESPACE_VAL = "installanywhere/2024/update";
    public static final String XML_BUILD_TARGET = "UpdateMetadata";
    private final String ROOT_ELEMENT = "Metadata";
    private final String UPDATE_ELEMENT = "Update";
    private final String TARGET_ELEMENT = "Target";
    private final String NAMESPACE_ATTRIB = "xmlns";
    private final String UNIX_WITH_VM = "UNIX_with_VM";
    private boolean DOWNLOAD_COMPLETE = false;
    private boolean CANCEL_FLAG = false;
    private String CANCELLED = "Cancelled";
    private final String ANONYMOUS_KEY = "AnonymousDownload?dkey";
    private final String ANONYMOUS = "Anonymous";
    public static final String TARGET_WINDOWS = "Windows";
    public static final String TARGET_LINUX = "Linux";
    public static final String TARGET_MAC = "MacOSX";
    public static final String TARGET_SOLARIS = "Solaris";
    public static final String TARGET_AIX = "AIX";
    public static final String TARGET_HPUX = "HPUX";
    public static final String TARGET_GENERIC_UNIX = "GenericUnix";
    public static final String TARGET_UNIX_WITH_VM = "UNIX_with_VM";
    public static final String TARGET_WINDOWS_PURE_64_BIT = "Windows_Pure_64_Bit";
    public static final String IAUPDATE_XML = "iaupdate.xml";
    public static final String INVALID = "Invalid";
    private JFrame parentFrame = null;
    public volatile String macDownloadedPath = "";
    public boolean macLaunchSuccess = false;
    private String anonymousAppFile = "Anonymous";

    public void doInstallerUpdateAction(Installer installer, String string) {
        String string2;
        block14: {
            block13: {
                this.installer = installer;
                string2 = string.trim();
                if (string2 != null && string2.length() == 0) {
                    Flexeraavf.aj("Installer update : Unable to check for updates as DownloadUrl is blank.");
                    return;
                }
                if (!InstallerUpdate.isValid(string2)) break block13;
                if (string2.endsWith(IAUPDATE_XML)) break block14;
            }
            Flexeraavf.aj("Installer update : Unable to check for updates as DownloadUrl is invalid.");
            return;
        }
        this.CANCEL_FLAG = false;
        String string3 = this.connectToServerAndDownload(string2, IAUPDATE_XML);
        if (string3 == null) {
            Flexeraavf.aj("Installer Update : Unable to connect to server and download " + string2);
            return;
        }
        try {
            String string4;
            Flexeraax6 flexeraax6 = new Flexeraax6(new File(string3));
            Flexeraax3 flexeraax3 = flexeraax6.aa();
            String string5 = installer.getInstallerInfoData().getProductID().toString();
            int n = this.getUpdateElementIndex(flexeraax3, string5);
            if (n == 0) {
                Flexeraavf.aj("Installer Update : Product code not found in iaupdate.xml");
                return;
            }
            if ((string4 = this.readLatestVersion(flexeraax3, --n)).trim().length() == 0) {
                Flexeraavf.aj("Installer Update : Latest Version is blank or cannot be read from " + string2);
                return;
            }
            if (this.compareAndVerifyUpdateIsRequired(string4)) {
                this.isInstallerUpdateRequired = true;
                if (this.parseXMLAndPopulateValues(flexeraax3, string4, n)) {
                    Flexeraavf.aj("Installer Update required: Found latest version " + string4);
                }
            }
        }
        catch (Throwable throwable) {
            this.isInstallerUpdateRequired = false;
            Flexeraavf.aj("Installer Update : Could not parse " + string2 + " as invalid tags found ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String connectToServerAndDownload(String string, String object) {
        byte[] byArray;
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        Object object2 = "";
        try {
            block29: {
                block28: {
                    if (((String)object).contains("AnonymousDownload?dkey")) break block28;
                    if (!((String)object).contains("?")) break block29;
                }
                object = "Anonymous";
                if (ZGUtil.MACOS || ZGUtil.MACOSX) {
                    object = (String)object + ".zip";
                } else if (ZGUtil.UNIX && !ZGUtil.MACOSX) {
                    object = (String)object + ".bin";
                }
            }
            object2 = this.getTempPath() + File.separator + (String)object;
            URL uRL = new URL(string);
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            fileOutputStream = new FileOutputStream((String)object2);
            byArray = new byte[1024];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                fileOutputStream.write(byArray, 0, n);
                if (!this.CANCEL_FLAG) continue;
                String string2 = this.CANCELLED;
                return string2;
            }
            if (new File((String)object2).length() == 0L) {
                String string3 = null;
                return string3;
            }
        }
        catch (Throwable throwable) {
            byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return object2;
    }

    private int getUpdateElementIndex(Flexeraax3 flexeraax3, String string) {
        int n = 0;
        int n2 = 0;
        try {
            for (Flexeraax3 flexeraax32 : flexeraax3.an()) {
                ++n2;
                String string2 = flexeraax32.be(this.ID_ATTRIB).trim();
                if (!string2.equalsIgnoreCase(string.trim())) continue;
                n = n2;
                break;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    private String readLatestVersion(Flexeraax3 flexeraax3, int n) {
        String string = "";
        try {
            if (!flexeraax3.an().isEmpty()) {
                Flexeraax3 flexeraax32 = (Flexeraax3)flexeraax3.an().get(n);
                string = flexeraax32.be(this.VERSION_ATTRIB).trim();
                string = string == null ? "" : string;
            }
        }
        catch (Throwable throwable) {
            string = "";
        }
        return string;
    }

    private boolean compareAndVerifyUpdateIsRequired(String string) {
        boolean bl = false;
        try {
            String string2 = this.installer.getInstallerInfoData().getVersionAsString().trim();
            Version version = new Version();
            version.setVersionFromString(VariableManager.getInstance().substitute(string2, true));
            Version version2 = new Version();
            version2.setVersionFromString(string);
            int n = version.compareTo(version2);
            if (n < 0) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            Flexeraavf.aj("Installer Update : Version comparision failed for some reason.");
            return false;
        }
        return bl;
    }

    private boolean parseXMLAndPopulateValues(Flexeraax3 flexeraax3, String string, int n) {
        boolean bl = false;
        try {
            Flexeraax3 flexeraax32 = (Flexeraax3)flexeraax3.an().get(n);
            String string2 = flexeraax32.be(this.ID_ATTRIB);
            this.iaUpdateProps.put(this.UPDATE_ID_KEY, string2);
            this.iaUpdateProps.put(this.VERSION_KEY, string);
            for (Flexeraax3 flexeraax33 : flexeraax32.an()) {
                String string3 = flexeraax33.be(this.OS_ATTRIB).toString().trim();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (Flexeraax3 flexeraax34 : flexeraax33.an()) {
                    if (flexeraax34.au().trim().equals(this.VM_ATTRIB)) {
                        hashMap.put(this.VM_URL_KEY, flexeraax34.be(this.URL_ATTRIB));
                        continue;
                    }
                    if (!flexeraax34.au().equals(this.NOVM_ATTRIB)) continue;
                    hashMap.put(this.NOVM_URL_KEY, flexeraax34.be(this.URL_ATTRIB));
                }
                this.iaUpdateProps.put(string3, hashMap);
            }
            bl = true;
        }
        catch (Exception exception) {
            Flexeraavf.aj("Installer Update : iaupdate.xml  could not be read");
            bl = false;
        }
        return bl;
    }

    public static boolean isValid(String string) {
        try {
            new URL(string).toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getUrlofTarget(String string, int n) {
        String string2;
        block7: {
            string = this.getMappedKey(string);
            string2 = "";
            try {
                for (String string3 : this.iaUpdateProps.keySet()) {
                    if (!string3.equalsIgnoreCase(string)) continue;
                    HashMap hashMap = (HashMap)this.iaUpdateProps.get(string);
                    if (n == 1) {
                        string2 = hashMap.containsKey(this.VM_URL_KEY) ? hashMap.get(this.VM_URL_KEY) : "";
                    } else if (n == 2) {
                        string2 = hashMap.containsKey(this.NOVM_URL_KEY) ? hashMap.get(this.NOVM_URL_KEY) : "";
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (n == 1) {
                    Flexeraavf.aj("Installer Update : VM URL is blank or does not exist");
                }
                if (n != 2) break block7;
                Flexeraavf.aj("Installer Update : NoVM URL is blank or does not exist");
            }
        }
        return string2;
    }

    private String getValidatedUrlofTarget(String string, int n) {
        String string2;
        block3: {
            block2: {
                String string3 = "";
                string2 = this.getUrlofTarget(string, n);
                if (string2.length() == 0) break block2;
                if (InstallerUpdate.isValid(string2)) break block3;
            }
            return INVALID;
        }
        return string2;
    }

    private String getTempPath() {
        Object object = "";
        try {
            object = ZGUtil.MACOSX && ZGUtil.isRunningAuthenticator() ? TemporaryDirectory.getSystemInstance().getAbsolutePath() : TemporaryDirectory.getCommonInstance().getAbsolutePath() + File.separator;
        }
        catch (Throwable throwable) {
            object = System.getProperty("java.io.tmpdir");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeToFile(File file, Flexeraax3 flexeraax3) {
        boolean bl = false;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            Flexeraax9.ad(flexeraax3, fileOutputStream);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.flush();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    private void recursiverlyAddTargetElements(Flexeraax3 flexeraax3, Map map) {
        try {
            for (String string : map.keySet()) {
                Flexeraax3 flexeraax32 = new Flexeraax3("Target");
                String string2 = this.getMappedKey(string);
                flexeraax32.bc(this.OS_ATTRIB, string2);
                flexeraax3.a1(flexeraax32);
                HashMap hashMap = (HashMap)map.get(string);
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3;
                    Flexeraax3 flexeraax33;
                    String string4 = ((String)iterator.next()).trim();
                    String string5 = this.getInstallerUrl();
                    if (string4.equalsIgnoreCase(this.VM_ATTRIB)) {
                        flexeraax33 = new Flexeraax3(this.VM_ATTRIB);
                        string3 = this.getPathByTarget(string5, string, string4, string2);
                        flexeraax33.bc(this.URL_ATTRIB, string3);
                        flexeraax32.a1(flexeraax33);
                        continue;
                    }
                    if (!string4.equalsIgnoreCase(this.NOVM_ATTRIB)) continue;
                    flexeraax33 = new Flexeraax3(this.NOVM_ATTRIB);
                    string3 = this.getPathByTarget(string5, string, string4, string2);
                    flexeraax33.bc(this.URL_ATTRIB, string3);
                    flexeraax32.a1(flexeraax33);
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getPathByTarget(String var1_1, String var2_2, String var3_3, String var4_4) {
        var5_5 = "";
        try {
            if (var2_2.equalsIgnoreCase(this.BUILD_TARGET_LINUX) || var2_2.equalsIgnoreCase(this.BUILD_TARGET_AIX) || var2_2.equalsIgnoreCase(this.BUILD_TARGET_SOLARIS) || var2_2.equalsIgnoreCase(this.BUILD_TARGET_GENERIC_UNIX) || var2_2.equalsIgnoreCase(this.BUILD_TARGET_HPUX)) ** GOTO lbl-1000
            if (var2_2.equalsIgnoreCase("UNIX_with_VM")) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            var6_6 = v0;
            var7_8 = var2_2.equalsIgnoreCase(this.BUILD_TARGET_MAC);
            v1 = var8_9 = var2_2.equalsIgnoreCase(this.BUILD_TARGET_WINDOWS) != false || var2_2.equalsIgnoreCase(this.BUILD_TARGET_WINDOWS_PURE_64_BIT) != false;
            if (var8_9) {
                var5_5 = var3_3.equalsIgnoreCase(this.VM_ATTRIB) != false ? "installer/" + var4_4 + "/VM/install.exe" : "installer/" + var4_4 + "/NoVM/install.exe";
            } else if (var6_6) {
                var5_5 = var3_3.equalsIgnoreCase(this.VM_ATTRIB) != false ? "installer/" + var4_4 + "/VM/install.bin" : "installer/" + var4_4 + "/NoVM/install.bin";
            } else if (var7_8) {
                v2 = var5_5 = var3_3.equalsIgnoreCase(this.VM_ATTRIB) != false ? "installer/" + var4_4 + "/VM/install.zip" : "installer/" + var4_4 + "/NoVM/install.zip";
            }
            if (var5_5.trim().length() > 0) {
                var5_5 = var1_1 + "/" + (String)var5_5;
            }
        }
        catch (Exception var6_7) {
            var5_5 = "";
        }
        return var5_5;
    }

    private String getInstallerUrl() {
        String string = "";
        try {
            String string2 = this.downloadUrl;
            if (string2 != null && string2.length() > 0) {
                int n = string2.lastIndexOf(File.separator);
                if (n < 0) {
                    n = string2.lastIndexOf("/");
                }
                string = string2.substring(0, n);
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    private String getMappedKey(String string) {
        String string2 = string;
        if (string.equalsIgnoreCase(this.BUILD_TARGET_WINDOWS)) {
            string2 = TARGET_WINDOWS;
        } else if (string.equalsIgnoreCase(this.BUILD_TARGET_WINDOWS_PURE_64_BIT)) {
            string2 = TARGET_WINDOWS_PURE_64_BIT;
        } else if (string.equalsIgnoreCase(this.BUILD_TARGET_LINUX)) {
            string2 = TARGET_LINUX;
        } else if (string.equalsIgnoreCase(this.BUILD_TARGET_AIX)) {
            string2 = TARGET_AIX;
        } else if (string.equalsIgnoreCase(this.BUILD_TARGET_SOLARIS)) {
            string2 = TARGET_SOLARIS;
        } else if (string.equalsIgnoreCase(this.BUILD_TARGET_HPUX)) {
            string2 = TARGET_HPUX;
        } else if (string.equalsIgnoreCase(this.BUILD_TARGET_GENERIC_UNIX)) {
            string2 = TARGET_GENERIC_UNIX;
        } else if (string.equalsIgnoreCase(this.BUILD_TARGET_MAC)) {
            string2 = TARGET_MAC;
        } else if (string.equalsIgnoreCase(this.BUILD_TARGET_UNIX_WITH_VM)) {
            string2 = TARGET_UNIX_WITH_VM;
        }
        return string2;
    }

    public void promptUserForUpdate(String string, String string2) {
        if (Flexeraaq7.az()) {
            int n = JOptionPane.showConfirmDialog(Flexeraark.an(new Flexeraat5()), string, string2, 0);
            if (n == 0) {
                this.doInstallLatest();
            }
        } else if (Flexeraaq7.ax()) {
            this.downloadLatestInstallerConsole(string);
        }
    }

    private void downloadLatestInstallerConsole(String string) {
        try {
            boolean bl = Flexeraac7.aa().promptAndYesNoChoice(string);
            if (bl) {
                this.doInstallLatest();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private boolean extractArchive(String string, String string2) {
        boolean bl = true;
        byte[] byArray = new byte[1024];
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                int n;
                String string3 = zipEntry.getName();
                File file = new File(string2 + File.separator + string3);
                new File(file.getParent()).mkdirs();
                if (string.contains("Anonymous") && file.getParentFile() != null) {
                    if (file.getParentFile().getName().equals("MacOS")) {
                        this.anonymousAppFile = file.getName();
                    }
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                while ((n = zipInputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.closeEntry();
            zipInputStream.close();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void doInstallLatest() {
        if (Flexeraaq7.az() || Flexeraaq7.ax()) {
            if (ZGUtil.MACOSX && ZGUtil.isRunningAuthenticator()) {
                try {
                    this.doMacAuthenticatedInstaller();
                    return;
                }
                catch (Throwable throwable) {
                    this.macLaunchSuccess = false;
                    Flexeraavf.aj("Installer Update : Unable to launch latest version of installer");
                    return;
                }
            }
            String string = this.getInstallerDownloadUrl();
            if (string.equalsIgnoreCase(INVALID)) {
                Flexeraavf.aj("Installer Update : Url provided for latest installer is empty or invalid");
                return;
            }
            String string2 = string.substring(string.lastIndexOf("/") + 1);
            int n = 1;
            if (Flexeraaq7.az()) {
                n = 1;
                this.showProgress();
            } else if (Flexeraaq7.ax()) {
                n = 2;
                Flexeraac7.aa().wprintln(IAResourceBundle.getValue("InstallerUpdate.downloadProgress"));
            }
            String string3 = this.connectToServerAndDownload(string, string2);
            if (string3 == null) {
                this.DOWNLOAD_COMPLETE = true;
                Flexeraavf.aj("Installer Update : Downloading update failed");
                return;
            }
            if (string3.equalsIgnoreCase(this.CANCELLED)) {
                Flexeraavf.aj("Installer Update : Downloading update cancelled");
                return;
            }
            this.DOWNLOAD_COMPLETE = true;
            boolean bl = this.doLaunch(string3, n);
            if (!bl) {
                Flexeraavf.aj("Installer Update : Unable to launch latest version of installer");
                return;
            }
            Flexeraavf.aj("Installer Update : Update installer launched");
            System.exit(0);
        }
    }

    public void doMacAuthenticatedInstaller() {
        this.macLaunchSuccess = false;
        Thread thread = new Thread(){

            @Override
            public void run() {
                String string = InstallerUpdate.this.getInstallerDownloadUrl();
                if (string.equalsIgnoreCase(InstallerUpdate.INVALID)) {
                    Flexeraavf.aj("Installer Update : Url provided for latest installer is empty or invalid");
                    return;
                }
                String string2 = string.substring(string.lastIndexOf("/") + 1);
                int n = 1;
                if (Flexeraaq7.az()) {
                    n = 1;
                    InstallerUpdate.this.showProgress();
                } else if (Flexeraaq7.ax()) {
                    n = 2;
                    Flexeraac7.aa().wprintln(IAResourceBundle.getValue("InstallerUpdate.downloadProgress"));
                }
                InstallerUpdate.this.macDownloadedPath = InstallerUpdate.this.connectToServerAndDownload(string, string2);
                if (InstallerUpdate.this.macDownloadedPath == null) {
                    InstallerUpdate.this.DOWNLOAD_COMPLETE = true;
                    Flexeraavf.aj("Installer Update : Downloading update failed");
                    return;
                }
                if (InstallerUpdate.this.macDownloadedPath.equalsIgnoreCase(InstallerUpdate.this.CANCELLED)) {
                    Flexeraavf.aj("Installer Update : Downloading update cancelled");
                    return;
                }
                InstallerUpdate.this.DOWNLOAD_COMPLETE = true;
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean bl = this.extractAndLaunchMacInstaller(new File(this.macDownloadedPath));
        if (!bl) {
            Flexeraavf.aj("Installer Update : Unable to launch latest version of installer");
            this.macLaunchSuccess = false;
            return;
        }
        Flexeraavf.aj("Installer Update : Update installer launched");
        this.macLaunchSuccess = true;
    }

    private void showProgress() {
        try {
            final Flexeraat0 flexeraat0 = this.createProgressBarDialog();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    flexeraat0.show();
                    flexeraat0.setTitle(IAResourceBundle.getValue("InstallerUpdate.downloadProgressTitle"));
                    flexeraat0.setVisible(true);
                    do {
                        if (InstallerUpdate.this.CANCEL_FLAG && InstallerUpdate.this.DOWNLOAD_COMPLETE || InstallerUpdate.this.parentFrame == null || !InstallerUpdate.this.parentFrame.isActive()) continue;
                        flexeraat0.setVisible(true);
                        flexeraat0.toFront();
                    } while (!InstallerUpdate.this.CANCEL_FLAG && !InstallerUpdate.this.DOWNLOAD_COMPLETE);
                    flexeraat0.setVisible(false);
                    flexeraat0.dispose();
                }
            };
            thread.start();
            thread.join(5000L);
        }
        catch (Throwable throwable) {
            Flexeraavf.aj("Installer Update : Unable to show download progress status");
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean doLaunch(String var1_1, int var2_2) {
        var3_3 = false;
        var4_4 = var1_1;
        try {
            if (ZGUtil.WIN32) {
                var4_4 = var1_1;
            } else if (ZGUtil.UNIX && !ZGUtil.MACOSX) {
                Runtime.getRuntime().exec("chmod 777 " + var1_1);
                var4_4 = var1_1;
            } else if (ZGUtil.MACOS || ZGUtil.MACOSX) {
                var4_4 = var1_1;
                var5_5 = new File("");
                var5_5 = var1_1.lastIndexOf(46) != -1 ? new File(var1_1.substring(0, var1_1.lastIndexOf(46)) + ".app") : new File(var1_1 + ".app");
                if (var5_5.exists()) {
                    var5_5.delete();
                }
                if (!(var6_7 = this.extractArchive(var1_1, this.getTempPath()))) {
                    var3_3 = false;
                    return var3_3;
                }
                Runtime.getRuntime().exec("chmod -R 777 " + (File)var5_5);
                var7_8 = var5_5.getAbsolutePath();
                var8_9 = var7_8 = var7_8.replace('\\', '/');
                var8_9 = var7_8.replace(" ", "\\ ");
                var4_4 = Flexeraacp.aa(var8_9, Flexeraacp.ab(var7_8), false);
                Runtime.getRuntime().exec("chmod -R  777 " + var4_4);
                var2_2 = 1;
            }
            v0 = var5_5 = var2_2 == 2 ? var4_4 + " -i console" : var4_4;
            if (var2_2 == 2 && ZGUtil.UNIX && !ZGUtil.MACOSX) {
                var3_3 = this.launchUnixInstaller((String)var5_5);
                return var3_3;
            }
            if (ZGUtil.UNIX && !ZGUtil.MACOSX) {
                var3_3 = this.launchUnixInstaller((String)var5_5);
                return var3_3;
            }
            if (ZGUtil.MACOS) ** GOTO lbl44
            if (ZGUtil.MACOSX) {
lbl44:
                // 2 sources

                if (var5_5.contains("Anonymous")) {
                    var5_5 = var5_5.replace("Anonymous", this.anonymousAppFile);
                    if (var5_5.lastIndexOf(".") == -1) {
                        var5_5 = (String)var5_5 + ".app";
                    }
                }
                Runtime.getRuntime().exec("open " + (String)var5_5);
            } else {
                Runtime.getRuntime().exec((String)var5_5);
            }
            var3_3 = true;
        }
        catch (Throwable var5_6) {
            var3_3 = false;
        }
        return var3_3;
    }

    public Flexeraat0 createProgressBarDialog() {
        final Flexeraat0 flexeraat0 = new Flexeraat0(null, "");
        Flexeraaub flexeraaub = new Flexeraaub(IAResourceBundle.getValue("InstallerUpdate.downloadProgress"));
        Flexeraacx flexeraacx = Flexeraacz.aa(0);
        Flexeraaub flexeraaub2 = new Flexeraaub();
        Flexeraats flexeraats = new Flexeraats(IAResourceBundle.getValue("PromptUserConsole.option1Label"));
        Flexeraat5 flexeraat5 = new Flexeraat5();
        flexeraat5.add(flexeraaub, 0, 0, 0, 1, 2, new Insets(0, 10, 20, 10), 18, 1.0, 0.0);
        flexeraat5.add((Component)((Object)flexeraacx), 0, 1, 0, 1, 2, new Insets(0, 10, 20, 10), 18, 1.0, 0.0);
        flexeraat5.add(flexeraaub2, 0, 2, 1, 1, 2, new Insets(0, 0, 0, 10), 18, 1.0, 0.0);
        flexeraat5.add(flexeraats, 1, 2, 1, 1, 2, new Insets(0, 10, 0, 10), 18, 0.0, 0.0);
        flexeraat0.getContentPane().add(flexeraat5);
        flexeraat0.setSize(new Dimension(400, 150));
        flexeraat0.setResizable(false);
        flexeraat0.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                InstallerUpdate.this.CANCEL_FLAG = true;
                flexeraat0.dispose();
            }
        });
        flexeraats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    InstallerUpdate.this.CANCEL_FLAG = true;
                    WindowAdapter windowAdapter = (WindowAdapter)flexeraat0.getWindowListeners()[1];
                    windowAdapter.windowClosing(new WindowEvent(flexeraat0, 201));
                }
                catch (Exception exception) {
                    flexeraat0.dispose();
                }
            }
        });
        return flexeraat0;
    }

    private static String getPlatform() {
        String string;
        block17: {
            string = "";
            String string2 = "";
            try {
                string2 = (String)VariableFacade.getInstance().getVariable("lax.resource.dir");
                if (ZGUtil.WIN32) {
                    string = string2.equalsIgnoreCase(TARGET_WINDOWS_PURE_64_BIT) ? TARGET_WINDOWS_PURE_64_BIT : TARGET_WINDOWS;
                    break block17;
                }
                if (ZGUtil.UNIX && !ZGUtil.MACOSX) {
                    if (string2.equalsIgnoreCase(TARGET_GENERIC_UNIX)) {
                        string = TARGET_GENERIC_UNIX;
                    } else if (string2.equalsIgnoreCase(TARGET_UNIX_WITH_VM)) {
                        string = TARGET_UNIX_WITH_VM;
                    } else if (ZGUtil.UNIX_AIX) {
                        string = TARGET_AIX;
                    } else if (ZGUtil.UNIX_SOLARIS) {
                        string = TARGET_SOLARIS;
                    } else if (ZGUtil.UNIX_LINUX) {
                        string = TARGET_LINUX;
                    } else if (ZGUtil.UNIX_HPUX) {
                        string = TARGET_HPUX;
                    }
                    break block17;
                }
                if (!ZGUtil.MACOS) {
                    if (!ZGUtil.MACOSX) break block17;
                }
                string = TARGET_MAC;
            }
            catch (Exception exception) {
                string = "";
            }
        }
        return string;
    }

    private String getInstallerDownloadUrl() {
        String string = "";
        string = LifeCycleManager.getInstaller().getInstaller().vmWasBundled() ? this.getValidatedVMUrlofTarget(InstallerUpdate.getPlatform()) : this.getValidatedNoVMUrlofTarget(InstallerUpdate.getPlatform());
        return string;
    }

    private boolean launchUnixInstaller(String string) {
        boolean bl = true;
        try {
            String[] stringArray = new String[3];
            stringArray[0] = "gnome-terminal";
            stringArray[1] = "-e";
            stringArray[2] = string;
            Runtime.getRuntime().exec(stringArray);
        }
        catch (Throwable throwable) {
            try {
                String[] stringArray = new String[3];
                stringArray[0] = "xterm";
                stringArray[1] = "-e";
                stringArray[2] = string;
                Runtime.getRuntime().exec(stringArray);
            }
            catch (Throwable throwable2) {
                try {
                    String[] stringArray = new String[3];
                    stringArray[0] = "konsole";
                    stringArray[1] = "-e";
                    stringArray[2] = string;
                    Runtime.getRuntime().exec(stringArray);
                }
                catch (Throwable throwable3) {
                    try {
                        String[] stringArray = new String[3];
                        stringArray[0] = "terminator";
                        stringArray[1] = "-e";
                        stringArray[2] = string;
                        Runtime.getRuntime().exec(stringArray);
                    }
                    catch (Throwable throwable4) {
                        bl = false;
                        return bl;
                    }
                }
            }
        }
        return bl;
    }

    public static synchronized InstallerUpdate getInstance() {
        if (instance == null) {
            instance = new InstallerUpdate();
        }
        return instance;
    }

    public boolean isInstallerUpdateRequired() {
        return this.isInstallerUpdateRequired;
    }

    public String getUpdateId() {
        String string = (String)this.iaUpdateProps.get(this.UPDATE_ID_KEY);
        return string == null ? "" : string;
    }

    public String getLatestVersion() {
        String string = (String)this.iaUpdateProps.get(this.VERSION_KEY);
        return string == null ? "" : string;
    }

    public String getVMUrlofTarget(String string) {
        String string2 = this.getUrlofTarget(string, 1);
        return string2;
    }

    public String getNoVMUrlofTarget(String string) {
        String string2 = this.getUrlofTarget(string, 2);
        return string2;
    }

    public String getValidatedNoVMUrlofTarget(String string) {
        String string2 = this.getValidatedUrlofTarget(string, 2);
        return string2;
    }

    public String getValidatedVMUrlofTarget(String string) {
        String string2 = this.getValidatedUrlofTarget(string, 1);
        return string2;
    }

    public boolean createXML(String string, Installer installer, Map map, String string2) {
        boolean bl = true;
        try {
            this.installer = installer;
            this.downloadUrl = string2;
            File file = new File(string);
            String string3 = file.getParent() != null ? file.getParent() : string;
            File file2 = new File(string3 + File.separator + XML_BUILD_TARGET);
            if (!file2.exists()) {
                file2.mkdir();
            }
            String string4 = file2 + File.separator + IAUPDATE_XML;
            File file3 = new File(string4);
            Flexeraax3 flexeraax3 = new Flexeraax3("Metadata");
            flexeraax3.bc("xmlns", "installanywhere/2024/update");
            flexeraax3.ad(Flexeraax5.aa);
            Flexeraax3 flexeraax32 = new Flexeraax3("Update");
            flexeraax32.bc(this.UPDATE_ID_KEY, installer.getInstallerInfoData().getProductID().toString());
            flexeraax32.bc(this.VERSION_ATTRIB, installer.getInstallerInfoData().getVersionAsString());
            flexeraax3.a1(flexeraax32);
            this.recursiverlyAddTargetElements(flexeraax32, map);
            if (this.writeToFile(file3, flexeraax3)) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public void initializeSplashParent(Window window) {
        try {
            if (window != null) {
                this.parentFrame = (JFrame)Flexeraark.an(window);
            }
        }
        catch (Exception exception) {
            this.parentFrame = null;
        }
    }

    public boolean extractAndLaunchMacInstaller(File file) {
        this.macLaunchSuccess = true;
        try {
            File file2;
            File file3 = new File(file.getParent());
            File file4 = new File(file3, file.getName().substring(0, file.getName().indexOf(".zip")) + ".app");
            file4.mkdirs();
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = null;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            InputStream inputStream = null;
            byte[] byArray = new byte[8192];
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) {
                    file2 = new File(file3, zipEntry.getName());
                    if (file2.exists()) continue;
                    file2.mkdirs();
                    continue;
                }
                inputStream = zipFile.getInputStream(zipEntry);
                if (inputStream == null) continue;
                file2 = new File(file3, zipEntry.getName());
                File file5 = new File(new File(file2.getAbsolutePath()).getParent());
                if (!file5.exists()) {
                    file5.mkdirs();
                }
                if (file.getName().contains("Anonymous") && file2.getParentFile() != null) {
                    if (file2.getParentFile().getName().equals("MacOS")) {
                        this.anonymousAppFile = file2.getName();
                    }
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                fileOutputStream.close();
            }
            if (file4.getName().contains("Anonymous")) {
                if (this.anonymousAppFile.lastIndexOf(".") == -1) {
                    this.anonymousAppFile = this.anonymousAppFile + ".app";
                }
                file2 = new File(this.getTempPath() + File.separator + this.anonymousAppFile);
                Runtime.getRuntime().exec("chmod -R 777 " + file2.getAbsolutePath());
                Runtime.getRuntime().exec("open " + file2.getAbsolutePath());
            } else {
                Runtime.getRuntime().exec("chmod -R 777 " + file4.getAbsolutePath());
                Runtime.getRuntime().exec("open " + file4.getAbsolutePath());
            }
            this.macLaunchSuccess = true;
        }
        catch (Throwable throwable) {
            this.macLaunchSuccess = false;
        }
        return this.macLaunchSuccess;
    }
}

