/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.MacWindowFunctions;
import com.apple.mrj.macos.generated.RectStruct;
import com.apple.mrj.macos.generated.WindowRecordStruct;
import com.apple.mrj.macos.toolbox.GrafPtr;
import com.apple.mrj.macos.toolbox.MenuHandle;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.Region;
import com.apple.mrj.macos.toolbox.Str255;
import com.apple.mrj.macos.toolbox.StringPtr;
import com.apple.mrj.macos.toolbox.ToolboxObject;

public class WindowRef
extends GrafPtr
implements ToolboxObject {
    private boolean hasGrowBox;
    public static final short documentProc = 0;
    public static final short dBoxProc = 1;
    public static final short plainDBox = 2;
    public static final short altDBoxProc = 3;
    public static final short noGrowDocProc = 4;
    public static final short movableDBoxProc = 5;
    public static final short zoomDocProc = 8;
    public static final short zoomNoGrow = 9;
    public static final short rDocProc = 16;
    public static final short dialogKind = 2;
    public static final short userKind = 8;
    public static final short inDesk = 0;
    public static final short inMenuBar = 1;
    public static final short inSysWindow = 2;
    public static final short inContent = 3;
    public static final short inDrag = 4;
    public static final short inGrow = 5;
    public static final short inGoAway = 6;
    public static final short inZoomIn = 7;
    public static final short inZoomOut = 8;
    private static RectStruct wideOpenBounds = new Rect(Short.MIN_VALUE, Short.MIN_VALUE, Short.MAX_VALUE, Short.MAX_VALUE).getRect();
    protected boolean owner;
    private Region updateRgn;

    WindowRecordStruct getWindowRecord() {
        return (WindowRecordStruct)this.data;
    }

    int getWindowPointer() {
        return this.data.getPointer();
    }

    protected void initialize() {
        this.data = new WindowRecordStruct(GrafPtr.getPort());
    }

    protected void initialize(int n) {
        this.data = new WindowRecordStruct(n);
    }

    public WindowRef(Rect rect, StringPtr stringPtr, boolean bl, short s, boolean bl2, int n) {
        super(MacWindowFunctions.NewCWindow(0, rect.getRect(), stringPtr.getBytes(), bl, s, -1, bl2, n));
        this.owner = false;
        this.hasGrowBox = s == 8;
    }

    public WindowRef(Rect rect, StringPtr stringPtr, boolean bl, boolean bl2, boolean bl3) {
        super(MacWindowFunctions.NewCWindow(0, rect.getRect(), stringPtr.getBytes(), bl, bl3 ? (short)8 : 4, -1, bl2, 0));
        this.owner = false;
        this.hasGrowBox = bl3;
    }

    public WindowRef(Rect rect, StringPtr stringPtr, boolean bl, boolean bl2) {
        this(rect, stringPtr, bl, bl2, true);
    }

    public WindowRef(int n) {
        this(n, true);
    }

    public WindowRef(int n, boolean bl) {
        this.data = new WindowRecordStruct(n);
        this.owner = bl;
    }

    WindowRef() {
        new Exception().printStackTrace();
    }

    public void dispose() {
        if (this.data != null) {
            if (!this.owner) {
                MacWindowFunctions.DisposeWindow(this.getWindowPointer());
            }
            this.data = null;
        }
    }

    public void setTitle(String string) {
        this.setTitle(new StringPtr(string));
    }

    public void setTitle(StringPtr stringPtr) {
        MacWindowFunctions.SetWTitle(this.getWindowPointer(), stringPtr.getBytes());
    }

    public String getTitle() {
        Str255 str255 = new Str255();
        MacWindowFunctions.GetWTitle(this.getWindowPointer(), str255.getByteArray());
        return str255.asString();
    }

    public void drawGrowIcon() {
        if (this.hasGrowBox) {
            MacWindowFunctions.DrawGrowIcon(this.getWindowPointer());
        }
    }

    public void select() {
        MacWindowFunctions.SelectWindow(this.getWindowPointer());
    }

    public void show() {
        MacWindowFunctions.ShowWindow(this.getWindowPointer());
    }

    public void hide() {
        MacWindowFunctions.HideWindow(this.getWindowPointer());
    }

    public void showHide(boolean bl) {
        MacWindowFunctions.ShowHide(this.getWindowPointer(), bl);
    }

    public void hilite(boolean bl) {
        MacWindowFunctions.HiliteWindow(this.getWindowPointer(), bl);
    }

    public void bringToFront() {
        MacWindowFunctions.BringToFront(this.getWindowPointer());
    }

    public void sendBehind(WindowRef windowRef) {
        MacWindowFunctions.SendBehind(this.getWindowPointer(), windowRef == null ? 0 : windowRef.getWindowPointer());
    }

    public static WindowRef getFrontWindow() {
        int n = MacWindowFunctions.FrontWindow();
        if (n != 0) {
            return new WindowRef(n);
        }
        return null;
    }

    public boolean isFront() {
        return MacWindowFunctions.FrontWindow() == this.getWindowPointer();
    }

    public void dragWindow(Point point) {
        MacWindowFunctions.DragWindow(this.getWindowPointer(), point.getPoint(), wideOpenBounds);
    }

    public void move(short s, short s2, boolean bl) {
        short s3;
        if (s2 < 0) {
            s2 = 0;
        }
        if (s2 < (s3 = (short)(MenuHandle.getMBarHeight() * 2))) {
            s2 = (short)(s2 + s3);
        }
        MacWindowFunctions.MoveWindow(this.getWindowPointer(), s, s2, bl);
    }

    public void move(short s, short s2) {
        this.move(s, s2, false);
    }

    public int grow(Point point, Rect rect) {
        return MacWindowFunctions.GrowWindow(this.getWindowPointer(), point.getPoint(), rect.getRect());
    }

    public void size(short s, short s2, boolean bl) {
        MacWindowFunctions.SizeWindow(this.getWindowPointer(), s, s2, bl);
    }

    public void size(short s, short s2) {
        this.size(s, s2, true);
    }

    public boolean trackGoAway(Point point) {
        return MacWindowFunctions.TrackGoAway(this.getWindowPointer(), point.getPoint());
    }

    public boolean trackBox(Point point, short s) {
        return MacWindowFunctions.TrackBox(this.getWindowPointer(), point.getPoint(), s);
    }

    public void zoom(short s, boolean bl) {
        MacWindowFunctions.ZoomWindow(this.getWindowPointer(), s, bl);
    }

    public void beginUpdate() {
        MacWindowFunctions.BeginUpdate(this.getWindowPointer());
    }

    public void endUpdate() {
        MacWindowFunctions.EndUpdate(this.getWindowPointer());
    }

    public void inval(Rect rect) {
        this.setPort();
        MacWindowFunctions.InvalRect(rect.getRect());
    }

    public void inval(Region region) {
        this.setPort();
        MacWindowFunctions.InvalRgn(region.getRegion());
    }

    public void valid(Rect rect) {
        this.setPort();
        MacWindowFunctions.ValidRect(rect.getRect());
    }

    public void valid(Region region) {
        this.setPort();
        MacWindowFunctions.ValidRgn(region.getRegion());
    }

    public Region getUpdateRgn() {
        if (this.updateRgn == null) {
            this.updateRgn = new Region(this.getWindowRecord().getUpdateRgn());
        }
        return this.updateRgn;
    }

    boolean inGrowZone(Point point) {
        Rect rect = this.getBounds();
        return this.hasGrowBox && point.getH() > rect.getWidth() - 15 && point.getV() > rect.getHeight() - 15;
    }

    public Point getOrigin() {
        Point point = new Point(0, 0);
        this.setPort();
        point.localToGlobal();
        return point;
    }

    public void setBounds(Rect rect) {
        this.move(rect.getLeft(), rect.getTop());
        this.size(rect.getWidth(), rect.getHeight());
    }

    public void update(Region region) {
        this.drawGrowIcon();
    }

    public void draw() {
        this.drawGrowIcon();
    }

    public WindowRef getWindowRef() {
        return this;
    }

    public void isVisible(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public boolean isVisible() {
        return this.getWindowRecord().getVisible();
    }

    public void isHilited(boolean bl) {
    }

    public boolean isHilited() {
        return this.getWindowRecord().getHilited();
    }

    public boolean hitTest(Point point) {
        return this.getBounds().contains(point);
    }

    protected void finalize() {
        this.data = null;
    }
}

