/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.internal.jdirect.TerminationListener;
import com.apple.mrj.internal.jdirect.TerminationServices;
import com.apple.mrj.macos.generated.MemoryFunctions;
import com.apple.mrj.macos.generated.SCStatusStruct;
import com.apple.mrj.macos.generated.SndChannelStruct;
import com.apple.mrj.macos.generated.SoundFunctions;
import com.apple.mrj.macos.toolbox.MacOSError;
import com.apple.mrj.macos.toolbox.SndCallBackListener;
import com.apple.mrj.macos.toolbox.SndCommand;
import com.apple.mrj.macos.toolbox.SoundHeader;

public class SndChannel
extends SndChannelStruct
implements TerminationListener {
    private boolean itsDidAllocateSoundChannel = false;
    public static final int stdQLength = 128;
    public static final short squareWaveSynth = 1;
    public static final short waveTableSynth = 3;
    public static final short sampledSynth = 5;
    private static final SndCommand freqCommand = new SndCommand(42);
    private static final SndCommand freqDurationCommand = new SndCommand(40);
    private static final SndCommand bufferCommand = new SndCommand(81);
    private static final SndCommand soundCommand = new SndCommand(80);
    private static final SndCommand quietCommand = new SndCommand(3);
    private static final SndCommand flushCommand = new SndCommand(4);
    private static final SndCommand callbackCommand = new SndCommand(13);
    private static final SCStatusStruct status = new SCStatusStruct();
    SndCallBackListener itsCallbackUPP;

    public SndChannel(short s, short s2) throws MacOSError {
        super(MemoryFunctions.NewPtrClear(1060 + s2 * 8));
        if (this.pointer == 0) {
            throw new OutOfMemoryError();
        }
        int n = MemoryFunctions.NewPtrSys(17408);
        if (n == 0) {
            throw new OutOfMemoryError();
        }
        MemoryFunctions.DisposePtr(n);
        this.setQLength(s2);
        int[] nArray = new int[]{this.pointer};
        short s3 = SoundFunctions.SndNewChannel(nArray, s, 0, 0);
        this.checkResult((int)s3);
        this.itsDidAllocateSoundChannel = true;
    }

    public SndChannel(short s) throws MacOSError {
        this(s, 128);
    }

    public void terminate() {
        if (this.pointer != 0) {
            if (this.itsDidAllocateSoundChannel) {
                SoundFunctions.SndDisposeChannel(this.pointer, true);
            }
            MemoryFunctions.DisposePtr(this.pointer);
        }
    }

    public void finalize() {
        TerminationServices.removeListener(this);
        this.terminate();
    }

    public void DoCommand(SndCommand sndCommand, boolean bl) throws MacOSError {
        short s = SoundFunctions.SndDoCommand(this, sndCommand, bl);
        this.checkResult((int)s);
    }

    public void DoImmediate(SndCommand sndCommand) throws MacOSError {
        short s = SoundFunctions.SndDoImmediate(this, sndCommand);
        this.checkResult((int)s);
    }

    public void PlayNote(int n) throws MacOSError {
        SndCommand sndCommand = freqCommand;
        synchronized (sndCommand) {
            freqCommand.setParam2(n);
            this.DoImmediate(freqCommand);
        }
    }

    public void PlayNote(int n, short s) throws MacOSError {
        SndCommand sndCommand = freqDurationCommand;
        synchronized (sndCommand) {
            freqDurationCommand.setParam1((short)(s * 2));
            freqDurationCommand.setParam2(n);
            this.DoImmediate(freqDurationCommand);
        }
    }

    public void PlaySound(SoundHeader soundHeader) {
        SndCommand sndCommand = bufferCommand;
        synchronized (sndCommand) {
            bufferCommand.setParam2(soundHeader.getPointer());
            this.DoCommand(bufferCommand, false);
        }
    }

    public void LoopSound(SoundHeader soundHeader) {
        SndCommand sndCommand = soundCommand;
        synchronized (sndCommand) {
            soundCommand.setParam2(soundHeader.getPointer());
            this.DoImmediate(soundCommand);
            this.PlayNote(60);
        }
    }

    public void Quiet() throws MacOSError {
        this.DoImmediate(quietCommand);
    }

    public void Flush() throws MacOSError {
        this.DoImmediate(flushCommand);
    }

    public boolean Busy() throws MacOSError {
        SCStatusStruct sCStatusStruct = status;
        synchronized (sCStatusStruct) {
            this.checkResult(SoundFunctions.SndChannelStatus(this, (short)status.getSize(), status));
            boolean bl = status.getScChannelBusy();
            Object var3_3 = null;
            return bl;
        }
    }

    public synchronized boolean Full() {
        short s;
        short s2 = this.getQHead();
        return s2 == (s = this.getQTail());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public synchronized short Capacity() {
        short s;
        block5: {
            short s2;
            short s3;
            short s4;
            short s5;
            block4: {
                s5 = this.getQLength();
                s4 = this.getQHead();
                s3 = this.getQTail();
                if (s4 == -1) {
                    return s5;
                }
                s = 0;
                if (!true) break block4;
                s2 = s3;
                s3 = (short)(s2 + 1);
                if (s2 == s4) break block5;
            }
            do {
                s = (short)(s + 1);
                if (s3 == s5) {
                    s3 = 0;
                }
                s2 = s3;
                s3 = (short)(s2 + 1);
            } while (s2 != s4);
        }
        return s;
    }

    public synchronized void CallBackWait() {
        if (this.itsCallbackUPP == null) {
            this.itsCallbackUPP = new SndCallBackListener(this);
            this.setCallBack(this.itsCallbackUPP.getPointer());
        }
        this.DoCommand(callbackCommand, false);
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    void checkResult(short s) throws MacOSError {
        if (s != 0) {
            throw new MacOSError(s);
        }
    }

    void checkResult(int n) throws MacOSError {
        if (n != 0) {
            throw new MacOSError(n);
        }
    }
}

