/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.toolbox.ControlHandle;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.Region;
import com.apple.mrj.macos.toolbox.ScrollPane;
import com.apple.mrj.macos.toolbox.ScrollPaneComponent;
import com.apple.mrj.macos.toolbox.ScrollPaneContents;
import com.apple.mrj.macos.toolbox.ToolboxObject;
import com.apple.mrj.macos.toolbox.WindowRef;

public class ScrollableView
implements ScrollPaneComponent,
ToolboxObject {
    ScrollPane myPane;
    Rect viewRect;
    Rect destRect;
    WindowRef window;
    ScrollPaneContents contents;

    public ScrollableView(ScrollPaneContents scrollPaneContents, Rect rect, boolean bl, boolean bl2, WindowRef windowRef) {
        this.viewRect = this.destRect = rect;
        this.window = windowRef;
        this.contents = scrollPaneContents;
        this.myPane = new ScrollPane(this, rect, bl, bl2, true);
    }

    public Rect getDestRect() {
        return this.destRect;
    }

    public Rect getViewRect() {
        return this.viewRect;
    }

    public int getScrollMax(Rect rect, Rect rect2, boolean bl) {
        return this.contents.getScrollMax(rect, rect2, bl);
    }

    public void adjustContentsForScrollBars(ControlHandle controlHandle, ControlHandle controlHandle2) {
        this.contents.adjustContentsForScrollBars(controlHandle, controlHandle2);
    }

    public void pinScroll(short s, short s2) {
        this.contents.pinScroll(s, s2);
    }

    public int getHLine(short s) {
        return this.contents.getHLine(s);
    }

    public int getVLine(short s) {
        return this.contents.getVLine(s);
    }

    public WindowRef getWindowRef() {
        return this.window;
    }

    public int getIdentifier() {
        return 0;
    }

    public boolean hitTest(Point point) {
        return this.myPane.hitTest(point) || this.viewRect.contains(point);
    }

    public void click(Point point) {
    }

    public void setScrollValues(short s, short s2) {
        this.myPane.hScrollValue(s);
        this.myPane.vScrollValue(s2);
    }

    public void size(short s, short s2) {
        Rect rect = this.getViewRect();
        Rect rect2 = this.getDestRect();
        this.getWindowRef().inval(rect);
        if (s != 0) {
            rect.setRight(rect.getRight() + s);
            rect2.setRight(rect2.getRight() + s);
        }
        if (s2 != 0) {
            rect.setBottom(rect.getRight() + s2);
            rect2.setBottom(rect2.getRight() + s2);
        }
        this.getWindowRef().valid(rect);
        this.draw();
    }

    public void isVisible(boolean bl) {
        this.myPane.isVisible(bl);
        this.contents.isVisible(bl);
    }

    public void isHilited(boolean bl) {
        this.myPane.isHilited(bl);
        this.contents.isHilited(bl);
    }

    public Rect getBounds() {
        return this.viewRect;
    }

    public void setBounds(Rect rect) {
        Rect rect2 = this.myPane.setBounds(rect);
        this.contents.setBounds(rect2);
        this.viewRect.set(rect2);
    }

    public void dispose() {
        this.myPane.dispose();
        this.contents.dispose();
        this.myPane = null;
        this.contents = null;
    }

    public void update(Region region) {
        this.draw();
    }

    public void draw() {
        this.myPane.draw();
        this.contents.draw();
    }

    public Point getOrigin() {
        return this.viewRect.topLeft();
    }
}

