/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.FolderFunctions;
import com.apple.mrj.macos.generated.LowMemFunctions;
import com.apple.mrj.macos.generated.TypesFunctions;
import com.apple.mrj.macos.toolbox.DataPointer;
import com.apple.mrj.macos.toolbox.FSSpec;
import com.apple.mrj.macos.toolbox.MacOSError;
import com.apple.mrj.macos.toolbox.ProcessSerialNumber;
import com.apple.mrj.macos.toolbox.StringPtr;
import com.apple.mrj.macos.toolbox.TranslateString;

public final class OSUtils {
    public static ProcessSerialNumber thisProcess = new ProcessSerialNumber();
    public static final int cTextFileType = 0x54455854;
    public static final int cJavaClassType = 1313836139;
    public static final String cJavaSrcFileExtension = ".java";
    public static final String cJavaClassFileExtension = ".class";
    public static final String cJavaProjectFileExtension = ".jproj";
    public static final short kOnSystemDisk = Short.MIN_VALUE;

    private OSUtils() {
    }

    public static String getAppName() {
        DataPointer dataPointer = new DataPointer(LowMemFunctions.LMGetCurApName(), 256);
        return TranslateString.pascalByteArrayToString(dataPointer.getBytes());
    }

    public static void debugStr(String string) {
        new StringPtr(string).debugStr();
    }

    public static void debugger() {
        TypesFunctions.Debugger();
    }

    public static final int makeOSType(char c, char c2, char c3, char c4) {
        return c << 24 | c2 << 16 | c3 << 8 | c4;
    }

    public static final int makeOSType(byte[] byArray) {
        byte[] byArray2 = new byte[4];
        int n = byArray.length >= 4 ? 4 : byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n2++];
        }
        if (byArray.length < 4) {
            int n3 = byArray.length;
            while (n3 < 4) {
                byArray2[n3++] = 0;
            }
        }
        return byArray2[0] << 24 | byArray2[1] << 16 | byArray2[2] << 8 | byArray2[3];
    }

    public static final int makeOSType(String string) {
        return OSUtils.makeOSType(string.charAt(0), string.charAt(1), string.charAt(2), string.charAt(3));
    }

    public static final String osTypeToString(int n) {
        char[] cArray = new char[4];
        int n2 = 0;
        while (n2 < 4) {
            cArray[3 - n2] = (char)(n & 0xFF);
            n >>= 8;
            ++n2;
        }
        return new String(cArray, 0, 4);
    }

    private static short findFolder(short s, int n, boolean bl, short[] sArray, int[] nArray) {
        return FolderFunctions.FindFolder(s, n, bl, sArray, nArray);
    }

    public static FSSpec findFolder(short s, int n, boolean bl) {
        short[] sArray = new short[]{s};
        int[] nArray = new int[]{2};
        MacOSError.checkResult(OSUtils.findFolder(s, n, bl, sArray, nArray));
        return new FSSpec(sArray[0], nArray[0]);
    }

    public static int getDoubleClickTicks() {
        return LowMemFunctions.LMGetDoubleTime();
    }
}

