/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.BalloonFunctions;
import com.apple.mrj.macos.generated.MenuConstants;
import com.apple.mrj.macos.generated.MenuFunctions;
import com.apple.mrj.macos.generated.MenuInfoStruct;
import com.apple.mrj.macos.generated.ResourceFunctions;
import com.apple.mrj.macos.generated.TextUtilFunctions;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Str255;
import com.apple.mrj.macos.toolbox.StringPtr;
import com.apple.mrj.macos.toolbox.TextUtilities;
import com.apple.mrj.macos.toolbox.TranslateString;

public class MenuHandle
implements MenuConstants {
    protected MenuInfoStruct data;
    Object owner;
    public static final char checkMark = '\u0012';
    public static final char bulletMark = '\u00a5';
    protected static final String helpMenuOwner = "MacOS";

    public MenuInfoStruct getMenu() {
        return this.data;
    }

    protected int getHandleValue() {
        return this.data.getHandle();
    }

    protected MenuHandle(int n) {
        this.data = new MenuInfoStruct(n);
    }

    protected MenuHandle(int n, Object object) {
        this(n);
        this.owner = object;
    }

    public static MenuHandle GetHelpMenu() {
        int[] nArray = new int[1];
        BalloonFunctions.HMGetHelpMenuHandle(nArray);
        return new MenuHandle(nArray[0], (Object)helpMenuOwner);
    }

    public static MenuHandle GetOwnedMenu(int n, Object object) {
        if (n != 0) {
            return new MenuHandle(n, object);
        }
        return null;
    }

    public MenuHandle() {
        this(0, "");
    }

    public MenuHandle(int n, String string) {
        this(MenuFunctions.NewMenu((short)n, TranslateString.asPascalBytes(string)));
    }

    public MenuHandle(short s, Str255 str255) {
        this(MenuFunctions.NewMenu(s, TranslateString.asPascalBytes(str255)));
    }

    public static MenuHandle GetResourceMenu(int n) {
        MenuHandle menuHandle = new MenuHandle(MenuFunctions.GetMenu((short)n));
        ResourceFunctions.DetachResource(menuHandle.getHandleValue());
        return menuHandle;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[label '" + this.getTitle() + ", id " + this.getMenuID() + "]";
    }

    public short countItems() {
        return MenuFunctions.CountMItems(this.getMenu());
    }

    public short getMenuID() {
        return this.getMenu().getMenuID();
    }

    public void setMenuID(int n) {
        this.getMenu().setMenuID((short)n);
    }

    public int getEnableFlags() {
        return this.getMenu().getEnableFlags();
    }

    public void setEnableFlags(int n) {
        this.getMenu().setEnableFlags(n);
    }

    public String getTitle() {
        byte[] byArray = this.getMenu().getMenuData();
        return TranslateString.asString(byArray, (short)1, byArray[0], TextUtilities.SystemFontScript);
    }

    public void setTitle(String string) {
        MenuInfoStruct menuInfoStruct = this.getMenu();
        byte[] byArray = menuInfoStruct.getMenuData();
        byte[] byArray2 = TranslateString.asPascalBytes(string);
        TextUtilFunctions.Munger(menuInfoStruct.getHandle(), 14, null, 1 + (byArray[0] & 0xFF), byArray2, 1 + (byArray2[0] & 0xFF));
    }

    public void getItemText(int n, Str255 str255) {
        MenuFunctions.GetMenuItemText(this.getMenu(), (short)n, str255.getByteArray());
    }

    public String getItemString(int n) {
        Str255 str255 = new Str255();
        this.getItemText(n, str255);
        return str255.toString();
    }

    public byte getItemCmd(int n) {
        short[] sArray = new short[1];
        MenuFunctions.GetItemCmd(this.getMenu(), (short)n, sArray);
        return (byte)sArray[0];
    }

    public void setItemCmd(int n, char c) {
        MenuFunctions.SetItemCmd(this.getMenu(), (short)n, (short)((byte)c));
    }

    public byte getItemMark(int n) {
        short[] sArray = new short[1];
        MenuFunctions.GetItemMark(this.getMenu(), (short)n, sArray);
        return (byte)sArray[0];
    }

    public void setItemMark(int n, char c) {
        MenuFunctions.SetItemMark(this.getMenu(), (short)n, (short)((byte)c));
    }

    public short setItemHierarchicalID(short s, short s2) {
        this.setItemCmd(s, '\u001b');
        this.setItemMark(s, (char)s2);
        return 0;
    }

    public boolean hasHierarchicalMenu(short s) {
        return this.getItemCmd(s) == 27;
    }

    public short getItemHierarchicalID(short s) {
        if (this.hasHierarchicalMenu(s)) {
            return this.getItemMark(s);
        }
        return 0;
    }

    public short getItemIcon(int n) {
        short[] sArray = new short[1];
        MenuFunctions.GetItemIcon(this.getMenu(), (short)n, sArray);
        return sArray[0];
    }

    public void setItemIcon(int n, short s) {
        MenuFunctions.SetItemIcon(this.getMenu(), (short)n, s);
    }

    public short setItemTextEncoding(int n, short s) {
        MenuFunctions.SetItemIcon(this.getMenu(), (short)n, s);
        MenuFunctions.SetItemCmd(this.getMenu(), (short)n, (short)28);
        return 0;
    }

    public short getItemStyle(int n) {
        byte[] byArray = new byte[1];
        MenuFunctions.GetItemStyle(this.getMenu(), (short)n, byArray);
        return byArray[0];
    }

    public void setItemStyle(int n, short s) {
        MenuFunctions.SetItemStyle(this.getMenu(), (short)n, s);
    }

    public int append(String string) {
        short[] sArray = new short[]{TextUtilities.SystemFontScript};
        MenuFunctions.AppendMenu(this.getMenu(), TranslateString.asPascalBytes(string, sArray, true));
        short s = this.countItems();
        this.setItemTextEncoding(s, sArray[0]);
        return s;
    }

    public int appendResMenu(int n) {
        MenuFunctions.AppendResMenu(this.getMenu(), n);
        return this.countItems();
    }

    public int insertResMenu(int n, int n2) {
        MenuFunctions.InsertResMenu(this.getMenu(), n, (short)n2);
        return this.countItems();
    }

    public void insert() {
        this.insert(0);
    }

    public void insert(MenuHandle menuHandle) {
        this.insert(menuHandle.getMenuID());
    }

    public void insert(int n) {
        MenuFunctions.InsertMenu(this.getMenu(), (short)n);
    }

    public void delete() {
        MenuFunctions.DeleteMenu(this.getMenuID());
    }

    public void insertItem(String string, int n) {
        this.insertItem(new StringPtr(string, true), n);
    }

    public void insertItem(StringPtr stringPtr, int n) {
        MenuFunctions.InsertMenuItem(this.getMenu(), stringPtr.getBytes(), (short)n);
        short s = stringPtr.getScript();
        this.setItemTextEncoding(n + 1, s);
    }

    public void deleteItem(int n) {
        MenuFunctions.DeleteMenuItem(this.getMenu(), (short)n);
    }

    public void hilite() {
        MenuFunctions.HiliteMenu(this.getMenuID());
    }

    public void setItemText(int n, String string) {
        this.setItemText(n, new StringPtr(string, 240, true));
    }

    public void setItemText(int n, String string, short[] sArray) {
        this.setItemText(n, new StringPtr(string, sArray, 240, true));
    }

    public void setItemText(int n, StringPtr stringPtr) {
        if (stringPtr.length() > 240) {
            stringPtr = new StringPtr(stringPtr, 240);
        }
        MenuFunctions.SetMenuItemText(this.getMenu(), (short)n, stringPtr.getBytes());
        short s = stringPtr.getScript();
        this.setItemTextEncoding(n, s);
    }

    public void disableItem(int n) {
        MenuFunctions.DisableItem(this.getMenu(), (short)n);
    }

    public void enableItem(int n) {
        MenuFunctions.EnableItem(this.getMenu(), (short)n);
    }

    public void checkItem(int n, boolean bl) {
        MenuFunctions.CheckItem(this.getMenu(), (short)n, bl);
    }

    public void calcMenuSize() {
        MenuFunctions.CalcMenuSize(this.getMenu());
    }

    public int countMenuItems() {
        return this.countItems();
    }

    public void flashMenuBar() {
        MenuFunctions.FlashMenuBar(this.getMenuID());
    }

    public void initProcMenu(int n) {
        MenuFunctions.InitProcMenu((short)n);
    }

    public int popupMenuSelect(int n, int n2, int n3) {
        return MenuFunctions.PopUpMenuSelect(this.getMenu(), (short)n, (short)n2, (short)n3);
    }

    public int menuChoice() {
        return MenuFunctions.MenuChoice();
    }

    public void insertFontResMenu(int n, int n2) {
        MenuFunctions.InsertFontResMenu(this.getMenu(), (short)n, (short)n2);
    }

    public void insertIntlResMenu(int n, int n2, int n3) {
        MenuFunctions.InsertIntlResMenu(this.getMenu(), n, (short)n2, (short)n3);
    }

    protected void dispose() {
        if (this.owner == null && this.getMenu() != null && this.getHandleValue() != 0) {
            MenuFunctions.DisposeMenu(this.getMenu());
        }
        this.data = null;
    }

    protected void finalize() {
        if (this.data != null) {
            this.dispose();
            this.data = null;
        }
    }

    public static void drawMenuBar() {
        MenuFunctions.DrawMenuBar();
    }

    public static int getMBarHeight() {
        return MenuFunctions.GetMBarHeight();
    }

    public static void invalMenuBar() {
        MenuFunctions.InvalMenuBar();
    }

    public static void clearMenuBar() {
        MenuFunctions.ClearMenuBar();
    }

    public static void flashMenuBar(int n) {
        MenuFunctions.FlashMenuBar((short)n);
    }

    public static void setMenuFlash(int n) {
        MenuFunctions.SetMenuFlash((short)n);
    }

    public static int menuKey(int n) {
        return MenuFunctions.MenuKey((short)(n & 0xFF));
    }

    public static int menuSelect(Point point) {
        return MenuFunctions.MenuSelect(point.getPoint());
    }

    public static int menuSelect(int n, int n2) {
        return MenuHandle.menuSelect(new Point(n, n2));
    }

    public static void hiliteMenu(int n) {
        MenuFunctions.HiliteMenu((short)n);
    }

    public static boolean systemEdit(short s) {
        return MenuFunctions.SystemEdit(s);
    }

    public static void systemMenu(int n) {
        MenuFunctions.SystemMenu(n);
    }

    public short setItemModifiers(short s, byte by) {
        return 0;
    }

    public short setItemKeyGlyph(short s, short s2) {
        return 0;
    }
}

